/*\
 *	DISTRIBUTION: HNMS v2.0
 *	FILE: hnmslib/hnmpdefs.h
 *
 *	Definitions for hnmslib/hnmp.c.
 *
 *	Jude George
 *	NAS Facility, NASA Ames Research Center
 *
 *	Copyright (c) 1994 Jude George
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/

/*\
 *  HNMP message types.  Abbreviations for the types in HNMP-types.h.
\*/
#define HNMP_ACK		type_HNMP_PDU_ack
#define HNMP_HELLO		type_HNMP_PDU_hello
#define HNMP_WELCOME		type_HNMP_PDU_welcome
#define HNMP_GOODBYE		type_HNMP_PDU_goodbye
#define HNMP_REDIRECT		type_HNMP_PDU_redirect
#define HNMP_GET_KEY		type_HNMP_PDU_get__key
#define HNMP_SEND_KEY		type_HNMP_PDU_send__key
#define HNMP_ANNOUNCE		type_HNMP_PDU_announce__object
#define HNMP_ACTIVATE		type_HNMP_PDU_activate__object
#define HNMP_DEACTIVATE		type_HNMP_PDU_deactivate__object
#define HNMP_DELETE		type_HNMP_PDU_delete__object
#define HNMP_SUB_RELATIONS	type_HNMP_PDU_subscribe__relations
#define HNMP_UNSUB_RELATIONS	type_HNMP_PDU_unsubscribe__relations
#define HNMP_SEND_RELATIONS	type_HNMP_PDU_send__relations
#define HNMP_SUB_DATA		type_HNMP_PDU_subscribe__data
#define HNMP_UNSUB_DATA		type_HNMP_PDU_unsubscribe__data
#define HNMP_SEND_DATA		type_HNMP_PDU_send__data
#define HNMP_SET_DATA		type_HNMP_PDU_set__data
#define HNMP_GET_DATA		type_HNMP_PDU_get__data
#define HNMP_GET_NEXT_DATA	type_HNMP_PDU_get__next__data
#define HNMP_GET_WALK_DATA	type_HNMP_PDU_get__walk__data

/*\
 *  Field identifiers for individual fields in HNMP messages.
 *  These are used with the Message_get() and Message_set() functions.
\*/
#define HNMP_msg_type		1
#define HNMP_version		2
#define HNMP_community		3
#define HNMP_from_module_type	4
#define HNMP_from_module_id	5
#define HNMP_to_module_id	6
#define HNMP_msg_id		7
#define HNMP_msg_timestamp	8
#define HNMP_ip_address		9
#define HNMP_object_id		10
#define HNMP_variables		11

/*\
 *  Type identifiers for variables used in HNMP messages.
 *  These are used with the VarBindList_get(), VarBindList_set(),
 *  and MIB_* functions.
\*/
#define	MIB_integer		1
#define MIB_enum		2
#define	MIB_timeticks		3
#define MIB_counter		4
#define	MIB_gauge		5
#define MIB_ipaddr		6
#define MIB_octetstring		7
#define MIB_displaystring	8
#define MIB_oid			9
#define MIB_null		10
#define MIB_sequence		11
#define MIB_regpoint		12
#define MIB_other		13

/*\
 *  Maximum size, in bytes, of an outgoing HNMP message.
\*/
#define HNMP_BUFSIZ		16384

/*\
 *  Well-known port for accepting connections.
\*/
#define	HNMP_PORT		6790

typedef struct type_HNMP_Message	*Message;
typedef struct type_HNMP_VarBind	*VarBind;
typedef struct type_HNMP_VarBindList	*VarBindList;
