/*\
 *	DISTRIBUTION: HNMS v2.0
 *	FILE: hnmslib/constants.c
 *
 *	Printable strings for HNMS.
 *
 *	Jude George
 *	NAS Facility, NASA Ames Research Center
 *
 *	Copyright (c) 1994 Jude George
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/

/*\
 *  Printable strings for HNMS error codes.
\*/
const char	*hnms_err_strs[] = {"no error",
					"memory allocation",
					"NULL value given to function",
					"file not found",
					"", "", "", "", "", "",
					"variable not found",
					"requested data type does not exist",
					"session not found",
					"", "", "", "", "", "", "",
					"bad HNMP message type",
					"bad HNMP message field",
					"", "", "", "", "", "", "", "",
					"opening socket",
					"setting non-blocking I/O on socket",
					"enabling re-use of addrs on socket",
					"enabling broadcast on socket",
					"binding socket",
					"select",
					"", "", "", "",
					"connection exists at address/port",
					"sendto",
					"message too long to be enqueued",
					"presentation stream",
					"re-use of message-id",
					"port already in use",
					"connection timed out",
					"message timed out",
					"send window full"};

/*\
 *  Printable strings for HNMP message names.
\*/
const char	*hnmp_msg_strs[] = {"", "ack", "hello", "welcome", "goodbye",
					"redirect", "get-key", "send-key",
					"announce", "delete",
					"activate", "deactivate",
					"sub-relations", "unsub-relations",
					"send-relations", "sub-data",
					"unsub-data", "send-data", "set-data",
					"get-data", "get-next-data",
					"get-walk-data"};

/*\
 *  Printable strings for interface classes.
\*/
const char	*if_types[] = {"", "other", "regular1822", "hdh1822",
				   "ddn-x25", "rfc877-825",
				   "ethernet-csmacd", "iso88023-csmacd",
				   "iso88024-tokenBus", "iso88025-tokenRing",
				   "iso88026-map", "starLan", "proteon-10Mbit",
				   "proteon-80Mbit", "hyperchannel", "fddi",
				   "lapb", "sdlc", "t1-carrier", "cept",
				   "basicISDN", "primaryISDN",
				   "propPointToPointSerial", "ppp",
				   "softwareLoopback", "eon", "ethernet-3Mbit",
				   "nsip", "slip"};

/*\
 *  Printable strings for route tiyes and route protocols.
\*/
const char	*rt_types[] = {"", "other", "invalid", "direct", "remote"};
const char	*rt_protocols[] = {"", "other", "local", "netmgmt", "icmp",
				       "egp", "ggp", "hello", "rip", "is-is",
				       "es-is", "ciscoIgrp", "bbnSpfIgp",
				       "ospf", "bgp"};

/*\
 *  Printable strings for HNMS reachability status values.
\*/
const char	*status_strs[] = {"unknown", "responsive", "nonresponsive",
				      "unreachable", "no status"};

/*\
 *  Printable strings for HNMS object classes.
\*/
const char	*obj_class_names[] = {"", "agent", "internet", "network",
					  "subnet", "ipaddr", "site",
					  "processor", "interface",
					  "equipment", "administrator",
					  "module"};

/*\
 *  Printable strings for HNMS module types.
\*/
const char	*module_type_strs[] = {"", "server", "ui", "io", "rbip"};
