#include "utils.h"

/* Copyright 1993 Jamie Honan
   May be freely used, sold, modified
*/

char * strcpy(char *dest, const char *src)
{
	char *sav;

	sav = dest;
	while ((*dest++ = *src++) != '\0')
	   ;
	return sav;
}

int strcmp(const char *a, const char *b)
{
	while(1)
	{
		if (*a != *b)
		{
			if (*(unsigned char *)a > *(unsigned char *)b)
				return 1;
			else
				return -1;
		}
		if (*a == '\0')
			break;
		a++;
		b++;
	}
	return 0;
}

int   strncmp(const char *a, const char *b, size_t len)
{

	while (len--)
	{
		if (*a != *b)
		{
			if (*(unsigned char *)a > *(unsigned char *)b)
				return 1;
			else
				return -1;
		}
		if (*a == '\0')
			break;
		a++;
		b++;
	}
	return 0;
}

void  *  memset(void  *buffer, int c, size_t len)
{
char *cbp;
	cbp = buffer;
	while(len--)
		*cbp++ = (char)c;
	return (buffer);
}

char  *   strncpy(char *dest, const char *src, size_t maxlen)
{
	char  *sav;

	for(sav = dest; maxlen && *src; maxlen--, dest++,src++)
		*dest = *src;
	if (maxlen)
		*dest = '\0';
	return sav;
}

void  *   memcpy(void  *dest, const void  *src, size_t cnt)
{
char  *cdest;
const char  *csrc;

	cdest = dest;
	csrc = src;

	while(cnt--)
		*cdest++ = *csrc++;
	return (dest);
}

void far * fmemcpy(void far *dst, const void far * src, size_t cnt)
{
char  far *cdest;
const char  far *csrc;

	cdest = cannon(dst);
	csrc = cannon(src);

	/* small attempt at overlap */
	if (cdest > csrc && cdest < csrc +  cnt)
	{
		csrc += cnt;
		cdest += cnt;
		while(cnt--)
			*--cdest = *--csrc;
	}
	else
	{
		while(cnt--)
			*cdest++ = *csrc++;
	}
	return (dst);
}

void lmemcpy(unsigned long dest, void *data, size_t len)
{
char far *ptr;

	ptr = long2far(dest);
	while(len--)
		*ptr++ = *((char *)(data))++;
}


int   memcmp(const void *a, const void *b, size_t len)
{
	const unsigned char *ua, *ub;

	ua = a;
	ub = b;

	while (len--)
	{
		if (*ua != *ub)
		{
			if (*ua > *ub)
				return 1;
			else
				return -1;
		}
		ua++;
		ub++;
	}
	return 0;
}


char  *   strchr(const char *str, int c)
{
	do
	   if (*str == c)
	      return (str);
	while (*str++);

	return ((char  *) 0);
}

size_t strlen(const char *str)
{
	register unsigned int len = 0;

	while (*str++)
	   ++len;

	return len;
}


