; 
;
; ideas - snippets of this were lifted from bootsect.s by Linus
; these consist of - patching the drive parameter table
;                  - trying to read sectors 18, 15 and 9 to determine
;                    the number of sectors per track
; The rest is pretty well mine.
;
; Don't be tempted to replace all those ugly [BASE+...] operands.
; you'll find exe2bin won't like it
;
;
BOOT_TEXT     SEGMENT BYTE PUBLIC 'BOOTT'
BOOT_TEXT              ENDS

Loaded          segment at 9800h

                assume cs:Loaded
                assume ds:Loaded

                org 0
JMP_HERE	label far
Loaded          ends

BOOT_TEXT     SEGMENT BYTE PUBLIC 'BOOTT'
	ASSUME  CS:BOOT_TEXT
	ASSUME	DS:BOOT_TEXT

	org 0h

BASE EQU	7c00h

go:
;	mov	dx, BASE + offset BOOT_TEXT:go
;	sub	dx,200h
;	mov	cl,4
;	shr	dx,cl
	mov	dx,cs

	mov	ax, 100h
	mov	dx, 6200h
	mov	ss,ax		; put stack at 100:6200 -> 7200
	mov	sp,dx

	xor	ax,ax
	mov	es,ax

	lds	si,es:[078h]		; ds:si is source

	mov	es,dx			; our data segment

	mov	di,BASE + offset dt_table		; es:di is destination
	mov	cx,6			; copy 12 bytes
	cld
	rep	movsw

	mov	ds,dx

	mov	[BASE+dt_sec_trak], 18		; patch sector count

	xor	ax,ax
	mov	es,ax
	mov	bx, BASE + offset dt_table		; es:di is destination
	mov	es:[078h],bx
	mov	ax,ds
	mov	es:[07ah],ax

	xor	ah,ah			; reset FDC 
	xor	dl,dl
	int 	13h	

	mov	si, BASE + offset BOOT_TEXT:booting
	call	outs_cs_si

	mov	ax,seg Loaded		; convenient place
	mov	es,ax
	xor	bx,bx

; pinched this bit from linux - simply determine which
; is the last sector	

	xor	dx, dx			; drive 0, head 0
	mov	cx,18			; sector 18, track 0
	mov	ax,201h			; read one sector
	int	13h
	jnc	sectors_known
	mov	cx,15			; sector 15
	mov	ax,201h			; read one sector
	int	13h
	jnc	sectors_known
	mov	cx,9

sectors_known:
	mov	[BASE+sectors], cx		; 
	
	; for (ax = 2, cx = numsects; cx > 0 ; cx--, ax++)
	;	read sector ax
	;	es:bx += sector size

					; going to read 32k
	mov	cx, 32 * 2		; number of sectors

	mov	ax,seg Loaded		; convenient place
	mov	es,ax
	xor	bx,bx

	mov	ax,1			;  starting sector
					; our numbers start at 0, theirs at 1
rd_loop:
	cmp	cx,0
	jle	finito
	push	cx
	push	ax
	
	call	convertsect
					; es:bx points to buffer
	mov	ax,0201h
	int	13h

	pop	ax
	pop	cx
	jc	bad_read
	
	dec	cx
	inc	ax
	add	bx,512
	jmp	rd_loop

finito:
ifdef TESTING
	mov	si, BASE + offset BOOT_TEXT:bootok
	call	outs_cs_si
endif
	call far ptr JMP_HERE
	mov	si, BASE + offset BOOT_TEXT:pank
	call	outs_cs_si
	jmp	bad_exit

bad_read:
	mov	si, BASE + offset BOOT_TEXT:diskerror
	call	outs_cs_si
bad_exit:
	xor	ah,ah		; wait for user press key
	int	16h
				; try to boot the system again
	int	19h


convertsect:
			; convert absolute sector to track head sector
			; sector in ax (assume small)
			
	xor	dx,dx		; assume high word zero
	div 	[BASE+sectors]		; sectors per track
	inc 	dl			; my 486 book says the remainder is in ax!
					; remainder is really in dx
	xor	dh,dh
	push	dx		; keep secno handy
	mov	dx,ax		; copy remainder
	shr	ax,1		; divide by number of heads -> track no
	and	dx,1		; mask all but head number
	xchg	dh,dl		; HEAD DH
				; ax is the track number
				; top two bits of track should be
				; placed in the sector number -  we ignore
	
	mov	ch, al		; track no
	pop	ax		; sector number
	mov	cl,al		; sector

	ret

outch:
	mov 	ah,0eh
	mov 	bx,0007h
	int 	10h

outs_cs_si:
	mov	al,cs:[si]
	inc	si
	or 	al,al	; end of string
	jnz 	outch
	ret

diskerror:
	db 0Dh, 0Ah, 'Disk controller error ...', 0

booting:
	db 0Dh, 0Ah, 'Loading net boot ...', 0
pank:
	db 0Dh, 0Ah, 'Press any key...', 0
ifdef TESTING
bootok:
	db 0Dh, 0Ah, 'read all, now jumping..', 0
endif

dt_table		label	byte
dt_spec1	db	0
dt_spec2	db	0
dt_moffc	db	0
dt_byt_sec	db	0	; bytes per sector
dt_sec_trak	db	0	; sectors per track
dt_gap		db	0	;
dt_dtl		db	0
dt_gap3		db	0
dt_fil_byt	db	0
dt_hd_tim	db	0
dt_most		db	0
dt_maxtrak	db	0
dt_other	db	0

sectors		dw	0


fill:	db (512-(offset BOOT_TEXT:fill-offset BOOT_TEXT:go)-2) dup (0)

signature	dw 0AA55h


BOOT_TEXT              ENDS

ifdef TESTING

FUNNY_TEXT     SEGMENT BYTE PUBLIC 'BOOTF'
	ASSUME  CS:FUNNY_TEXT
	ASSUME	DS:FUNNY_TEXT

	org 0

	mov	si, offset xbooted
	call	xouts_cs_si

	xor 	ah,ah		; wait for user press key
	int 	16h
				; try to boot the system again
	int 	19h

	
xoutch:
	mov 	ah,0eh
	mov 	bx,0007h
	int 	10h

xouts_cs_si:
	mov	al,cs:[si]
	inc	si
	or 	al,al	; end of string
	jnz 	xoutch
	ret

xbooted:
	db 0Dh, 0Ah, 'I booted... press key', 0

;	db 32768 dup (?)

FUNNY_TEXT              ENDS
endif

	END	go
