/* $Id: config.h,v 4.1 1993/03/23 16:17:06 mike Exp $ */


/* Define DEBUG if you want init to send masses of DEBUG information
 * out via syslog. Unless who have a problem you probably don't want
 * this noise!
 */
#undef DEBUG

/* The location of inittab is *usually* here. */
#define INITTAB	"/etc/inittab"

/* It's probably a bad idea to change the name of the console device
 * here.
 */
#define CONSOLE	"/dev/console"

#define SHELL		"/bin/sh"

/* This is the command to be invoked in single user mode. sulogin comes
 * with the shadow password suite. If you don't have it you might like
 * to try '/bin/su < /dev/tty1 > /dev/tty1 2>&1' or something similar.
 * Alternatively you could just make sulogin a copy of su.
 * Note that we can't use /dev/console here because /dev/console can
 * never become a controlling terminal.
 */
#define SUPROGRAM	"/etc/sulogin < /dev/tty1 > /dev/tty1 2>&1"

/* The pid of the master init process is always 1 under Linux. Don't even
 * *think* of changing this!
 */
#define INITPID		1

/* This is the file used by telinit when signalling init to change run
 * level. /etc/initrunlvl is the traditional setting. Some may prefer to
 * have it in /tmp or some such. Whether you change it here and recompile
 * or simply make a link is up to you.
 */
#define INITRUNLVL	"/etc/initrunlvl"

/* Compile with support for syslog. This doesn't require syslogd
 * to be running. If we can't connect to syslogd we should just
 * write the message to the console.
 * (The no-syslog support is mostly for debugging)
 */
#define SYSLOG


/* The following define the sequence of events when init needs to
 * kill one or more processes (i.e. changing run level etc.). First
 * each process to be killed is sent a SIGHUP. After NOTIFY_TIME
 * seconds each process is sent a SIGINT. After a further WARN_TIME
 * seconds each remaining process is forcibly terminated by a SIGKILL.
 *
 * Officially SYSV init only sends SIGHUP then SIGKILL but the xdm I
 * have for Linux seems to shut down on SIGINT rather than SIGHUP?
 * (But not any more probably. This was *years* ago now)
 *
 * The wait time between the SIGHUP and SIGKILL are also in question.
 * The SCO manual page for init says 5 seconds. The SCO manual page
 * for inittab says 20 seconds. The init page claims conformance
 * with SVID Issue 2. The inittab page makes no claims :-)
 */
#define NOTIFY_TIME	5
#define WARN_TIME	2


/* If an inittab command is respawned more than RESPAWN_COUNT times
 * in RESPAWN_TIME seconds it is disabled for STUN_TIME seconds.
 * These numbers are all given by SYSV manual pages too...
 */
#define RESPAWN_COUNT	10
#define RESPAWN_TIME	120
#define STUN_TIME	300
