// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

// Function prototypes
void AbortProg(char *func);
void Changemode(EModes newmode);
int  Getcopyinfo(void);
int  GotoObject(int firstdigit);
void Highlight(unsigned char attribute);
int  Parsecommandline(int argc, char *argv[]);
int  RunExe(void);
int  Updateammo(void);
int  Updateframe(void);
int  Updatesound(void);
int  Updatesprite(void);
int  Updatetext(void);
int  Updatethingl(void);
int  Updatethings(void);

// Global pointers to thing, frame, sound and weapon data are declared.
// since Sprite info is simply a bunch of pointers to the Text data, 
// it's an array of longs.  Also, the max ammo info and per ammo info 
// are simple arrays of longs.  And, finally, the Text data is simply 
// a large array of strings, declared here as one large string.
unsigned long (*thingdata )[THING_FIELDS];
unsigned long (*framedata )[FRAME_FIELDS];
unsigned long (*sounddata )[SOUND_FIELDS];
unsigned long (*weapondata)[WEAPON_FIELDS];
unsigned long *spritedata;
unsigned long *maxammodata;
unsigned long *perammodata;
char *textdatap;

// Other global variables.
ERedraw redraw = ALL;			// Current redraw state
EModes  mode = THING_EDIT;		//	The mode we start in
EVersions version;            // The Doom version we're using
ETruever  truever;				// The "real" Doom version we're using
EBool Lnx_DOOM = NO;				// If we're hacking Linux DOOM
FILE *doomexefp = NULL;			// File pointer to doom.exe
FILE *doomwadfp = NULL;       // File pointer to doom.wad
FILE *doombakfp = NULL;			// File pointer to doomhack.exe
char curdir[MAXPATHLEN+1];		// Directory at start of program
EBool changes = NO;				// If changes have been made
EBool batch = YES;				// If we're running in batch mode

// For the dehacked.ini file
char doompath[MAXPATHLEN+1]= "";	// Directory to run doom from
char doomexe[MAXPATHLEN+1] = "";	// Doom.exe file name
char doombak[MAXPATHLEN+1] = "";	// Heretic.exe backup file
char doomwad[MAXPATHLEN+1] = "";	// Doom.wad file name
char doomargs[MAXPATHLEN+1]= "";	// Arguments when Doom is run
char patchdir[MAXPATHLEN+1]= "";	// Patch file directory
long doomsize = 0;			// Doom.exe size


// number of objects in the respective sections
int numobj[NUMDATA][NUMVERS] = {
	{104,  138,  138,  138,  138,  138,  138},	// Thing
	{ 62,  107,  107,  107,  107,  107,  107},	// Sound
	{512,  966,  966,  966,  966,  966,  966}, 	// Frame
	{105,  138,  138,  138,  138,  138,  138},	// Sprite
	{  4,    4,    4,    4,    4,    4,    4},	// Ammo
	{  8,    9,    9,    9,    9,    9,    9},	// Weapon
	{762, 1053, 1047, 1079,    0,    0, 1129} 	// Text
};

// Sizes of objects
int size[NUMDATA][NUMVERS] = {
	{88,    92,    92,    92,    92,    92,	92},	// Thing
	{36,    36,    36,    36,    36,    36,	36},	// Sound
	{28,    28,    28,    28,    28,    28,	28},	// Frame
	{ 4,     4,     4,     4,     4,     4,	4},	// Sprite
	{ 4,     4,     4,     4,     4,     4,	4},	// Ammo
	{24,    24,    24,    24,    24,    24,	24},	// Weapon
	{15664, 22540, 22460, 23188,  0,     0,	26023} 	// Text
};
// The absolute largest text data section...
#define TEXT_DATASIZE	50000

// Mode information array...
//			Current | Field | Redraw what | Min | Max
int global[NUMSCREENS][5] = {0, 1, 0, 1, 0,	// thing
									  0, 1, 0, 0, 0,  // frame
									  0, 1, 0, 1, 0,	// weapon
									  0, 1, 0, 1, 0,  // sound
									  0, 1, 0, 0, 0,  // sprite
									  0, 1, 0, 0, 0,  // text
									  0, 1, 0, 1, 0}; // thinglist

// Order (field-wise) of things
char thingorder[23] = {IDNUM, HP, SPEED, CWIDTH, CHEIGHT, MISSILEDAMAGE,
							  REACTIONTIME, PAINCHANCE, MASS, BITS, ALERTSOUND,
							  ATTACKSOUND, PAINSOUND, DEATHSOUND, ACTSOUND,
							  NORMALFRAME, MOVEFRAME, INJUREFRAME, CLOSEATTACKFRAME,
							  FARATTACKFRAME, DEATHFRAME, EXPLDEATHFRAME,
							  RESPAWNFRAME};

// Array of pointers to update functions
typedef int (*funcptr)();
funcptr Updatefunc[NUMSCREENS] = {Updatethings, Updateframe, Updateammo,
											 Updatesound, Updatesprite, Updatetext,
											 Updatethingl};

// From screen.h
extern char *screenbptr;

// From screen.cpp
extern void clearscreen(char attr, char fill);
extern void WipeScreen(void);

// From print.h
extern char *objnames[NUMSCREENS];
extern char *thingfields[24];
extern char *soundfields[7];
extern char *framefields[7];
extern char *weaponfields[7];
extern char *fullwepfields[9];
extern char posinfo[NUMSCREENS][3];
extern char Fielddata[][5];
extern long toff[NUMVERS];

// Array of pointers to print functions
typedef void (*vfuncptr)();
extern vfuncptr Printfunc[NUMSCREENS];

// From print.cpp
extern int   Gettextnum(int offset);
extern void  Printintro(void);
extern void  Printoptions(void);
extern void  Printtextintro(void);
extern EBool Printwindow(char *message, int type);

// From mouse.cpp
extern void InitMouse(void);
extern void CloseMouse(void);

// From files.cpp
extern int  GetDoomFiles(char *arg1);
extern void Loaddoom(FILE *exefp);
extern int  Loadpatch(char *filename);
extern void Parseconfigfile(void);
extern int  Savepatch(char *filename, EBool Overwrite);
extern void Writedoom(void);

// From input.cpp
extern int   Inputtext(EBool showonly);
extern int   Printinputwindow(char *buffer, char *prompt, EInptype type, int length, char firstchar = 0);
extern EBool ProcessKeypress(void);
extern EBool ProcessMouse(void);
extern EBool Waitforevent(EBool eatevent);
