#include <sys/types.h>
#include <stdio.h>

#include "glove.h"
#include "posture.h"
#include "gesture.h"


/* global variables */

int           client_id, key;
gestureData_t gesture;
postureData_t *pos;


int main(int argc, char *argv[])
{
  client_id = init_gestures();

  if (client_id < 0)
  {
    fprintf(stderr, "%s: could not initialise gestures\n", argv[0]);
    exit(1);
  }

  for (;;)
  {
    recognise_gesture(&gesture);

    switch (gesture.id)
    {
      case 0: fprintf(stderr, "\n*** Gesture = 'RECTANGLE' ***\n\n");
              break;
    }

    pos = gesture.posture;
    key = getKey(gesture.glove);

    if (pos->id == 9 || key == 0x80)
      break;
  }

  quit_gestures();

  fprintf(stderr, "%s: exit\n", argv[0]);

  exit(0);
}
