
/*  A Bison parser, made from parse.y  */

#define YYBISON 1  /* Identify Bison output.  */

#define	ALLAFFIXES	258
#define	ALTSTRINGCHAR	259
#define	ALTSTRINGTYPE	260
#define	BOUNDARYCHARS	261
#define	COMPOUNDWORDS	262
#define	DEFSTRINGTYPE	263
#define	FLAG	264
#define	FLAGMARKER	265
#define	NROFFCHARS	266
#define	OFF	267
#define	ON	268
#define	PREFIXES	269
#define	RANGE	270
#define	SUFFIXES	271
#define	STRING	272
#define	STRINGCHAR	273
#define	TEXCHARS	274
#define	WORDCHARS	275

#line 1 "parse.y"

/* -*- Mode:Text -*- */
#ifndef lint
static char Rcs_Id[] =
    "$Id: parse.y,v 1.25 91/09/11 23:22:56 geoff Exp $";
#endif

/*
 * Copyright 1987, by Geoff Kuenning, Manhattan Beach, CA
 * Permission for non-profit use is hereby granted.
 * All other rights reserved.
 */

/*
 * $Log:	parse.y,v $
 * Revision 1.25  91/09/11  23:22:56  geoff
 * Add the "stringcharcmp" routine for getting around stupidity on Sun 4's.
 * Fix a number of places where the check for too many string characters
 * was off by 1.
 * 
 * Revision 1.24  91/08/10  14:09:46  geoff
 * Fix all of the stringchar length tests to allow single-character
 * stringchars.
 * 
 * Revision 1.23  91/07/15  19:27:11  geoff
 * Provide the "canonical" parameter to all *isstringch, strtoichar, and
 * strtosichar calls.
 * 
 * Revision 1.22  91/07/11  19:52:21  geoff
 * Remove the include of stdio.h, since ispell.h now does this.
 * 
 * Revision 1.21  91/07/05  19:51:51  geoff
 * Fix some lint complaints.
 * 
 * Revision 1.20  91/07/04  00:04:24  geoff
 * Put new string characters at the end of the list, so stringcharlen's
 * binary search will work right.
 * 
 * Revision 1.19  91/06/23  22:14:38  geoff
 * Fix a typo that could cause core dumps
 * 
 * Revision 1.18  91/06/23  20:53:46  geoff
 * Change the name of infile to prevent name conflicts with ispell.h
 * 
 * Revision 1.17  91/05/27  21:48:09  geoff
 * Add support for the altstringtype and defstringtype statements, and
 * introduce some statement ordering restrictions (mainly to make the
 * grammar simpler.)
 * 
 * Revision 1.16  90/12/31  01:04:08  geoff
 * Add a text-mode line so emacs will edit consistently.
 * 
 * Revision 1.15  90/04/26  22:44:20  geoff
 * Add the altstringchar statement and other support for alternate string
 * characters.
 * 
 * Revision 1.14  90/04/17  15:34:39  geoff
 * Fix some incorrect declarations caught by gcc
 * 
 * Revision 1.13  89/12/27  03:20:15  geoff
 * Move all messages to msgs.h so they can be reconfigured
 * 
 * Revision 1.12  89/06/09  15:55:57  geoff
 * Add support for the internal "character" type, ichar_t.
 * 
 * Revision 1.11  89/04/27  23:33:41  geoff
 * Fix some bugs introduced in the last revision, when we switched to a
 * malloc'ed yylval and added string characters.
 * 
 * Revision 1.10  89/04/03  01:57:50  geoff
 * Remove the distinction between "casechars" and "otherchars", figuring
 * out which is which from the syntax.  Add support for "boundarychars,"
 * string characters, and the selectable flag marker.  Fix all the code
 * that returns strings and character sets to return a malloc'ed yylval, for
 * reliability and robustness.  Make "option_stmt" a separate entity from
 * 'charset_stmt," just for readability.  Fix a bunch of lint complaints.  Add
 * support for strings in double quotes.
 * 
 * Revision 1.9  88/11/25  19:53:42  geoff
 * Get rid of some unneeded declarations, and add a few strategic blank
 * lines to make the formatting look a bit nicer.
 * 
 * Revision 1.8  88/06/25  17:50:24  geoff
 * Add statements to control various options:  nroff/TeX control characters,
 * compound words, and "all affix" generation.
 * 
 * Revision 1.7  88/04/30  22:15:13  geoff
 * Fix some lint complaints.
 * 
 * Revision 1.6  88/02/20  23:14:04  geoff
 * Use upcase instead of forceupper.  Allow affixes that delete something
 * without adding anything in its place.
 * 
 * Revision 1.5  87/09/30  23:31:17  geoff
 * Make the default sort order be ASCII but after all word characters.
 * Also rename a variable more mnemonically.
 * 
 * Revision 1.4  87/09/14  22:39:02  geoff
 * Add copyright comments
 * 
 * Revision 1.3  87/09/09  00:19:03  geoff
 * Add code to record the collating order in hashheader.sortorder.
 * 
 * Revision 1.2  87/08/02  17:17:54  geoff
 * Add (untested) support for the \x construct in the lexical analyzer.
 * 
 * Revision 1.1  87/07/20  22:57:45  geoff
 * Initial revision
 * 
 */

#include <ctype.h>
#include "config.h"
#include "ispell.h"
#include "msgs.h"


#line 119 "parse.y"
typedef union
    {
    int			simple;		/* Simple char or lval from yylex */
    struct
	{
	char *		set;		/* Character set */
	int		complement;	/* NZ if it is a complement set */
	}
			charset;
    unsigned char *	string;		/* String */
    ichar_t *		istr;		/* Internal string */
    struct flagent *	entry;		/* Flag entry */
    } YYSTYPE;
#line 133 "parse.y"


static int	yylex ();	/* Lexical analyzer */
static int	kwanalyze ();	/* Analyze a possible keyword */
static void	getqstring ();	/* Get (double-)quoted string */
static void	getrange ();	/* Get a lexical character range */
static int	backch ();	/* Process a backslashed character */
static void	yyerror ();	/* Print out an error message */
int		yyopen ();	/* Open a table file */
void		yyinit ();	/* Initialize for parsing */
static int	grabchar ();	/* Get a character and track line number */
static void	ungrabchar ();	/* Unget a character, tracking line numbers */
static int	sufcmp ();	/* Compare suffix flags for qsort */
static int	precmp ();	/* Compare prefix flags for qsort */
static int	addstringchar (); /* Add a string character to the table */
#ifdef SUN4_IS_STUPID
static int	stringcharcmp (); /* Strcmp() done right, for Sun 4's */
#else /* SUN4_IS_STUPID */
#define stringcharcmp	strcmp	/* Everybody else knows how to do strcmp() */
#endif /* SUN4_IS_STUPID */
#ifdef TBLDEBUG
static void	tbldump ();	/* Dump a flag table */
static void	entdump ();	/* Dump one flag entry */
static void	setdump ();	/* Dump a set specification */
static void	subsetdump ();	/* Dump part of a set spec */
#endif

struct kwtab
    {
    char *	kw;		/* Syntactic keyword */
    int		val;		/* Lexical value */
    };

#define TBLINC		10		/* Size to allocate table by */

static FILE *		aff_file = stdin; /* Input file pointer */
static int		centnum;	/* Number of entries in curents */
static int		centsize = 0;	/* Size of alloc'ed space in curents */
static int		ctypechars;	/* Size of string in current strtype */
static int		ctypenum = 0;	/* Number of entries in chartypes */
static int		ctypesize = 0;	/* Size of alloc'ed spc in chartypes */
static struct flagent * curents;	/* Current flag entry collection */
static char *		fname = "(stdin)"; /* Current file name */
static char		lexungrab[MAXSTRINGCHARLEN * 2]; /* Spc for ungrabch */
static int		lineno = 1;	/* Current line number in file */
static struct flagent * table;		/* Current table being built */
static int		tblnum;		/* Numer of entries in table */
static int		tblsize = 0;	/* Size of the flag table */
static int		ungrablen;	/* Size of ungrab area */

extern void		upcase ();	/* Make a string uppercase */

#ifndef linux
extern void		exit ();	/* Terminate program */
extern void		free ();	/* Free memory */
extern char *		malloc ();	/* Memory allocator */
extern void		perror ();	/* Print a system error message */
extern void		qsort ();	/* Quicksort routine */
extern char *		realloc ();	/* Memory reallocator */
extern char *		strcpy ();	/* String copier */
#endif
#line 248 "parse.y"

static struct kwtab			/* Table of built-in keywords */
		keywords[] =
    {
    {"allaffixes", ALLAFFIXES},
    {"altstringchar", ALTSTRINGCHAR},
    {"altstringtype", ALTSTRINGTYPE},
    {"boundarychars", BOUNDARYCHARS},
    {"compoundwords", COMPOUNDWORDS},
    {"defstringtype", DEFSTRINGTYPE},
    {"flag", FLAG},
    {"flagmarker", FLAGMARKER},
    {"nroffchars", NROFFCHARS},
    {"troffchars", NROFFCHARS},
    {"on", ON},
    {"off", OFF},
    {"prefixes", PREFIXES},
    {"stringchar", STRINGCHAR},
    {"suffixes", SUFFIXES},
    {"TeXchars", TEXCHARS},
    {"texchars", TEXCHARS},
    {"wordchars", WORDCHARS},
    {NULL, 0}
    };

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		91
#define	YYFLAG		-32768
#define	YYNTBASE	27

#define YYTRANSLATE(x) ((unsigned)(x) <= 275 ? yytranslate[x] : 53)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     8,     2,     5,     3,     7,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     6,     2,     2,
     2,     4,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     9,    10,    11,
    12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
    22,    23,    24,    25,    26
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     3,     5,     8,    12,    14,    17,    19,    22,    25,
    27,    30,    33,    35,    38,    42,    45,    49,    52,    55,
    59,    63,    66,    68,    71,    73,    75,    78,    82,    85,
    88,    91,    94,    97,    99,   101,   103,   105,   107,   110,
   113,   115,   117,   120,   123,   125,   128,   133,   139,   141,
   143,   146,   150,   157,   164,   165,   167,   169,   172
};

#endif

static const short yyrhs[] = {    28,
    43,     0,    43,     0,    29,    30,     0,    29,    30,    32,
     0,    30,     0,    30,    32,     0,    40,     0,    29,    40,
     0,    31,    33,     0,    33,     0,    30,    33,     0,    14,
    35,     0,    34,     0,    32,    34,     0,    26,    41,    41,
     0,    26,    41,     0,    12,    41,    41,     0,    12,    41,
     0,    24,    23,     0,    24,    23,    23,     0,    11,    35,
    38,     0,    23,    36,     0,    37,     0,    36,    37,     0,
    23,     0,    39,     0,    38,    39,     0,    10,    23,    23,
     0,    17,    23,     0,    25,    23,     0,    13,    42,     0,
     9,    42,     0,    16,    23,     0,     7,     0,    23,     0,
    21,     0,    19,     0,    18,     0,    44,    45,     0,    45,
    44,     0,    44,     0,    45,     0,    20,    46,     0,    22,
    46,     0,    47,     0,    46,    47,     0,    15,    23,     6,
    48,     0,    15,     8,    23,     6,    48,     0,     1,     0,
    49,     0,    48,    49,     0,    50,     4,    52,     0,    50,
     4,     3,    52,     5,    52,     0,    50,     4,     3,    52,
     5,     3,     0,     0,    51,     0,    41,     0,    51,    41,
     0,    23,     0
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   274,   275,   278,   279,   280,   281,   284,   285,   288,   289,
   290,   293,   296,   297,   300,   362,   387,   449,   474,   489,
   526,   529,   537,   572,   604,   608,   609,   612,   653,   664,
   674,   678,   682,   692,   708,   734,   737,   741,   747,   748,
   749,   750,   753,   773,   790,   820,   843,   856,   869,   873,
   891,   911,   941,   969,   998,  1014,  1017,  1059,  1099
};

static const char * const yytname[] = {   "$","error","$illegal.","'-'","'>'",
"','","':'","'.'","'*'","ALLAFFIXES","ALTSTRINGCHAR","ALTSTRINGTYPE","BOUNDARYCHARS",
"COMPOUNDWORDS","DEFSTRINGTYPE","FLAG","FLAGMARKER","NROFFCHARS","OFF","ON",
"PREFIXES","RANGE","SUFFIXES","STRING","STRINGCHAR","TEXCHARS","WORDCHARS","file",
"headers","option_group","charset_group","deftype_stmt","altchar_group","charset_stmt",
"altchar_stmt","stringtype_info","filesuf_list","filesuf","altchar_spec_group",
"altchar_spec","option_stmt","char_set","on_or_off","tables","prefix_table",
"suffix_table","table","flagdef","rules","affix_rule","cond_or_null","conditions",
"ichar_string",""
};
#endif

static const short yyr1[] = {     0,
    27,    27,    28,    28,    28,    28,    29,    29,    30,    30,
    30,    31,    32,    32,    33,    33,    33,    33,    33,    33,
    34,    35,    36,    36,    37,    38,    38,    39,    40,    40,
    40,    40,    40,    41,    41,    41,    42,    42,    43,    43,
    43,    43,    44,    45,    46,    46,    47,    47,    47,    48,
    48,    49,    49,    49,    50,    50,    51,    51,    52
};

static const short yyr2[] = {     0,
     2,     1,     2,     3,     1,     2,     1,     2,     2,     1,
     2,     2,     1,     2,     3,     2,     3,     2,     2,     3,
     3,     2,     1,     2,     1,     1,     2,     3,     2,     2,
     2,     2,     2,     1,     1,     1,     1,     1,     2,     2,
     1,     1,     2,     2,     1,     2,     4,     5,     1,     1,
     2,     3,     6,     6,     0,     1,     1,     2,     1
};

static const short yydefact[] = {     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     5,     0,    10,     7,     2,    41,    42,
    38,    37,    32,    34,    36,    35,    18,    31,     0,    12,
    33,    29,    49,     0,     0,    45,     0,    19,    30,    16,
     1,     3,     8,     0,     6,    11,    13,     9,    39,    40,
    17,    25,    22,    23,     0,     0,    46,    20,    15,     4,
     0,    14,    24,     0,    55,     0,    21,    26,    55,    57,
    47,    50,     0,    56,     0,    27,    48,    51,     0,    58,
    28,     0,    59,    52,     0,     0,    54,    53,     0,     0,
     0
};

static const short yydefgoto[] = {    89,
    12,    13,    14,    15,    45,    16,    47,    30,    53,    54,
    67,    68,    17,    70,    23,    18,    19,    20,    35,    36,
    71,    72,    73,    74,    84
};

static const short yypact[] = {    27,
    56,    14,    56,     1,    19,    32,    13,    13,    33,    40,
    14,   -10,    45,    22,    -6,-32768,-32768,-32768,    44,    57,
-32768,-32768,-32768,-32768,-32768,-32768,    14,-32768,    53,-32768,
-32768,-32768,-32768,    37,     4,-32768,     7,    55,-32768,    14,
-32768,    22,-32768,     1,    68,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,    53,-32768,    58,    74,-32768,-32768,-32768,    68,
    72,-32768,-32768,    77,    14,    61,    72,-32768,    14,-32768,
     9,-32768,    81,    14,    63,-32768,     9,-32768,     0,-32768,
-32768,    64,-32768,-32768,    83,     8,-32768,-32768,    89,    90,
-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,    78,-32768,    50,   -13,     5,    49,-32768,    41,
-32768,    28,    84,    -2,    93,    86,    79,    82,    92,   -20,
    34,    -4,-32768,-32768,   -18
};


#define	YYLAST		103


static const short yytable[] = {    27,
    46,    48,    82,   -43,    33,     2,   -44,    33,    40,     7,
    87,     8,   -55,    33,    57,    24,    57,     9,    34,    11,
    24,    34,    83,    29,    51,   -43,   -44,    34,    46,    25,
    83,    26,    44,     2,    25,     1,    26,    59,     2,     3,
     4,    31,     5,     6,    55,     9,     7,    11,     8,    62,
     9,    10,    11,     1,    32,    38,     2,     3,     4,    56,
     5,     6,    39,    85,    62,     8,    78,    88,     9,    10,
    11,    80,    78,    21,    22,    52,     7,    58,    44,    65,
    64,    66,    69,    75,    79,    81,    83,    86,    90,    91,
    42,    60,    61,    63,    76,    28,    43,    41,    50,    37,
    49,     0,    77
};

static const short yycheck[] = {     2,
    14,    15,     3,     0,     1,    12,     0,     1,    11,    20,
     3,    22,     4,     1,    35,     7,    37,    24,    15,    26,
     7,    15,    23,    23,    27,    22,    20,    15,    42,    21,
    23,    23,    11,    12,    21,     9,    23,    40,    12,    13,
    14,    23,    16,    17,     8,    24,    20,    26,    22,    45,
    24,    25,    26,     9,    23,    23,    12,    13,    14,    23,
    16,    17,    23,    82,    60,    22,    71,    86,    24,    25,
    26,    74,    77,    18,    19,    23,    20,    23,    11,     6,
    23,    10,     6,    23,     4,    23,    23,     5,     0,     0,
    13,    42,    44,    53,    67,     3,    13,    12,    20,     8,
    19,    -1,    69
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 169 "/usr/local/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symboles being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 15:
#line 301 "parse.y"
{
			    int nextlower;
			    int nextupper;

			    for (nextlower = SET_SIZE + hashheader.nstrchars;
			      --nextlower > SET_SIZE;
			      )
				{
				if (yyvsp[-1].charset.set[nextlower] != 0
				  ||  yyvsp[0].charset.set[nextlower] != 0)
				    {
				    yyerror (PARSE_Y_NO_WORD_STRINGS);
				    break;
				    }
				}
			    for (nextlower = 0;
			      nextlower < SET_SIZE;
			      nextlower++)
				{
				hashheader.wordchars[nextlower]
				  |= yyvsp[-1].charset.set[nextlower] | yyvsp[0].charset.set[nextlower];
				hashheader.lowerchars[nextlower]
				  |= yyvsp[-1].charset.set[nextlower];
				hashheader.upperchars[nextlower]
				  |= yyvsp[0].charset.set[nextlower];
				}
			    for (nextlower = nextupper = 0;
			      nextlower < SET_SIZE;
			      nextlower++)
				{
				if (yyvsp[-1].charset.set[nextlower])
				    {
				    for (  ;
				      nextupper < SET_SIZE
					&&  !yyvsp[0].charset.set[nextupper];
				      nextupper++)
					;
				    if (nextupper == SET_SIZE)
					yyerror (PARSE_Y_UNMATCHED);
				    else
					{
					hashheader.lowerconv[nextupper]
					  = nextlower;
					hashheader.upperconv[nextlower]
					  = nextupper;
					hashheader.sortorder[nextupper]
					  = hashheader.sortval++;
					hashheader.sortorder[nextlower]
					  = hashheader.sortval++;
					nextupper++;
					}
				    }
				}
			    for (  ;  nextupper < SET_SIZE;  nextupper++)
				{
				if (yyvsp[0].charset.set[nextupper])
				    yyerror (PARSE_Y_UNMATCHED);
				}
			    free (yyvsp[-1].charset.set);
			    free (yyvsp[0].charset.set);
			    ;
    break;}
case 16:
#line 363 "parse.y"
{
			    int i;

			    for (i = SET_SIZE + hashheader.nstrchars;
			      --i > SET_SIZE;
			      )
				{
				if (yyvsp[0].charset.set[i] != 0)
				    {
				    yyerror (PARSE_Y_NO_WORD_STRINGS);
				    break;
				    }
				}
			    for (i = 0;  i < SET_SIZE;  i++)
				{
				if (yyvsp[0].charset.set[i])
				    {
				    hashheader.wordchars[i] = 1;
				    hashheader.sortorder[i]
				      = hashheader.sortval++;
				    }
				}
			    free (yyvsp[0].charset.set);
			    ;
    break;}
case 17:
#line 388 "parse.y"
{
			    int nextlower;
			    int nextupper;

			    for (nextlower = SET_SIZE + hashheader.nstrchars;
			      --nextlower > SET_SIZE;
			      )
				{
				if (yyvsp[-1].charset.set[nextlower] != 0
				  ||  yyvsp[0].charset.set[nextlower] != 0)
				    {
				    yyerror (PARSE_Y_NO_BOUNDARY_STRINGS);
				    break;
				    }
				}
			    for (nextlower = 0;
			      nextlower < SET_SIZE;
			      nextlower++)
				{
				hashheader.boundarychars[nextlower]
				  |= yyvsp[-1].charset.set[nextlower] | yyvsp[0].charset.set[nextlower];
				hashheader.lowerchars[nextlower]
				  |= yyvsp[-1].charset.set[nextlower];
				hashheader.upperchars[nextlower]
				  |= yyvsp[0].charset.set[nextlower];
				}
			    for (nextlower = nextupper = 0;
			      nextlower < SET_SIZE;
			      nextlower++)
				{
				if (yyvsp[-1].charset.set[nextlower])
				    {
				    for (  ;
				      nextupper < SET_SIZE
					&&  !yyvsp[0].charset.set[nextupper];
				      nextupper++)
					;
				    if (nextupper == SET_SIZE)
					yyerror (PARSE_Y_UNMATCHED);
				    else
					{
					hashheader.lowerconv[nextupper]
					  = nextlower;
					hashheader.upperconv[nextlower]
					  = nextupper;
					hashheader.sortorder[nextupper]
					  = hashheader.sortval++;
					hashheader.sortorder[nextlower]
					  = hashheader.sortval++;
					nextupper++;
					}
				    }
				}
			    for (  ;  nextupper < SET_SIZE;  nextupper++)
				{
				if (yyvsp[0].charset.set[nextupper])
				    yyerror (PARSE_Y_UNMATCHED);
				}
			    free (yyvsp[-1].charset.set);
			    free (yyvsp[0].charset.set);
			    ;
    break;}
case 18:
#line 450 "parse.y"
{
			    int i;

			    for (i = SET_SIZE + hashheader.nstrchars;
			      --i > SET_SIZE;
			      )
				{
				if (yyvsp[0].charset.set[i] != 0)
				    {
				    yyerror (PARSE_Y_NO_BOUNDARY_STRINGS);
				    break;
				    }
				}
			    for (i = 0;  i < SET_SIZE;  i++)
				{
				if (yyvsp[0].charset.set[i])
				    {
				    hashheader.boundarychars[i] = 1;
				    hashheader.sortorder[i]
				      = hashheader.sortval++;
				    }
				}
			    free (yyvsp[0].charset.set);
			    ;
    break;}
case 19:
#line 475 "parse.y"
{
			    int len;

			    len = strlen ((char *) yyvsp[0].string);
			    if (len > MAXSTRINGCHARLEN)
				yyerror (PARSE_Y_LONG_STRING);
			    else if (len == 0)
				yyerror (PARSE_Y_NULL_STRING);
			    else if (hashheader.nstrchars >= MAXSTRINGCHARS)
				yyerror (PARSE_Y_MANY_STRINGS);
			    else
				(void) addstringchar (yyvsp[0].string, 0, 0);
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
case 20:
#line 490 "parse.y"
{
			    int lcslot;
			    int len;
			    int ucslot;

			    len = strlen ((char *) yyvsp[-1].string);
			    if (strlen ((char *) yyvsp[0].string) != len)
				yyerror (PARSE_Y_LENGTH_MISMATCH);
			    else if (len > MAXSTRINGCHARLEN)
				yyerror (PARSE_Y_LONG_STRING);
			    else if (len == 0)
				yyerror (PARSE_Y_NULL_STRING);
			    else if (hashheader.nstrchars >= MAXSTRINGCHARS)
				yyerror (PARSE_Y_MANY_STRINGS);
			    else
				{
				/*
				 * Add the uppercase character first, so that
				 * it will sort first.
				 */
				ucslot = addstringchar (yyvsp[0].string, 0, 1);
				if (ucslot >= 0)
				    lcslot = addstringchar (yyvsp[-1].string, 1, 0);
				if (ucslot >= 0  &&  lcslot >= 0)
				    {
				    if (ucslot >= lcslot)
					ucslot++;
				    hashheader.lowerconv[ucslot] = lcslot;
				    hashheader.upperconv[lcslot] = ucslot;
				    }
				}
			    free ((char *) yyvsp[-1].string);
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
case 22:
#line 530 "parse.y"
{
			    chartypes[ctypenum].name = (char *) yyvsp[-1].string;
			    ctypenum++;
			    hashheader.nstrchartype = ctypenum;
			    ;
    break;}
case 23:
#line 538 "parse.y"
{
			    if (ctypenum >= ctypesize)
				{
				if (ctypesize == 0)
				    chartypes = (struct strchartype *)
				      malloc (TBLINC
					* sizeof (struct strchartype));
				else
				    chartypes = (struct strchartype *)
				      realloc ((char *) chartypes,
					(ctypesize + TBLINC)
					  * sizeof (struct strchartype));
				if (chartypes == NULL)
				    {
				    yyerror (PARSE_Y_NO_SPACE);
				    exit (1);
				    }
				ctypesize += TBLINC;
				}
			    ctypechars =
			      TBLINC * (strlen ((char *) yyvsp[0].string) + 1) + 1;
			    chartypes[ctypenum].suffixes = malloc (ctypechars);
			    if (chartypes[ctypenum].suffixes == NULL)
				{
				yyerror (PARSE_Y_NO_SPACE);
				exit (1);
				}
			    (void) strcpy (chartypes[ctypenum].suffixes,
			     (char *) yyvsp[0].string);
			    chartypes[ctypenum].suffixes
				[strlen ((char *) yyvsp[0].string) + 1]
			      = '\0';
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
case 24:
#line 573 "parse.y"
{
			    char *	nexttype;
			    int		offset;

			    for (nexttype = chartypes[ctypenum].suffixes;
			      *nexttype != '\0';
			      nexttype += strlen (nexttype) + 1)
				;
			    offset = nexttype - chartypes[ctypenum].suffixes;
			    if (offset + strlen ((char *) yyvsp[0].string) + 1
			       >= ctypechars)
				{
				ctypechars +=
				  TBLINC * (strlen ((char *) yyvsp[0].string) + 1);
				chartypes[ctypenum].suffixes =
				  realloc (chartypes[ctypenum].suffixes,
				    ctypechars);
				if (chartypes[ctypenum].suffixes == NULL)
				    {
				    yyerror (PARSE_Y_NO_SPACE);
				    exit (1);
				    }
				nexttype =
				  chartypes[ctypenum].suffixes + offset;
				}
			    (void) strcpy (nexttype, (char *) yyvsp[0].string);
			    nexttype[strlen ((char *) yyvsp[0].string) + 1] = '\0';
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
case 28:
#line 613 "parse.y"
{
			    int i;
			    int len;
			    int slot;

			    len = strlen ((char *) yyvsp[-1].string);
			    if (len > MAXSTRINGCHARLEN)
				yyerror (PARSE_Y_LONG_STRING);
			    else if (len == 0)
				yyerror (PARSE_Y_NULL_STRING);
			    else if (hashheader.nstrchars >= MAXSTRINGCHARS)
				yyerror (PARSE_Y_MANY_STRINGS);
			    else if (!isstringch ((char *) yyvsp[0].string, 1))
				yyerror (PARSE_Y_NO_SUCH_STRING);
			    else
				{
				slot = addstringchar (yyvsp[-1].string, 0, 0) - SET_SIZE;
				if (laststringch >= slot)
				    laststringch++;
				hashheader.stringdups[slot] = laststringch;
				for (i = hashheader.nstrchars;  --i >= 0;  )
				    {
				    if (hashheader.stringdups[i]
				      == laststringch)
					hashheader.dupnos[slot]++;
				    }
				/*
				 * The above code sets dupnos one too high,
				 * because it counts the character itself.
				 */
				if (hashheader.dupnos[slot]
				  != hashheader.nstrchartype)
				    yyerror (PARSE_Y_MULTIPLE_STRINGS);
				hashheader.dupnos[slot]--;
				}
			    free ((char *) yyvsp[-1].string);
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
case 29:
#line 654 "parse.y"
{
			    if (strlen ((char *) yyvsp[0].string)
			      == sizeof (hashheader.nrchars))
				(void) bcopy ((char *) yyvsp[0].string, hashheader.nrchars,
				  sizeof (hashheader.nrchars));
			    else
				yyerror (PARSE_Y_WRONG_NROFF);
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
case 30:
#line 665 "parse.y"
{
			    if (strlen ((char *) yyvsp[0].string)
			      == sizeof (hashheader.texchars))
				(void) bcopy ((char *) yyvsp[0].string, hashheader.texchars,
				  sizeof (hashheader.texchars));
			    else
				yyerror (PARSE_Y_WRONG_TEX);
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
case 31:
#line 675 "parse.y"
{
			    hashheader.defspaceflag = !yyvsp[0].simple;
			    ;
    break;}
case 32:
#line 679 "parse.y"
{
			    hashheader.defhardflag = yyvsp[0].simple;
			    ;
    break;}
case 33:
#line 683 "parse.y"
{
			    if (strlen ((char *) yyvsp[0].string) != 1)
				yyerror (PARSE_Y_LONG_FLAG);
			    else
				hashheader.flagmarker = yyvsp[0].string[0];
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
case 34:
#line 693 "parse.y"
{
			    int		i;
			    char *	set;

			    set = malloc (SET_SIZE + MAXSTRINGCHARS);
			    if (set == NULL)
				{
				yyerror (PARSE_Y_NO_SPACE);
				exit (1);
				}
			    yyval.charset.set = set;
			    for (i = SET_SIZE + MAXSTRINGCHARS;  --i >= 0;  )
				*set++ = 1;
			    yyval.charset.complement = 0;
			    ;
    break;}
case 35:
#line 709 "parse.y"
{
			    int		setlen;

			    yyval.charset.set = malloc (SET_SIZE + MAXSTRINGCHARS);
			    if (yyval.charset.set == NULL)
				{
				yyerror (PARSE_Y_NO_SPACE);
				exit (1);
				}
			    (void) bzero (yyval.charset.set, SET_SIZE + MAXSTRINGCHARS);
			    if (l1_isstringch ((char *) yyvsp[0].string, setlen, 1))
				{
				if (setlen != strlen ((char *) yyvsp[0].string))
				    yyerror (PARSE_Y_NEED_BLANK);
				yyval.charset.set[SET_SIZE + laststringch] = 1;
				}
			    else
				{
				if (strlen ((char *) yyvsp[0].string) != 1)
				    yyerror (PARSE_Y_NEED_BLANK);
				yyval.charset.set[*yyvsp[0].string] = 1;
				}
			    free ((char *) yyvsp[0].string);
			    yyval.charset.complement = 0;
			    ;
    break;}
case 37:
#line 738 "parse.y"
{
			    yyval.simple = 1;
			    ;
    break;}
case 38:
#line 742 "parse.y"
{
			    yyval.simple = 0;
			    ;
    break;}
case 43:
#line 754 "parse.y"
{
			    pflaglist = table;
			    numpflags = tblnum;
			    /*
			     * Sort the flag table.  This is critical so
			     * that ispell can build a correct index
			     * table.  The idea is to put similar affixes
			     * together.
			     */
			    qsort ((char *) table, (unsigned) tblnum,
			      sizeof (*table), precmp);
#ifdef TBLDEBUG
			    (void) fprintf (stderr, "prefixes\n");
			    tbldump (table, tblnum);
#endif
			    tblsize = 0;
			    ;
    break;}
case 44:
#line 774 "parse.y"
{
			    sflaglist = table;
			    numsflags = tblnum;
			    /*
			     * See comments on the prefix sort.
			     */
			    qsort ((char *) table, (unsigned) tblnum,
			      sizeof (*table), sufcmp);
#ifdef TBLDEBUG
			    (void) fprintf (stderr, "suffixes\n");
			    tbldump (table, tblnum);
#endif
			    tblsize = 0;
			    ;
    break;}
case 45:
#line 791 "parse.y"
{
			    if (tblsize == 0)
				{
				tblsize = centnum + TBLINC;
				tblnum = 0;
				table = (struct flagent *)
				  malloc (tblsize * (sizeof (struct flagent)));
				if (table == NULL)
				    {
				    yyerror (PARSE_Y_NO_SPACE);
				    exit (1);
				    }
				}
			    else if (tblnum + centnum >= tblsize)
				{
				tblsize = tblnum + centnum + TBLINC;
				table = (struct flagent *)
				  realloc ((char *) table,
				    tblsize * (sizeof (struct flagent)));
				if (table == NULL)
				    {
				    yyerror (PARSE_Y_NO_SPACE);
				    exit (1);
				    }
				}
			    for (tblnum = 0;  tblnum < centnum;  tblnum++)
				table[tblnum] = curents[tblnum];
			    centnum = 0;
			    ;
    break;}
case 46:
#line 821 "parse.y"
{
			    int i;

			    if (tblnum + centnum >= tblsize)
				{
				tblsize = tblnum + centnum + TBLINC;
				table = (struct flagent *)
				  realloc ((char *) table,
				    tblsize * (sizeof (struct flagent)));
				if (table == NULL)
				    {
				    yyerror (PARSE_Y_NO_SPACE);
				    exit (1);
				    }
				}
			    for (i = 0;  i < centnum;  i++)
				table[tblnum + i] = curents[i];
			    tblnum += centnum;
			    centnum = 0;
			    ;
    break;}
case 47:
#line 844 "parse.y"
{
			    int i;

			    if (strlen ((char *) yyvsp[-2].string) != 1)
				yyerror (PARSE_Y_LONG_FLAG);
			    for (i = 0;  i < centnum;  i++)
				{
				curents[i].flagbit = CHARTOBIT (yyvsp[-2].string[0]);
				curents[i].flagflags = 0;
				}
			    free ((char *) yyvsp[-2].string);
			    ;
    break;}
case 48:
#line 857 "parse.y"
{
			    int i;

			    if (strlen ((char *) yyvsp[-2].string) != 1)
				yyerror (PARSE_Y_LONG_FLAG);
			    for (i = 0;  i < centnum;  i++)
				{
				curents[i].flagbit = CHARTOBIT (yyvsp[-2].string[0]);
				curents[i].flagflags = FF_CROSSPRODUCT;
				}
			    free ((char *) yyvsp[-2].string);
			    ;
    break;}
case 49:
#line 870 "parse.y"
{ yyval.simple = 0; ;
    break;}
case 50:
#line 874 "parse.y"
{
			    if (centsize == 0)
				{
				curents = (struct flagent *)
				  malloc (TBLINC * (sizeof (struct flagent)));
				if (curents == NULL)
				    {
				    yyerror (PARSE_Y_NO_SPACE);
				    exit (1);
				    }
				centsize = TBLINC;
				}
			    curents[0] = *yyvsp[0].entry;
			    centnum = 1;
			    free ((char *) yyvsp[0].entry);
			    yyval.simple = 0;
			    ;
    break;}
case 51:
#line 892 "parse.y"
{
			    if (centnum >= centsize)
				{
				centsize += TBLINC;
				curents = (struct flagent *)
				  realloc ((char *) curents,
				    centsize * (sizeof (struct flagent)));
				if (curents == NULL)
				    {
				    yyerror (PARSE_Y_NO_SPACE);
				    exit (1);
				    }
				}
			    curents[centnum] = *yyvsp[0].entry;
			    centnum++;
			    free ((char *) yyvsp[0].entry);
			    ;
    break;}
case 52:
#line 912 "parse.y"
{
			    int		i;

			    yyvsp[-2].entry->stripl = 0;
			    yyvsp[-2].entry->strip = NULL;
			    yyvsp[-2].entry->affl = icharlen (yyvsp[0].istr);
			    yyvsp[-2].entry->affix = yyvsp[0].istr;
			    upcase (yyvsp[0].istr);
			    /*
			     * As a special optimization (and a
			     * concession to those who prefer the syntax
			     * that way), convert any single condition
			     * that accepts all characters into no
			     * condition at all.
			     */
			    if (yyvsp[-2].entry->numconds == 1)
				{
				for (i = SET_SIZE + hashheader.nstrchars;
				  --i >= 0;
				  )
				    {
				    if ((yyvsp[-2].entry->conds[i] & 1) == 0)
					break;
				    }
				if (i < 0)
				    yyvsp[-2].entry->numconds = 0;
				}
			    yyval.entry = yyvsp[-2].entry;
			    ;
    break;}
case 53:
#line 942 "parse.y"
{
			    int		    i;

			    yyvsp[-5].entry->stripl = icharlen (yyvsp[-2].istr);
			    yyvsp[-5].entry->strip = yyvsp[-2].istr;
			    upcase (yyvsp[-2].istr);
			    yyvsp[-5].entry->affl = icharlen (yyvsp[0].istr);
			    yyvsp[-5].entry->affix = yyvsp[0].istr;
			    upcase (yyvsp[0].istr);
			    /*
			     * Convert the syntax ". > -xxx,yyy" into
			     * " > -xxx,yyy", as in the code just above.
			     */
			    if (yyvsp[-5].entry->numconds == 1)
				{
				for (i = SET_SIZE + hashheader.nstrchars;
				  --i >= 0;
				  )
				    {
				    if ((yyvsp[-5].entry->conds[i] & 1) == 0)
					break;
				    }
				if (i < 0)
				    yyvsp[-5].entry->numconds = 0;
				}
			    yyval.entry = yyvsp[-5].entry;
			    ;
    break;}
case 54:
#line 970 "parse.y"
{
			    int		    i;

			    yyvsp[-5].entry->stripl = icharlen (yyvsp[-2].istr);
			    yyvsp[-5].entry->strip = yyvsp[-2].istr;
			    upcase (yyvsp[-2].istr);
			    yyvsp[-5].entry->affl = 0;
			    yyvsp[-5].entry->affix = NULL;
			    /*
			     * Convert the syntax ". > -xxx," into
			     * " > -xxx,", as in the code just above.
			     */
			    if (yyvsp[-5].entry->numconds == 1)
				{
				for (i = SET_SIZE + hashheader.nstrchars;
				  --i >= 0;
				  )
				    {
				    if ((yyvsp[-5].entry->conds[i] & 1) == 0)
					break;
				    }
				if (i < 0)
				    yyvsp[-5].entry->numconds = 0;
				}
			    yyval.entry = yyvsp[-5].entry;
			    ;
    break;}
case 55:
#line 999 "parse.y"
{
			    struct flagent *	ent;

			    ent = (struct flagent *)
			      malloc (sizeof (struct flagent));
			    if (ent == NULL)
				{
				yyerror (PARSE_Y_NO_SPACE);
				exit (1);
				}
			    ent->numconds = 0;
			    (void) bzero (ent->conds,
			       SET_SIZE + MAXSTRINGCHARS);
			    yyval.entry = ent;
			    ;
    break;}
case 57:
#line 1018 "parse.y"
{
			    struct flagent *	ent;
			    int			i;

			    ent = (struct flagent *)
			      malloc (sizeof (struct flagent));
			    if (ent == NULL)
				{
				yyerror (PARSE_Y_NO_SPACE);
				exit (1);
				}
			    ent->numconds = 1;
			    (void) bzero (ent->conds,
			       SET_SIZE + MAXSTRINGCHARS);
			    /*
			     * Copy conditions to the new entry, making
			     * sure that uppercase versions are generated
			     * for lowercase input.
			     */
			    for (i = SET_SIZE + MAXSTRINGCHARS;  --i >= 0;  )
				{
				if (yyvsp[0].charset.set[i])
				    {
				    ent->conds[i] = 1;
				    if (!yyvsp[0].charset.complement)
					ent->conds[mytoupper ((ichar_t) i)] = 1;
				    }
				}
			    if (yyvsp[0].charset.complement)
				{
				for (i = SET_SIZE + MAXSTRINGCHARS;
				--i >= 0;
				)
				    {
				    if (yyvsp[0].charset.set[i] == 0)
					ent->conds[mytoupper ((ichar_t) i)] = 0;
				    }
				}
			    free (yyvsp[0].charset.set);
			    yyval.entry = ent;
			    ;
    break;}
case 58:
#line 1060 "parse.y"
{
			    int			i;
			    int			mask;

			    if (yyvsp[-1].entry->numconds >= 8)
				{
				yyerror (PARSE_Y_MANY_CONDS);
				yyvsp[-1].entry->numconds = 7;
				}
			    mask = 1 << yyvsp[-1].entry->numconds;
			    yyvsp[-1].entry->numconds++;
			    for (i = SET_SIZE + MAXSTRINGCHARS;
			      --i >= 0;
			      )
				{
				if (yyvsp[0].charset.set[i])
				    {
				    yyvsp[-1].entry->conds[i] |= mask;
				    if (!yyvsp[0].charset.complement)
					yyvsp[-1].entry->conds[mytoupper ((ichar_t) i)]
					  |= mask;
				    }
				}
			    if (yyvsp[0].charset.complement)
				{
				mask = ~mask;
				for (i = SET_SIZE + MAXSTRINGCHARS;
				  --i >= 0;
				  )
				    {
				    if (yyvsp[0].charset.set[i] == 0)
					yyvsp[-1].entry->conds[mytoupper ((ichar_t) i)]
					  &= mask;
				    }
				}
			    free (yyvsp[0].charset.set);
			    ;
    break;}
case 59:
#line 1100 "parse.y"
{
			    ichar_t *tichar;

			    tichar = strtosichar ((char *) yyvsp[0].string, 1);
			    yyval.istr = (ichar_t *) malloc (sizeof (ichar_t)
			      * (icharlen (tichar) + 1));
			    if (yyval.istr == NULL)
				{
				yyerror (PARSE_Y_NO_SPACE);
				exit (1);
				}
			    icharcpy (yyval.istr, tichar);
			    free ((char *) yyvsp[0].string);
			    ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 440 "/usr/local/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 1115 "parse.y"

/*
 * Trivial lexical analyzer.
 */
static int yylex ()
    {
    int			backslashed; /* NZ if backslash appeared */
    register int	ch;	/* Next character seen */
    register unsigned char *
			lexp;	/* Pointer into lexstring */
    unsigned char	lexstring[256];	/* Space for collecting strings */

    while ((ch = grabchar ()) != EOF  &&  (isspace (ch)  ||  ch == '#'))
	{			/* Skip whitespace and comments */
	if (ch == '#')
	    {
	    while ((ch = grabchar ()) != EOF  &&  ch != '\n')
		;
	    }
	}
    switch (ch)
	{
	case EOF:
	    return EOF;
	case '"':
	    getqstring ();
	    return STRING;
	case '-':
	case '>':
	case ',':
	case ':':
	case '.':
	case '*':
	    yylval.simple = ch;
	    return ch;
	case '[':		/* Beginning of a range set */
	    getrange ();	/* Get the range */
	    return RANGE;
	}
    /*
     * We get here if the character is an ordinary one;  note that
     * this includes backslashes.
     */
    backslashed = 0;
    lexp = lexstring;
    while (1)
	{
	switch (ch)
	    {
	    case EOF:
		*lexp = '\0';
		return kwanalyze (backslashed, lexstring);
	    case '\\':
		backslashed = 1;
		ch = backch ();
		*lexp++ = ch;
		break;
	    case ' ':
	    case '\t':
	    case '\n':
	    case '\f':
	    case '\r':
		*lexp = '\0';
		return kwanalyze (backslashed, lexstring);
	    case '#':
	    case '>':
	    case ':':
	    case '-':
	    case ',':
	    case '[':
		ungrabchar (ch);
		*lexp = '\0';
		return kwanalyze (backslashed, lexstring);
	    default:
		*lexp++ = ch;
		break;
	    }
	ch = grabchar ();
	}
    }

static int kwanalyze (backslashed, str)
    int			backslashed;	/* NZ if string had a backslash */
    register unsigned char *
			str;		/* String to analyze */
    {
    register struct kwtab *
			kwptr;		/* Pointer into keyword table */

    yylval.simple = 0;
    if (!backslashed)			/* Backslash means not keyword */
	{
	for (kwptr = keywords;  kwptr->kw != NULL;  kwptr++)
	    {
	    if (strcmp (kwptr->kw, (char *) str) == 0)
		return (yylval.simple = kwptr->val);
	    }
	}
    yylval.string =
      (unsigned char *) malloc ((unsigned) strlen ((char *) str) + 1);
    if (yylval.string == NULL)
	{
	yyerror (PARSE_Y_NO_SPACE);
	exit (1);
	}
    (void) strcpy ((char *) yylval.string, (char *) str);
    return STRING;
    }

/*
 * Analyze a string in double quotes.  The leading quote has already
 * been processed.
 */
static void getqstring ()
    {
    register int	ch;		/* Next character read */
    char		lexstring[256];	/* Room to collect the string */
    register char *	lexp;		/* Pointer into lexstring */

    for (lexp = lexstring;
      (ch = grabchar ()) != EOF  &&  ch != '"'
	&&  lexp < &lexstring[sizeof lexstring - 1];
      )
	{
	if (ch == '\\')
	    ch = backch ();
	*lexp++ = ch;
	}
    *lexp++ = '\0';
    if (ch == EOF)
	yyerror (PARSE_Y_EOF);
    else if (ch != '"')
	{
	yyerror (PARSE_Y_LONG_QUOTE);
	while ((ch = grabchar ()) != EOF  &&  ch != '"')
	    {
	    if (ch == '\\')
		ch = backch ();
	    }
	}
    yylval.string = (unsigned char *) malloc ((unsigned) (lexp - lexstring));
    if (yylval.string == NULL)
	{
	yyerror (PARSE_Y_NO_SPACE);
	exit (1);
	}
    (void) strcpy ((char *) yylval.string, lexstring);
    }

/*
 * Analyze a range (e.g., [A-Za-z]).  The left square bracket
 * has already been processed.
 */
static void getrange ()			/* Parse a range set */
    {
    register int	ch;		/* Next character read */
    register int	lastch;		/* Previous char, for ranges */
    char		stringch[MAXSTRINGCHARLEN];
    int			stringchlen;

    yylval.charset.set = malloc (SET_SIZE + MAXSTRINGCHARS);
    if (yylval.charset.set == NULL)
	{
	yyerror (PARSE_Y_NO_SPACE);
	exit (1);
	}

    /* Start with a null set */
    (void) bzero (yylval.charset.set, SET_SIZE + MAXSTRINGCHARS);
    yylval.charset.complement = 0;

    lastch = -1;
    ch = grabchar ();
    if (ch == '^')
	{
	yylval.charset.complement = 1;
	ch = grabchar ();
	}
    if (ch == ']')
	{
	lastch = ']';
	yylval.charset.set[']'] = 1;
	}
    else
	ungrabchar (ch);
    while ((ch = grabchar ()) != EOF  &&  ch != ']')
	{
	if (isstringstart (ch))		/* Handle a possible string character */
	    {
	    stringch[0] = ch;
	    for (stringchlen = 1;
	      stringchlen < MAXSTRINGCHARLEN;
	      stringchlen++)
		{
		if (isstringch (stringch, 1))
		    {
		    yylval.charset.set[SET_SIZE + laststringch] = 1;
		    stringchlen = 0;
		    break;
		    }
		ch = grabchar ();
		if (ch == EOF)
		    break;
		else
		    stringch[stringchlen] = ch;
		}
	    if (stringchlen == 0)
		{
		lastch = -1;		/* String characters can't be ranges */
		continue;		/* We found a string character */
		}
	    /*
	     * Not a string character - put it back
	     */
	    while (--stringchlen > 0)
		ungrabchar (stringch[stringchlen] & 0xFF);
	    ch = stringch[0] & 0xFF;
	    }
	if (ch == '\\')
	    {
	    lastch = ch = backch ();
	    yylval.charset.set[ch] = 1;
	    continue;
	    }
	if (ch == '-')			/* Handle a range */
	    {
	    if (lastch == -1)
		{
		lastch = ch = '-';	/* Not really a range */
		yylval.charset.set['-'] = 1;
		}
	    else
		{
		ch = grabchar ();
		if (ch == EOF  ||  ch == ']')
		    {
		    lastch = ch = '-';	/* Not really range */
		    yylval.charset.set['-'] = 1;
		    if (ch != EOF)
			ungrabchar (ch);
		    }
		else
		    {
		    if (ch == '\\')
			ch = backch ();
		    while (lastch <= ch)
			yylval.charset.set[lastch++] = 1;
		    lastch = -1;
		    }
		}
	    }
	else
	    {
	    lastch = ch;
	    yylval.charset.set[ch] = 1;
	    }
	}
    if (yylval.charset.complement)
	{
	for (ch = 0;  ch < SET_SIZE + MAXSTRINGCHARS;  ch++)
	    yylval.charset.set[ch] = !yylval.charset.set[ch];
	}
    }

static int backch ()			/* Process post-backslash characters */
    {
    register int	ch;		/* Next character read */
    register int	octval;		/* Budding octal value */

    ch = grabchar ();
    if (ch == EOF)
	return '\\';
    else if (ch >= '0'  &&  ch <= '7')
	{
	octval = ch - '0';
	ch = grabchar ();
	if (ch >= '0'  &&  ch <= '7')
	    {
	    octval = octval << 3 + ch - '0';
	    ch = grabchar ();
	    if (ch >= '0'  &&  ch <= '7')
		octval = octval << 3 + ch - '0';
	    else
		ungrabchar (ch);
	    }
	else if (ch != EOF)
	    ungrabchar (ch);
	ch = octval;
	}
    else if (ch == 'x')
	{
	ch = grabchar ();
	octval = 0;
	if ((ch >= '0'  &&  ch <= '9')
	  ||  (ch >= 'a'  &&  ch <= 'f')
	  ||  (ch >= 'A'  &&  ch <= 'F'))
	    {
	    if (ch >= '0'  &&  ch <= '9')
		octval = ch - '0';
	    else if (ch >= 'a'  &&  ch <= 'f')
		octval = ch - 'a' + 0xA;
	    else if (ch >= 'A'  &&  ch <= 'F')
		octval = ch - 'A' + 0xA;
	    ch = grabchar ();
	    octval <<= 4;
	    if (ch >= '0'  &&  ch <= '9')
		octval |= ch -'0';
	    else if (ch >= 'a'  &&  ch <= 'f')
		octval |= ch - 'a' + 0xA;
	    else if (ch >= 'A'  &&  ch <= 'F')
		octval |= ch - 'A' + 0xA;
	    else if (ch != EOF)
		{
		octval >>= 4;
		ungrabchar (ch);
		}
	    }
	else if (ch != EOF)
	    ungrabchar (ch);
	ch = octval;
	}
    else
	{
	switch (ch)
	    {
	    case 'n':
		ch = '\n';
		break;
	    case 'f':
		ch = '\f';
		break;
	    case 'r':
		ch = '\r';
		break;
	    case 'b':
		ch = '\b';
		break;
	    case 't':
		ch = '\t';
		break;
	    case 'v':
		ch = '\v';
		break;
	    }
	}
    return ch;
    }

static void yyerror (str)
    char *		str;	/* Error string */
    {
    (void) fflush (stdout);
    (void) fprintf (stderr, PARSE_Y_ERROR_FORMAT(fname, lineno, str));
    (void) fflush (stderr);
    }

int yyopen (file)
    register char *	file;	/* File name to be opened */
    {
    fname = malloc ((unsigned) strlen (file) + 1);
    if (fname == NULL)
	{
	(void) fprintf (stderr, PARSE_Y_MALLOC_TROUBLE);
	exit (1);
	}
    (void) strcpy (fname, file);
    aff_file = fopen (file, "r");
    if (aff_file == NULL)
	{
	(void) fprintf (stderr, CANT_OPEN, file);
	perror ("");
	return 1;
	}
    lineno = 1;
    return 0;
    }

void yyinit ()
    {
    register int	i;	/* Loop counter */

    for (i = 0;  i < SET_SIZE + MAXSTRINGCHARS;  i++)
	{
	hashheader.lowerconv[i] = i;
	hashheader.upperconv[i] = i;
	hashheader.wordchars[i] = 0;
	hashheader.lowerchars[i] = 0;
	hashheader.upperchars[i] = 0;
	hashheader.boundarychars[i] = 0;
	/*
	 * The default sort order is a big value so that there is room
	 * to insert "underneath" it.  In this way, special characters
	 * will sort last, but in ASCII order.
	 */
	hashheader.sortorder[i] = i + 1 + 2 * SET_SIZE;
	}
    for (i = 0;  i < SET_SIZE;  i++)
	hashheader.stringstarts[i] = 0;
    for (i = 0;  i < MAXSTRINGCHARS;  i++)
	{
	hashheader.stringdups[i] = i;
	hashheader.dupnos[i] = 0;
	}
    
    hashheader.sortval = 1;	/* This is so 0 can mean uninitialized */
    (void) bcopy (NRSPECIAL, hashheader.nrchars, sizeof hashheader.nrchars);
    (void) bcopy (TEXSPECIAL, hashheader.texchars, sizeof hashheader.texchars);
    hashheader.defspaceflag = 1; /* Default is to report missing blanks */
    hashheader.defhardflag = 0; /* Default is to try hard only if failures */
    hashheader.nstrchars = 0;	/* No string characters to start with */
    hashheader.flagmarker = '/'; /* Default flag marker is slash */
    /* Set up magic number and compile options */
    hashheader.magic = MAGIC;
    hashheader.compileoptions = COMPILEOPTIONS;
    hashheader.maxstringchars = MAXSTRINGCHARS;
    hashheader.maxstringcharlen = MAXSTRINGCHARLEN;
    }

static int grabchar ()		/* Get a character and count lines */
    {
    int			ch;	/* Next input character */

    if (ungrablen > 0)
	ch = lexungrab[--ungrablen] & 0xFF;
    else
	ch = getc (aff_file);
    if (ch == '\n')
	lineno++;
    return ch;
    }

static void ungrabchar (ch)	/* Unget a character, tracking line numbers */
    int			ch;	/* Character to put back */
    {

    if (ch == '\n')
	lineno--;
    if (ch != EOF)
	{
	if (ungrablen == sizeof (lexungrab))
	    yyerror (PARSE_Y_UNGRAB_PROBLEM);
	else
	    lexungrab[ungrablen++] = ch;
	}
    }

static int sufcmp (flag1, flag2)	/* Compare suffix flags for qsort */
    register struct flagent *	flag1;	/* Flags to be compared */
    register struct flagent *	flag2;	/* ... */
    {
    register ichar_t *		cp1;	/* Pointer into flag1's suffix */
    register ichar_t *		cp2;	/* Pointer into flag2's suffix */

    if (flag1->affl == 0  ||  flag2->affl == 0)
	return flag1->affl - flag2->affl;
    cp1 = flag1->affix + flag1->affl;
    cp2 = flag2->affix + flag2->affl;
    while (*--cp1 == *--cp2  &&  cp1 > flag1->affix  &&  cp2 > flag2->affix)
	;
    if (*cp1 == *cp2)
	{
	if (cp1 == flag1->affix)
	    {
	    if (cp2 == flag2->affix)
		return 0;
	    else
		return -1;
	    }
	else
	    return 1;
	}
    return *cp1 - *cp2;
    }

static int precmp (flag1, flag2)	/* Compare prefix flags for qsort */
    register struct flagent *	flag1;	/* Flags to be compared */
    register struct flagent *	flag2;	/* ... */
    {

    if (flag1->affl == 0  ||  flag2->affl == 0)
	return flag1->affl - flag2->affl;
    else
	return icharcmp (flag1->affix, flag2->affix);
    }

static int addstringchar (str, lower, upper) /* Add a string character */
    register unsigned char *	str;	/* String character to be added */
    int				lower;	/* NZ if a lower string */
    int				upper;	/* NZ if an upper string */
    {
    int				len;	/* Length of the string */
    register int		mslot;	/* Slot being moved or modified */
    register int		slot;	/* Where to put it */

    len = strlen ((char *) str);
    if (len > MAXSTRINGCHARLEN)
	{
	yyerror (PARSE_Y_LONG_STRING);
	}
    else if (len == 0)
	{
	yyerror (PARSE_Y_NULL_STRING);
	return -1;
	}
    else if (hashheader.nstrchars >= MAXSTRINGCHARS)
	{
	yyerror (PARSE_Y_MANY_STRINGS);
	return -1;
	}

    /*
     * Find where to put the new character
     */
    for (slot = 0;  slot < hashheader.nstrchars;  slot++)
	{
	if (stringcharcmp (&hashheader.stringchars[slot][0], (char *) str) > 0)
	    break;
	}
    /*
     * Fix all duplicate numbers to reflect the new slot.
     */
    for (mslot = hashheader.nstrchars;  --mslot >= 0;  )
	{
	if (hashheader.stringdups[mslot] >= slot)
	    hashheader.stringdups[mslot]++;
	}
    /*
     * Fix all characters before it so that their case conversion reflects
     * the new locations of the characters that will follow the new one.
     */
    slot += SET_SIZE;
    for (mslot = SET_SIZE;  mslot < slot;  mslot++)
	{
	if (hashheader.lowerconv[mslot] >= slot)
	    hashheader.lowerconv[mslot]++;
	if (hashheader.upperconv[mslot] >= slot)
	    hashheader.upperconv[mslot]++;
	}
    /*
     * Slide up all the other characters to make room for the new one, also
     * making the appropriate changes in the case-conversion tables.
     */
    for (mslot = hashheader.nstrchars + SET_SIZE;  --mslot >= slot;  )
	{
	(void) strcpy (&hashheader.stringchars[mslot + 1 - SET_SIZE][0],
	  &hashheader.stringchars[mslot - SET_SIZE][0]);
	hashheader.lowerchars[mslot + 1] = hashheader.lowerchars[mslot];
	hashheader.upperchars[mslot + 1] = hashheader.upperchars[mslot];
	hashheader.wordchars[mslot + 1] = hashheader.wordchars[mslot];
	hashheader.boundarychars[mslot + 1] = hashheader.boundarychars[mslot];
	if (hashheader.lowerconv[mslot] >= slot)
	    hashheader.lowerconv[mslot]++;
	if (hashheader.upperconv[mslot] >= slot)
	    hashheader.upperconv[mslot]++;
	hashheader.lowerconv[mslot + 1] = hashheader.lowerconv[mslot];
	hashheader.upperconv[mslot + 1] = hashheader.upperconv[mslot];
	hashheader.sortorder[mslot + 1] = hashheader.sortorder[mslot];
	hashheader.stringdups[mslot + 1 - SET_SIZE] =
	  hashheader.stringdups[mslot - SET_SIZE];
	hashheader.dupnos[mslot + 1 - SET_SIZE] =
	  hashheader.dupnos[mslot - SET_SIZE];
	}
    /*
     * Insert the new string character into the slot we made.  The
     * caller may choose to change the case-conversion field.
     */
    (void) strcpy (&hashheader.stringchars[slot - SET_SIZE][0], (char *) str);
    hashheader.lowerchars[slot] = lower;
    hashheader.upperchars[slot] = upper;
    hashheader.wordchars[slot] = 1;
    hashheader.boundarychars[slot] = 0;
    hashheader.sortorder[slot] = hashheader.sortval++;
    hashheader.lowerconv[slot] = slot;
    hashheader.upperconv[slot] = slot;
    hashheader.stringdups[slot - SET_SIZE] = slot - SET_SIZE;
    hashheader.dupnos[slot - SET_SIZE] = 0;
    /*
     * Add the first character of the string to the string-starts table, and
     * bump the count.
     */
    hashheader.stringstarts[str[0]] = 1;
    hashheader.nstrchars++;
    return slot;
    }

/*
 * This routine is a reimplemention of strcmp(), needed because the
 * idiots at Sun managed to screw up the implementation of strcmp on
 * Sun 4's (they used unsigned comparisons, even though characters
 * default to signed).  I hate hate HATE putting in this routine just
 * to support the stupidity of one programmer who ought to find a new
 * career digging ditches, but there are a lot of Sun 4's out there,
 * so I don't really have a lot of choice.
 */
#ifdef SUN4_IS_STUPID
static int stringcharcmp (a,  b)
    register char *		a;
    register char *		b;
    {

    while (*a != '\0')
	{
	if (*a++ != *b++)
	    return *--a - *--b;
	}
    return *a - *b;
    }
#endif /* SUN_4_IS_STUPID */

#ifdef TBLDEBUG
static void tbldump (flagp, numflags)	/* Dump a flag table */
    register struct flagent *	flagp;	/* First flag entry to dump */
    register int		numflags; /* Number of flags to dump */
    {
    while (--numflags >= 0)
	entdump (flagp++);
    }

static void entdump (flagp)		/* Dump one flag entry */
    register struct flagent *	flagp;	/* Flag entry to dump */
    {
    register int		cond;	/* Condition number */

    (void) fprintf (stderr, "flag %s%c:\t",
      (flagp->flagflags & FF_CROSSPRODUCT) ? "*" : "",
      BITTOCHAR (flagp->flagbit));
    for (cond = 0;  cond < flagp->numconds;  cond++)
	{
	setdump (flagp->conds, 1 << cond);
	if (cond < flagp->numconds - 1)
	    (void) putc (' ', stderr);
	}
    if (cond == 0)			/* No conditions at all? */
	(void) putc ('.', stderr);
    (void) fprintf (stderr, "\t> ");
    (void) putc ('\t', stderr);
    if (flagp->stripl)
	(void) fprintf (stderr, "-%s,", ichartosstr (flagp->strip, 1));
    (void) fprintf (stderr, "%s\n",
      flagp->affl ? ichartosstr (flagp->affix, 1) : "-");
    }

static void setdump (setp, mask)	/* Dump a set specification */
    register char *		setp;	/* Set to be dumped */
    register int		mask;	/* Mask for bit to be dumped */
    {
    register int		cnum;	/* Next character's number */
    register int		firstnz; /* Number of first NZ character */
    register int		numnz;	/* Number of NZ characters */

    numnz = 0;
    for (cnum = SET_SIZE + hashheader.nstrchars;  --cnum >= 0;  )
	{
	if (setp[cnum] & mask)
	    {
	    numnz++;
	    firstnz = cnum;
	    }
	}
    if (numnz == 1)
	{
	if (cnum < SET_SIZE)
	    (void) putc (firstnz, stderr);
	else
	    (void) fputs (hashheader.stringchars[cnum - SET_SIZE], stderr);
	}
    else if (numnz == SET_SIZE)
	(void) putc ('.', stderr);
    else if (numnz > SET_SIZE / 2)
	{
	(void) fprintf (stderr, "[^");
	subsetdump (setp, mask, 0);
	(void) putc (']', stderr);
	}
    else
	{
	(void) putc ('[', stderr);
	subsetdump (setp, mask, mask);
	(void) putc (']', stderr);
	}
    }

static void subsetdump (setp, mask, dumpval) /* Dump part of a set spec */
    register char *		setp;	/* Set to be dumped */
    register int		mask;	/* Mask for bit to be dumped */
    register int		dumpval; /* Value to be printed */
    {
    register int		cnum;	/* Next character's number */
    register int		rangestart; /* Value starting a range */

    for (cnum = 0;  cnum < SET_SIZE;  setp++, cnum++)
	{
	if (((*setp ^ dumpval) & mask) == 0)
	    {
	    for (rangestart = cnum;  cnum < SET_SIZE;  setp++, cnum++)
		{
		if ((*setp ^ dumpval) & mask)
		    break;
		}
	    if (cnum == rangestart + 1)
		(void) putc (rangestart, stderr);
	    else if (cnum <= rangestart + 3)
		{
		while (rangestart < cnum)
		    {
		    (void) putc (rangestart, stderr);
		    rangestart++;
		    }
		}
	    else
		(void) fprintf (stderr, "%c-%c", rangestart, cnum - 1);
	    }
	}
    for (  ;  cnum < SET_SIZE + hashheader.nstrchars;  setp++, cnum++)
	{
	if (((*setp ^ dumpval) & mask) == 0)
	    (void) fputs (hashheader.stringchars[cnum - SET_SIZE], stderr);
	}
    }
#endif
