;  LAST EDIT: Thu Dec  2 07:35:35 1993 by ekki(@prakinf.tu-ilmenau.de)

(defun first-error () (interactive) (next-error t))
(defun compile-all () "make all" (interactive) ( compile "make all"))
(defun copyright () "Insert copyright hint" (interactive) (insert-buffer "header.txt"))

(global-set-key '[f1] 'help-for-help)
(global-set-key '[f2] 'eval-defun)
(global-set-key '[f3] 'eval-current-buffer)

(global-set-key '[f7] 'first-error)  
(global-set-key '[f8] 'next-error)  
(global-set-key '[f9] 'compile-all) 
(global-set-key '[f10] 'copyright)  
(global-set-key '[f11] 'tcl-send-current-line) 
(global-set-key '[f12] 'tcl-send-region)  

(defconst last-edit-string " LAST EDIT: " )
(defconst last-edit-by-user-string " by " "Used by the last-edit command.")

(defun insert-last-edit () (interactive) (insert-string " LAST EDIT: ")
 (last-edit)
)

(defun last-edit ()
  "Insert the current date and the user's full name enclosed in comments,
 according to the mode, in the current buffer, if buffer is not read-only."
  (if (and (not buffer-read-only)
	   comment-start
	   (not (string-match "^\\*gnews\\*" (buffer-name))))
      (progn
	(setq current-point (point))
	(goto-char (point-min))
	(if (search-forward last-edit-string nil t)
	    (progn
	      (kill-line)
	      (insert (current-time-string)
		      last-edit-by-user-string
		      ;(user-full-name)
		      (user-login-name) 
		      "(@prakinf.tu-ilmenau.de)"
		      )
	      (beginning-of-line)
	      )
	(insert comment-start
	  last-edit-string
		  (current-time-string)
		  last-edit-by-user-string
		  ;(user-full-name)
		  ;"ekki"
		  ;" (" (user-login-name) 
		  (user-login-name) 
		  "(@prakinf.tu-ilmenau.de)"
		  comment-end
		  "\n")
	  )
	(set-buffer-modified-p nil)
	(goto-char current-point)
	nil)))

(setq write-file-hooks (cons 'last-edit write-file-hooks))
(find-file (concat (getenv "GOOD_ROOT_DIR") "/YART/etc/header.txt" ))
(load-file "${GOOD_ROOT_DIR}/YART/etc/tcl-mode.el" )

(autoload 'tcl-mode "tcl-mode" "Major mode for editing tcl-scripts." t)
(setq auto-mode-alist (cons '("\\.tcl$" . tcl-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.yrt$" . tcl-mode) auto-mode-alist))

; enter the application you want here:

;( setq tcl-default-application (concat (getenv "GOOD_ROOT_DIR") "/YART/bin/tkrt"))
( setq tcl-default-application (concat (getenv "GOOD_ROOT_DIR") "/YART/bin/rtsh"))
;( setq tcl-default-application "wish")



