#ifndef lint
static       char    rcsid[] = "$Header: vertex.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	vertex.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * a VERTEX is associated with a POLYLINE entity.
 *
 * a VERTEX may have starting and ending widths. right now they are not used
 * as it is very difficult to implement. only the widths of the POLYLINE are
 * used, but they should be the same. as there is no smooth surface allowed,
 * there are only 3D polyline vertices or 3D polygon mesh vertices in the
 * VERTEX sequences.
 *
 * a VERTEX may have curve fit tangent. but i cannot handle it as i cannot
 * handle curves and curve surfaces.
 *
 * the bulge value of a VERTEX is the tangent of 1/4 the included angle for
 * an ARC segment, made negative if the arc goes clockwise from the start
 * point to the emd point; a bulge of 0 indicates a straight segment, and
 * a bulge of 1 is a semi-circle.
 *
 * note:
 * bulge and vertex flag are not options according to the AutoCAD manual.
 * but they do not always occur in a DXF file. so i would assume they are
 * options with default value 0.
 */

/*
 * vertex data structure and attribute flags (they are bit-coded)
 * are defined in defs.h.
 */

#ifdef	NEVER_DEFINED
/*
 * define vertex data structure
 */

typedef	struct	vertex	{
	FLOAT	point[3];		/* location of the vertex */
	INT	startwidthset;		/* if starting width is present */
	FLOAT	startwidth;		/* starting width, default is */
					/* defined by POLYLINE */
	INT	endwidthset;		/* if ending width is present */
	FLOAT	endwidth;		/* ending width, default is */
					/* defined by POLYLINE */
	FLOAT	bulge;			/* bulge, what is its meaning ? */
	INT	vertexflag;		/* vertex flag (bit-coded) */
	FLOAT	fittangentset;		/* if the fittangent is present */
	FLOAT	fittangent;		/* curve fit tangent direction */
	OPTIONS	*options;		/* optional parameters */
} VERTEX;

/*
 * define vertex flags (bit-coded)
 */

#define	VERTEX_EXTRA		1	/* extra vertex created by curve */
					/* fitting */
#define	VERTEX_TANGENT		2	/* curve fit tangent defined for */
					/* this vertex. a curve fit tangent */
					/* direction of 0 may be omitted from */
					/* the DXF output, but is significant */
					/* if this bit is set */
#define	VERTEX_UNUSED		4	/* unused (never set in DXF files */

#define	VERTEX_SPLINE		8	/* spline vertex created by spline */
					/* fitting */
#define	VERTEX_CONTROL		16	/* spline frame control point */

#define	VERTEX_POLYGON		32	/* 3D POLYLINE vertex */

#define	VERTEX_MESH		64	/* 3D POLYLINE mesh vertex */
#endif

/*
 * parse a VERTEX
 */

/*ARGSUSED*/
VERTEX	*VertexDxfParse(layerlist)
LAYER	**layerlist;
{
	VERTEX	*vertex;
	INT	pointset = 0;
	INT	bulgeset = 0;
	INT	flagset = 0;
	INT	defaultflag = 0;

	vertex = Malloc(VERTEX, 1);

	vertex->vertexflag = 0;
	vertex->bulge = 0.0;

	/*
	 * the layer name of a vertex is not used
	 *
	 * entity->layer = LayerDxfParse(layerlist);
	 */

	do {
		GetNextGroup();
		switch(Group->code) {
		case 8:
			/*
			 * layer name is not used
			 */
			break;
		case 10:
			/*
			 * position
			 * 10, 20, 30
			 */

			if (pointset != 0)
				DXFERR("duplicated position for a VERTEX %s", "\n");

			pointset = 1;
			CoordDxfParse(0, vertex->point);
			break;

		case 40:
			/*
			 * starting width
			 */

			if (vertex->startwidthset != 0)
				DXFERR("duplicated starting width for a VERTEX %s", "\n");

			vertex->startwidthset = 1;
			vertex->startwidth = Group->fltnum;
			break;

		case 41:
			/*
			 * ending width
			 */

			if (vertex->endwidthset != 0)
				DXFERR("duplicated ending width for a VERTEX %s", "\n");

			vertex->endwidthset = 1;
			vertex->endwidth = Group->fltnum;
			break;

		case 42:
			/*
			 * bulge
			 */

			if (bulgeset != 0)
				DXFERR("duplicated bulge for a VERTEX %s", "\n");

			bulgeset = 1;
			vertex->bulge = Group->fltnum;
			break;

		case 70:
			/*
			 * vertex flags
			 */

			if (flagset != 0)
				DXFERR("duplicated flag for a VERTEX %s", "\n");

			flagset = 1;
			vertex->vertexflag = Group->intnum;
			break;

		case 50:
			/*
			 * curve fit tangent
			 */

			if (vertex->fittangentset != 0)
				DXFERR("duplicated curve fit tangent for a VERTEX %s", "\n");

			vertex->fittangentset = 1;
			vertex->fittangent = Group->fltnum;
			break;

		default:
			if (OptionsDxfParse(&vertex->options) == 0)
				defaultflag = 1;
			break;
		}
	} while (defaultflag == 0);

	/*
	 * check if position, bulge and vertex flags are all defined
	 */

	if (pointset == 0)
		DXFERR("undefined position for a VERTEX %s", "\n");

	/*
	 * bulge and vertex flag are not options according to the
	 * AutoCAD manual. but they do not always occur in a DXF file.
	 * so i would assume they are options with default value 0.
	 *
	 * if (bulgeset == 0)
	 * 	DXFERR("undefined bulge for a VERTEX %s", "\n");
	 *
	 * if (flagset == 0)
	 * 	DXFERR("undefined flag for a VERTEX %s", "\n");
	 */ 

	/*
	 * check if the vertex is a 3D polyline vertex
	 * or a 3D polygon mesh vertex
	 * as i cannot handle curves or curve surfaces
	 */

	if (vertex->vertexflag != 0)
		if (vertex->vertexflag != VERTEX_POLYGON &&
		    vertex->vertexflag != VERTEX_MESH &&
		    vertex->vertexflag != (VERTEX_POLYGON | VERTEX_MESH))
			DXFERR("VERTEX should be 3D polyline vertex or/and 3D polygon mesh vertex %s", "\n");

	/*
	 * error if a vertex have curve fit tangent
	 * as i cannot handle curves or curve surfaces
	 *
	 * originally i use
	 * if (vertex->fittangentset != 0 && fabs(vertex->fittangent) > TOE)
	 * for error checking, but it happens in some DXF files
	 * when smooth surface type is 7 (undefined in the manual),
	 * its vertices can have non-zero fit tangent value
	 */

	/*
	 * if (vertex->fittangentset != 0 && fabs(vertex->fittangent) > TOE)
	 * 	DXFERR("VERTEX cannot have curve fit tangent %s", "\n");
	 */

	return(vertex);
}
