#ifndef lint
static       char    rcsid[] = "$Header: stack.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	stack.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

static	STACK	*Stack[MaxStackLevel];	/* stack for handling blocks */
					/* note it is an array of pointers */
					/* stacks */

static	INT	CurrentStackLevel = -1;	/* current stack level */

/*
 * push a block into stack
 *
 * re-calculate the transformation matrix based on insertion base point
 *
 * set up current transform stack
 */

VOID	StackPush(insert, matrix)
INSERT	*insert;
MATRIX	matrix[2];
{
	int	i;

	if (CurrentStackLevel == MaxStackLevel)
		GENERR("block stack overflow when processing block %s\n",
			insert->block->name);

	/*
	 * check if the block is already in the stack
	 * if true, the block is recursive defined
	 */

	if (CurrentStackLevel >= 0)
		for (i = 0; i <= CurrentStackLevel; i++)
			if (Stack[i]->insert->block == insert->block)
				GENERR("block %s is recursively defined\n",
				insert->block->name);

	CurrentStackLevel++;
	Stack[CurrentStackLevel] = Malloc(STACK, 1);

	Stack[CurrentStackLevel]->insert = insert;
	(VOID) bcopy(matrix, Stack[CurrentStackLevel]->singlematrix, 2 * sizeof(MATRIX));

	if (CurrentStackLevel == 0)
		(VOID) bcopy(matrix, Stack[CurrentStackLevel]->matrix, 2 * sizeof(MATRIX));
	else
		MatrixMultiply(Stack[CurrentStackLevel - 1]->matrix, matrix,
		 		       Stack[CurrentStackLevel    ]->matrix);

	CurrentStack = Stack[CurrentStackLevel];
}

/*
 * pop from stack
 *
 * set up current transform stack
 */

VOID	StackPop()
{
	if (CurrentStackLevel == -1)
		DXFERR("block stack empty %s", "\n");

	free(Stack[CurrentStackLevel]);
	CurrentStackLevel--;

	if (CurrentStackLevel == -1)
		CurrentStack = NULL;
	else
		CurrentStack = Stack[CurrentStackLevel];
}
