#ifndef lint
static       char    rcsid[] = "$Header: name.c,v 1.2 90/12/12 15:30:21 zhang Exp $";
#endif

/*
 * $Log:	name.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#include "defs.h"

/*
 * insert an object name into the name list
 *
 * an object name is the layer name of an entity defined in ENTITIES section,
 * or block name - layer name for an entity defined within a block
 */

static	NAME	*NameListTail = NULL;

CHAR	*NameInsert(layer)
LAYER	*layer;
{
	NAME	*name;
	CHAR	*namebuf;

	if (NameList == NULL) {
		NameList = NameListTail = name = Malloc(NAME, 1);
		if (CurrentStack == NULL || JoinMode == 0) {
			name->name = layer->name;
			return(name->name);
		}

		name->name = Malloc(CHAR, strlen(layer->name) +
				strlen(CurrentStack->insert->block->name) + 
				strlen(JoinStr) + 1);

		(VOID) strcpy(name->name, CurrentStack->insert->block->name);
		(VOID) strcat(name->name, JoinStr);
		(VOID) strcat(name->name, layer->name);
	}

	if (CurrentStack == NULL || JoinMode == 0) {
		for (name = NameList; name != NULL; name = name->next)
			if (strcmp(layer->name, name->name) == 0)
				return(name->name);

		name = Malloc(NAME, 1);
		name->name = layer->name;
		NameListTail->next = name;
		NameListTail = name;
		return(name->name);
	}

	namebuf = Malloc(CHAR, strlen(layer->name) +
			strlen(CurrentStack->insert->block->name) +
			strlen(JoinStr) + 1);
	(VOID) strcpy(namebuf, CurrentStack->insert->block->name);
	(VOID) strcat(namebuf, JoinStr);
	(VOID) strcat(namebuf, layer->name);

	for (name = NameList; name != NULL; name = name->next)
		if (strcmp(namebuf, name->name) == 0) {
			free(namebuf);
			return(name->name);
		}

	name = Malloc(NAME, 1);
	name->name = namebuf;
	NameListTail->next = name;
	NameListTail = name;
	return(name->name);
}

/*
 * Output a layer name for an entity into DXF file
 */

VOID	NameDxfOutput(layer)
LAYER	*layer;
{
	CHAR	*name;

	name = NameInsert(layer);

	if (OutFileType == FILE_DXF)
	 	fprintf(OutFile, "  0\n3DFACE\n  8\n%s\n", name);
}

/*
 * Output a layer name for an entity into RAD file
 */

VOID	NameRadOutput(layer)
LAYER	*layer;
{
	CHAR	*name;

	name = NameInsert(layer);

	if (OutFileType == FILE_RAD) {
		if (isalpha(name[0]) == 0) {
			fprintf(OutFile, "%s", PrefixStr);
		}

	 	fprintf(OutFile, "%s ", name);
	}
}

/*
 * Output an object/surface name for an entity into DEF/NFF file
 */

VOID	NameOutput(layer)
LAYER	*layer;
{
	CHAR	*c;
	CHAR	*name;

	name = NameInsert(layer);

	if (OutFileType == FILE_DEF)
		fprintf(OutFile, "object ");
	else
	if (OutFileType == FILE_NFF)
		fprintf(OutFile, "surface ");
	else
	if (OutFileType == FILE_RAD)
		return;
	else
	if (OutFileType == FILE_DXF) {

		/*
		 * fprintf(OutFile, "  8\n%s\n", name);
		 */

		return;
	}

	/*
	 * some parser does not allow a name starting with non-alpha
	 * chars, so for a prefix 'PrefixStr' is added
	 */

	if (isalpha(name[0]) == 0) {
		fprintf(OutFile, "%s", PrefixStr);
	}

	for (c = name; *c != '\0'; c++)
		if (*c == '-')
			fputc('_', OutFile);
		else
			fputc(*c, OutFile);

	fprintf(OutFile, "\n");
}
