#ifndef lint
static       char    rcsid[] = "$Header: line.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	line.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

/*
 * a LINE may have thickness, but no width
 * if it has thickness, then a 3d face is defined along the extrusion direction
 */

#include "defs.h"

typedef	struct	line	{
	FLOAT	startpoint[3];		/* start point of the line */
	FLOAT	endpoint[3];		/* end point of the line */
} LINE;

ENTITY	*LineDxfParse(layerlist)
LAYER	**layerlist;
{
	ENTITY	*entity;
	LINE	*line;
	INT	startpointset = 0;
	INT	endpointset = 0;
	INT	defaultflag = 0;

	entity = Malloc(ENTITY, 1);
	line = Malloc(LINE, 1);
	entity->type = ENTITY_LINE;
	entity->data = (VOID *) line;

	entity->layer = LayerDxfParse(layerlist);

	do {
		GetNextGroup();
		switch(Group->code) {
		case 10:
			/*
			 * start point
			 * 10, 20, 30
			 */

			if (startpointset != 0)
				DXFERR("duplicated start point for a LINE %s", "\n");

			startpointset = 1;
			CoordDxfParse(0, line->startpoint);
			break;

		case 11:
			/*
			 * end point
			 * 11, 21, 31
			 */

			if (endpointset != 0)
				DXFERR("duplicated end point for a LINE %s", "\n");

			endpointset = 1;
			CoordDxfParse(1, line->endpoint);
			break;

		default:
			if (OptionsDxfParse(&entity->options) == 0)
				defaultflag = 1;
			break;
		}
	} while (defaultflag == 0);

	/*
	 * check if start point and end point are all defined
	 */

	if (startpointset == 0)
		DXFERR("undefined start point for a LINE %s", "\n");

	if (endpointset == 0)
		DXFERR("undefined end point for a LINE %s", "\n");

	return(entity);
}

/*
 * output faces defined by a LINE into DEF/NFF/DEF file
 */

VOID	LineDefOutput(entity)
ENTITY	*entity;
{
	LINE	*line;
	FLOAT	thickness;
	FLOAT	*extrusion;
	FLOAT	delta[3];
	FLOAT	polygon[4][3];

	line = (LINE *) entity->data;

	VecSub(line->startpoint, line->endpoint, delta);

	if (VecDot(delta, delta) < TOE)
		return;

	if (OptionsThickness(entity->options, &thickness) == 0)
		return;

	extrusion = OptionsExtrusion(entity->options);

	VecScale(thickness, extrusion, delta);
	VecCopy(line->startpoint, polygon[0]);
	VecCopy(line->endpoint, polygon[1]);
	VecAdd(line->endpoint, delta, polygon[2]);
	VecAdd(line->startpoint, delta, polygon[3]);

	if (OutFileType != FILE_DXF)
		NameOutput(entity->layer);

	OutputPolygon(4, polygon, entity);
}
