#ifndef __FHARD_H__
#define __FHARD_H__

#include "../pixmap.h"
#include "../color.h"
#include "ftype.h"

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <stdlib.h>
#include <math.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

extern TColorTyp ColorTyp;           /* 256 Farben oder Echtfarbe ? */
extern RT_Pixmap *bitmap;            // bitmap output

/* Grafik einschalten, liefert true, wenn erfolgreich */
extern int G_On(RT_Pixmap *_bitmap);

/* Standard-VGA Mode (Text) aktivieren und evtl. alte Palette
   wieder einstellen */
extern void G_Off(void);

/* setzt ein Pixel mit den Koordinaten x, y mit der Farbe r,g,b
   in Abhaengigkeit von ColorTyp */
extern void RGB_Dot(int x, int y, int r, int g, int b);

/* Linie von x1,y1 nach x2,y2 (mit Farbe r,g,b
   in Abhaengigkeit von ColorTyp) zeichnen */
extern void RGB_Line(int x1, int y1, int x2, int y2, int r, int g, int b);

#endif 
