//  LAST EDIT: Tue Dec 21 10:42:45 1993 by ekki(@prakinf.tu-ilmenau.de)
#include "fisher.h"


mat4 E = {
  { 1.0, 0.0, 0.0, 0.0 },
  { 0.0, 1.0, 0.0, 0.0 },
  { 0.0, 0.0, 1.0, 0.0 },
  { 0.0, 0.0, 0.0, 1.0 }
};                        /* Einheitsmatrix */

vct3 e_z = {
  0.0, 0.0, 1.0
};                        /* Einheitsvektor in +z   */

vct3 me_z = {
  0.0, 0.0, -1.0
};                        /* Einheitsvektor in -z   */


void GraphError(char *s)
{
  GraphClose();

  fprintf(stdout,"%s\n",s);  // only for test 

  exit(EXIT_FAILURE);
}

void GraphInit(RT_Pixmap *_bitmap) {
  ClipMode = toClip;
  VolClipCode = 0xff;
  
  FlipAreaEnabled    = false;
  WireFrame          = false;
  TriFillEnable      = true;

  ShadingMethod      = Gouraud;    // or Flat
  ColorTyp           = Palette;    // or TrueColour

  MeshSpace          = defMeshSpace;  // leave some space for meshes

  surfaceProperty.Ka = 1.0;
  surfaceProperty.Kd = 1.0;
  surfaceProperty.Ks = 1.0;
  surfaceProperty.Oe = 400;
  surfaceProperty.Os.r = 1;
  surfaceProperty.Os.g = 1;
  surfaceProperty.Os.b = 1;

  if(!G_On(_bitmap))
    GraphError("g_graph: GraphInit: Grafik-Mode kann nicht eingestellt werden");
  rt_XMaxGlobal = _bitmap->getW() - 1;
  rt_YMaxGlobal = _bitmap->getH() - 1;

  rt_Aspect = 1;

  memcpy(MC_WC, E, sizeof(mat4));
  TrafStack = NULL;
  LsListRoot = NULL;   /*               Lichtquellenliste initialisieren */
}


void GraphClose(void)
{
  G_Off();
}
