#include "fisher.h"

void CLine_Interpol(double t, vct4 a, vct4 *b) {
  /* berechnet b zu b:=a+t*(b-a). t gibt an, wieviel der Linie
     zwischen a und b von a aus gesehen beruecksichtigt wird */
  b->w = a.w + t * (b->w - a.w);
  b->x = a.x + t * (b->x - a.x);
  b->y = a.y + t * (b->y - a.y);
  b->z = a.z + t * (b->z - a.z);
}

boolean CLine_DoClip(double g1, double g2, vct4 *a, vct4 *b) {
  double t;
  if (g1 > 0) {
    if (g2 <= 0) {                /* a innen, b aussen             */
      t = g1 / (g1 - g2);
      CLine_Interpol(t, *a, b);   /* b neu berechnen              */
    }
  }
  if (g2 <= 0)
    return (g1 > 0 || g2 > 0);
  if (g1 <= 0) {                  /* a aussen, b innen             */
    t = g2 / (g2 - g1);
    CLine_Interpol(t, *b, a);     /* a neu berechnen              */
  }
  return (g1 > 0 || g2 > 0);      /* DoClip=TRUE, wenn entweder a */
}                                 /* oder b innen                 */

void Cline(vct4 a, vct4 b) {
  /* Cline zeichnet eine Linie von a nach b (homogene Koordinaten).
     a und b muessen in das NPC transformiert sein.
     Es wird in x,y,z-Richtung geclippt */
  double x1, y1, x2, y2;

  if (!CLine_DoClip(a.w - a.y, b.w - b.y, &a, &b))/*an y=w ("oben") clippen */
	  return;
  if (!CLine_DoClip(a.y, b.y, &a, &b))        /*an y=0 ("unten") clippen*/
    return;
  if (!CLine_DoClip(a.w - a.x, b.w - b.x, &a, &b))/*an x=w ("rechts") clippen*/
	  return;
  if (!CLine_DoClip(a.x, b.x, &a, &b))        /*an x=0 ("links") clippen*/
    return;
  if (!CLine_DoClip(a.w - a.z, b.w - b.z, &a, &b))/*an z=w ("vorne") clipen */
	  return;
  if (!CLine_DoClip(a.z, b.z, &a, &b))            /*an z=0 ("hinten") clipen*/
    return;
  NPCtoDC(a, &x1, &y1);                           /* a abbilden in DC       */
  NPCtoDC(b, &x2, &y2);                           /* b abbilden in DC       */
  line2d(x1, y1, x2, y2);                         /* Linie zeichnen         */
}

/* Local variables for PolyClip: */
struct LOC_PolyClip {
  int *PointCnt;
  vertex *aPoints;
  int pc;
  /* Die beiden folgenden Arrays dienen zur Aufnahme des Polygons in
  homogenen Koordinaten: */
  vct4 hPoints[maxPnts], hClipPoints[maxPnts];
  vertex aClipPoints[maxPnts];   /* geclipptes Polygon im MC */
  vct4 prePh, aktPh, firPh;   /* Hilfspunkte im NPC       */
  vertex prePa, aktPa, firPa;   /* Hilfspunkte im MC        */
  double t;   /* Interpolationsparameter  */
} V;


void PoC_Interpol(vct4 *iPh, vct4 *aktPh, vertex *iPa, vertex *aktPa,
		     struct LOC_PolyClip *LINK)
{
  /* neuer Punkt im NPC (nur Koordinaten): */
  iPh->w = LINK->prePh.w + LINK->t * (aktPh->w - LINK->prePh.w);
  iPh->x = LINK->prePh.x + LINK->t * (aktPh->x - LINK->prePh.x);
  iPh->y = LINK->prePh.y + LINK->t * (aktPh->y - LINK->prePh.y);
  iPh->z = LINK->prePh.z + LINK->t * (aktPh->z - LINK->prePh.z);
  /* neuer Punkt im MC (Koordinaten, Normale und Farbe */
      /* Koordinaten */
  iPa->crd.x = LINK->prePa.crd.x + LINK->t * (aktPa->crd.x - LINK->prePa.crd.x);
  iPa->crd.y = LINK->prePa.crd.y + LINK->t * (aktPa->crd.y - LINK->prePa.crd.y);
  iPa->crd.z = LINK->prePa.crd.z + LINK->t * (aktPa->crd.z - LINK->prePa.crd.z);
      /* Normale     */
  iPa->nrm.x = LINK->prePa.nrm.x + LINK->t * (aktPa->nrm.x - LINK->prePa.nrm.x);
  iPa->nrm.y = LINK->prePa.nrm.y + LINK->t * (aktPa->nrm.y - LINK->prePa.nrm.y);
  iPa->nrm.z = LINK->prePa.nrm.z + LINK->t * (aktPa->nrm.z - LINK->prePa.nrm.z);
      /* Farbe       */
  iPa->c.r = LINK->prePa.c.r + LINK->t * (aktPa->c.r - LINK->prePa.c.r);
  iPa->c.g = LINK->prePa.c.g + LINK->t * (aktPa->c.g - LINK->prePa.c.g);
  iPa->c.b = LINK->prePa.c.b + LINK->t * (aktPa->c.b - LINK->prePa.c.b);
  /* Da die Normalen nach dem Flippen die Laenge 1 haben (wird beim
     Belichten so gebraucht), auch interpolierte Normale normieren:  */
  if (DoNorm(&iPa->nrm))
    GraphError("Normale durch Clippen=(0,0,0)");
}

void PoC_DoClip(int i, double g1, double g2, struct LOC_PolyClip *LINK)
{
  LINK->aktPh = LINK->hPoints[i];
  LINK->aktPa = LINK->aPoints[i];
  if (i == 0) {
    LINK->firPh = LINK->aktPh;
    LINK->firPa = LINK->aktPa;
    LINK->pc = 0;
  } else if (g1 > 0 && g2 <= 0 || g1 <= 0 && g2 > 0) {
    LINK->t = g1 / (g1 - g2);
    PoC_Interpol(&LINK->hClipPoints[LINK->pc], &LINK->aktPh,
	      &LINK->aClipPoints[LINK->pc], &LINK->aktPa, LINK);
    LINK->pc++;
  }
  LINK->prePh = LINK->aktPh;
  LINK->prePa = LINK->aktPa;
  if (g2 <= 0)
    return;
  LINK->hClipPoints[LINK->pc] = LINK->aktPh;
  LINK->aClipPoints[LINK->pc] = LINK->aktPa;
  LINK->pc++;
}

boolean PoC_LastClip(double g1, double g2, struct LOC_PolyClip *LINK)
{
  int i, FORLIM;

  if (g1 > 0 && g2 <= 0 || g1 <= 0 && g2 > 0) {
    LINK->t = g1 / (g1 - g2);
    PoC_Interpol(&LINK->hClipPoints[LINK->pc], &LINK->firPh,
	      &LINK->aClipPoints[LINK->pc], &LINK->firPa, LINK);
    LINK->pc++;
  }
  FORLIM = LINK->pc;
  for (i = 0; i < FORLIM; i++) {
    LINK->hPoints[i] = LINK->hClipPoints[i];
    LINK->aPoints[i] = LINK->aClipPoints[i];
  }
  *LINK->PointCnt = LINK->pc;
  return (*LINK->PointCnt == 0);
}


void PolyClip(int *PointCnt_, vertex *aPoints_)
{
  /* PolyClip clippt ein Polygon mit PointCnt Punkten. Dabei sind die
     Punkte vom Typ vertex in Modellkoordinaten (d.h. icl.
     Normale und Farbe) gegeben. Zum Clippen werden die Koordinaten
     ins NPC transformiert. */
  int i, FORLIM;

  V.PointCnt = PointCnt_;
  V.aPoints = aPoints_;
  FORLIM = *V.PointCnt;
  /* Zum Clippen erst einmal alle Punkte ins NPC: */
  for (i = 0; i < FORLIM; i++)
    MCtoNPC(V.aPoints[i].crd, &V.hPoints[i]);
  FORLIM = *V.PointCnt;
  for (i = 0; i < FORLIM; i++)   /* an y=w clippen ("oben"):   */
    PoC_DoClip(i, i==0 ? 0 : (V.prePh.w - V.prePh.y), V.hPoints[i].w - V.hPoints[i].y, &V);
  if (PoC_LastClip(V.prePh.w - V.prePh.y, V.firPh.w - V.firPh.y, &V))
    return;
  FORLIM = *V.PointCnt;
  for (i = 0; i < FORLIM; i++)   /* an y=0 clippen ("unten"):  */
    PoC_DoClip(i, i==0 ? 0 : V.prePh.y, V.hPoints[i].y, &V);
  if (PoC_LastClip(V.prePh.y, V.firPh.y, &V))
    return;
  FORLIM = *V.PointCnt;
  for (i = 0; i < FORLIM; i++)   /* an x=w clippen ("rechts"): */
    PoC_DoClip(i, i==0 ? 0 : (V.prePh.w - V.prePh.x), V.hPoints[i].w - V.hPoints[i].x, &V);
  if (PoC_LastClip(V.prePh.w - V.prePh.x, V.firPh.w - V.firPh.x, &V))
    return;
  FORLIM = *V.PointCnt;
  for (i = 0; i < FORLIM; i++)   /* an x=0 clippen ("links"):  */
    PoC_DoClip(i, i==0 ? 0 : V.prePh.x, V.hPoints[i].x, &V);
  if (PoC_LastClip(V.prePh.x, V.firPh.x, &V))
    return;
  FORLIM = *V.PointCnt;
  for (i = 0; i < FORLIM; i++)   /* an z=w clippen ("vorne"):  */
    PoC_DoClip(i, i==0 ? 0 : (V.prePh.w - V.prePh.z), V.hPoints[i].w - V.hPoints[i].z, &V);
  if (PoC_LastClip(V.prePh.w - V.prePh.z, V.firPh.w - V.firPh.z, &V))
    return;
  FORLIM = *V.PointCnt;
  for (i = 0; i < FORLIM; i++)   /* an z=0 clippen ("hinten"): */
    PoC_DoClip(i, i==0 ? 0 : V.prePh.z, V.hPoints[i].z, &V);
  PoC_LastClip(V.prePh.z, V.firPh.z, &V);
}
