#ifndef __RS_DEFS_H
#define __RS_DEFS_H

////////////////////////////////////////////////////////////////////////////////
//       Definition of constants, default values, macros, types.              //
//  LAST EDIT: Fri Aug  5 14:56:37 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <math.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

//###constants
#define epsilon           1e-10
#define epsilon1          1e-1
#define epsilon2          1e-2
#define epsilon3          1e-3
#define epsilon4          1e-4
#define epsilon5          1e-5
#ifndef M_PI
 #define M_PI        3.14159265358979323846
#endif
#ifndef M_2PI
  #define M_2PI       6.28318530717958623000
#endif
#ifndef M_PI_2
  #define M_PI_2      1.57079632679489661923
#endif
#ifndef M_PI_4
  #define M_PI_4      0.78539816339744830962
#endif
#ifndef M_1_PI
  #define M_1_PI      0.31830988618379067154
#endif
#ifndef M_2_PI
  #define M_2_PI      0.63661977236758134308
#endif
#define BIGFLOAT    1e30

#ifndef FALSE
#define FALSE             0
#endif

#ifndef TRUE
#define TRUE              1
#endif

// #define RS_DEBUG             //this is a time consuming (but useful) option!
//#define RS_SHOW              // show the current source vertex 

#define RS_USE_MEM_FUNCS     //if defined, mem... functions are used
#undef  RS_PRINT_ALL         //see the print-methods of the container objects (Points, Areas)
#define RS_MAXl          21 // (RS_MAXl * RS_MAXl): max. size of a BRDF-Matrix, must be odd
#define RS_MAX_COEFF    441 // (RS_MAXl * RS_MAXl)
#define RS_IPHI          89 // solution of function approximation (steps of angle phi), must be odd
#define RS_ITHETA        45 // solution of function approximation (steps of angle theta), must be odd
#define RS_LINE_LEN     255 // string length
#define RS_MAX_BRDFS    128 //max. different BRDFs of a scene
#define RS_MAX_EQSYS     20   //(RS_MAX_EQSYS * RS_MAX_EQSYS): max. size of a matrix used in simultaneous linear equations

#define NONAME "<noname>"
#define NODESCRIPTION "<nodescription>"

//###default values
#define RS_MAX_UNSHOOT        0.1;
#define RS_FAST_MAX_UNSHOOT   5.0;
#define RS_GRAD_MAX_DELTA     1.0
#define RS_SPPAR_DIM         20 // solution of the spatial partitioning structure (RS_SPPAR_NR^^3)
#define RS_NR_SHOOTS        300 // number of iterations  

//###macros
#define _max(a,b) ((a) > (b) ? (a) : (b))
#define _min(a,b) ((a) < (b) ? (a) : (b))

//###types
typedef int boolean;
typedef unsigned char uchar;

#endif

