#ifndef __MAPPING_H__
#define __MAPPING_H__

////////////////////////////////////////////////////////////////////////////////
// Abstract mapping attribute class.                                          //  
// 19/01/94: Reimplementation of Mapping and MappingAttribute                 //
// 20/01/94: Reference counter added                                          //
//  LAST EDIT: Tue Aug 16 10:23:46 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "object.h"
#include "attribut.h"

class RT_Primitive;

extern const char *RTN_MAPPING;

class RT_Mapping: public RT_Object {
    int refcnt;
  protected:
    RT_Mapping(char *name = 0): RT_Object(name) { refcnt = 0;}
    virtual ~RT_Mapping() {
	if ( refcnt ) rt_Output->fatalVar( get_name(), " was deleted though it is still referenced in at least one directly assigned mapping attribute.", 0 );
	
    }
  public:
    int isA(const char *c) const { return RTM_isA( RTN_MAPPING, c ) || RT_Object::isA( c ); }

    virtual void smapping( const RT_Primitive *, const RT_Vector &, RT_Surface&) {};
    virtual void nmapping( const RT_Primitive *, const RT_Vector &, RT_Vector&) {};
    // change surface or normal vector in dependence of the overgiven point
    // of the primitive and the kind of mapping (texture or bump or what else)
    void printCon(FILE *f) const { fprintf( f, "%s %s\n", get_class(), get_name()); }
    void print(FILE *f) const { printCon( f ); }
    int objectCMD(char *[]) { return 0; }
    void ref() { refcnt++; }
    void deref() { refcnt--; }
    int getRef() const { return refcnt; }
};

#endif

