////////////////////////////////////////////////////////////////////////////////
//  LAST EDIT: Fri Aug  5 08:55:27 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "light.h"

const char *RTN_LIGHT = "Light";

RT_IdentGenerator rt_LightIdents;

RT_ParseEntry RT_Light::table[] = {
    {"-on", RTP_NONE, 0, &onF, "Switch light on.", RTPS_NONE },
    {"-off", RTP_NONE, 0, &offF, "Switch light off.", RTPS_NONE },
    {"-get_on", RTP_NONE, 0, &onG, "Return the current state of the light.", RTPS_NONE },
    { "-origin", RTP_VECTOR, (char*)&orgV, &orgF, "Set the {ARG 1 Origin} of the light source.", RTPS_VECTOR },
    { "-get_origin", RTP_NONE, 0, &orgG, "Get the origin of the light source.", RTPS_NONE },
    { "-color", RTP_COLOR, (char*)&colrV, &colrF, "Set the {ARG 1 Color} of the object.", RTPS_COLOR },
    { "-get_color", RTP_NONE, 0, &colrG, "Get the color of the object.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_Light::orgF, RT_Light::orgG, RT_Light::onF, RT_Light::onG, RT_Light::offF, RT_Light::colrF, RT_Light::colrG;
RT_Color RT_Light::colrV;
RT_Vector RT_Light::orgV;

int RT_Light::objectCMD(char *argv[]) {
    RT_parseTable( argv, table );
    int r = onF + offF + onG + colrF + colrG + orgG + orgF;

    if (onF) on();
    if (offF) off();
    if (onG) RT_Object::result( get_on() ? "1" : "0" );

    if (orgF) origin( orgV );
    if (orgG) {
	static char tmp[60];
	RT_vector2string( get_origin(), tmp );
	RT_Object::result( tmp );
	r++;
    }

    if (colrF) color(colrV);
    if (colrG) RT_Object::result( get_color().get() );
    return r;
}

void RT_Light::print(FILE *f) const { 
    printCon( f );
    static char tmp[60];
    RT_vector2string( get_origin(), tmp );
    fprintf( f, "\n%s -origin %s %s -color ", get_name(), tmp, xon ? "" : "-off" );
    xcolor.print( f);
    fprintf(f, "\n" );
}
