////////////////////////////////////////////////////////////////////////////////
//  Implementation of a pick device.                                          //  
//  LAST EDIT: Fri Aug  5 09:23:12 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "pick.h"
#include "../camera.h"

const char *RTN_PICK = "Pick";

int RT_Pick::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a {ARG 1 Pick} object. The pick devices is driven by left mouse button clicks.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 2) {
	    Tcl_AppendResult( ip, argv[0], ": Need one argument.", 0 );
	    return TCL_ERROR;
	}
	new RT_Pick( argv[1] ); 
	RTM_classReturn;
    }
    return res; 
}

int RT_Pick::primG;

RT_ParseEntry RT_Pick::table[] = {
    {"-get_pickedObject", RTP_NONE, 0, &primG, "Return the last picked object.", RTPS_NONE },
{ 0, RTP_END, 0, 0, 0, 0 }
}; 

int RT_Pick::objectCMD(char *argv[]) { 
    int ret = RT_InputDevice::objectCMD( argv );
    RT_parseTable( argv, table );
    if (primG && get_pickedObject() ) RT_Object::result( get_pickedObject()->get_name() );
    return ret + primG;
}

void RT_Pick::event(RT_Event *ev) {
    if ( ev && ev->isA( RTN_BUTTON_EVENT )) {
	RT_ButtonEvent &pev = *(RT_ButtonEvent*)ev;
	if (pev.left && get_camera()) {
	    RT_Ray r;
	    get_camera()->buildRay( ((double)pev.x)/pev.w, 
				   ((double)pev.y)/pev.h, r);

	    if (xprim) xprim->removeRelatedObject( this );

	    xprim = get_camera()->getPrimitive( r );
	    if (xprim && xprim->get_pickmode() != RTE_NOT_PICKABLE ) {
		while ( xprim->get_pickmode() == RTE_PICK_FATHER 
		       && xprim->get_father() ) 
		    xprim = xprim->get_father();

		if (xprim) xprim->addRelatedObject( this );
		xtime = ev->getTime();
		callCBs();
	    }
	    else xprim = 0;
	} 
    }
}



