#ifndef __DEVICE_H__
#define __DEVICE_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of the base class of interaction classes.                      //  
//  LAST EDIT: Fri Aug  5 09:23:09 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../global.h"
#include "callback.h"
#include "strings.h"
#include "input.h"
#include "event.h"
#include "../rlist.h"
#include "../object.h"
#include "../primitiv.h"

extern RT_GeneralList rt_DeviceList;

extern const char *RTN_CAMERA;
class RT_Camera;
class RT_InputDevice;
// forward decl of camera and input device to avoid cyclic definitions

extern const char *RTN_INPUT_DEVICE;

class RT_InputDevice: public RT_Object {
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int onF, offF, onG, addCBF, remCBF, cldG, fatherF, fatherG, 
    camG, timeG;
    static char *addCBV, *remCBV, *fatherV, *camV;
  protected:
    // the related father object:
    RT_Object *xfather;
    RT_Time   xtime;
    
    RT_GeneralList cbList;
    // the callback list
    RT_GeneralList cldList;
    // the child list list
    int xhideChildren;
    //  do not return your children
    int state;
    // the state of the input device
    // TRUE means that the device is on
    
    void addChild( RT_InputDevice *d) { cldList.append( d ); }
    void removeChild( RT_InputDevice *d ) { cldList.remove( d );  }
    
    void callCBs();
    // call all callbacks in the callback list
    void callChildren(RT_Event *);
    // call all child objects 
    
  public:

    //#### Tcl/C++ methods:
    RT_InputDevice(char *_name):RT_Object(_name) { 
	xfather = 0;
	xtime =0;
	xhideChildren = 0;
	rt_InputServer->addObject( this );
	on();
    }
    virtual ~RT_InputDevice();
    // the callback interface: 

    virtual void on() { state = 1; }
    // turn on the device
    virtual void off() { state = 0; }
    // turn off the device
    int get_on() { return state; }

    virtual void father(RT_Object *);
    RT_Object *get_father() { return xfather; }
    RT_Camera *get_camera();
    const RT_GeneralList &get_children() { 
	// get the children of the device  
	if (xhideChildren) return RT_NULL_LIST; 
	else return cldList; 
    }

    RT_Time get_time() {return xtime;}

    void addCB( RT_Callback *fun) { 
	cbList.append( fun); fun->setList( &cbList ); 
    }
    // add a C++ callback to the list

    void removeCB( RT_Callback *fun) { cbList.remove( fun ); }
    // remove a C++ callback from list

    //#### the Tcl commands:
    int objectCMD(char *[]);

    //#### further public stuff:

    int addTclCB(char*);
    // add a tcl callback to the list
    // returns TRUE if successful else FALSE
    // (if there is already a cb with this name)

    int removeTclCB(char *);
    // remove a tcl callback 
    // returns TRUE if successful else FALSE
    // (if there is not a cb with this name) 
    int isA(const char *c) const { return RT_Object::isA( c ) || RTM_isA( RTN_INPUT_DEVICE, c ); }

    virtual void event( RT_Event* = 0 ) = 0;
    // the  abstract event method for the input devices

    void print(FILE *) const;

    void objectKilled(RT_Object *);
};

#endif



