#ifndef __CALLBACK__H__
#define __CALLBACK__H__

////////////////////////////////////////////////////////////////////////////////
//  A generic callback class.                                                 //  
//  LAST EDIT: Fri Aug  5 09:23:10 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../rlist.h"
#include "../strings.h"
#include "../error.h"

class RT_InputDevice;

extern const char *RTN_CALLBACK;

class RT_Callback: public RT_GeneralListEntry {
  protected:
    RT_GeneralList *list;
    // this is a pointer to the list in which the callback is contained
    // need this to allow a callback to remove itself 
    RT_Callback() { list = 0; }
  public:
    virtual char *getName() { return 0; }
    //  when it is a Tcl callback then return the Tcl procedure name, else 0
    void printProc(FILE *f) {
	//  write proc body to stream:
	if (!getName()) return; // its a C++ callback!

	fprintf( f, "proc %s {", getName() );
	if (Tcl_VarEval( rt_Ip, "info args ", getName(), 0 ) == TCL_OK )
	    fputs( rt_Ip->result, f );
	else fputs( "<error>", f );

	fprintf( f, "} {" );
	if (Tcl_VarEval( rt_Ip, "info body ", getName(), 0 ) == TCL_OK )
	    fputs( rt_Ip->result, f );
	else fputs( "<error>", f );

	// reset eventually results:
	Tcl_SetResult( rt_Ip, "", TCL_VOLATILE );
	fprintf( f, "}\n" );
    }
    virtual void exec(RT_InputDevice*) = 0;
    void print(FILE* f) const { fprintf( f, "Callback\n" ); }
    // return the name of the Tcl-procedure that should be called
    // this is only useful in Tcl-callbacks!
    void setList(RT_GeneralList *_list) { list = _list; }

    int isA(const char *_c) const { return RTM_isA( _c, RTN_CALLBACK ); }
};

class RT_TclCallback: public RT_Callback {
    char *name;
  public:
    RT_TclCallback(char *_name) { 
	name = new char[strlen(_name) + 1];
	strcpy( name, _name );
    }
    ~RT_TclCallback() { delete name; }
    virtual void exec(RT_InputDevice *);
    // implementation in device.C
    
    char *getName() { return name; }
};

class RT_FindTclCallbackFunctoid: public RT_GeneralListFunctoid {
    RT_String proc;
    RT_Callback *cb;
  public:
    RT_FindTclCallbackFunctoid( char *_proc) { cb = 0; proc = _proc; }
    virtual void exec(RT_GeneralListEntry *e, void*) {
 	if (e->isA( RTN_CALLBACK )) {
	    char *tmp = ((RT_Callback*)e)->getName();
	    if (tmp && !(strcmp( (char*)proc, tmp ))) cb = (RT_Callback*)e;
	}
    }
    RT_Callback *get() { return cb; }
};

// a predefined callback for stdin/stdout:

class RT_ConsoleInputCB: public RT_Callback {
    RT_String cmd;
    int flag; // 1 if cmd is empty
    void exec(RT_InputDevice*) { evalCmd(); }
  protected:
    int evalCmd();
    // return value may be used in sub classes
    // to see if there was a CMD evaluated.
    // implementation in device.C

    char *getCmd() { return (char*)cmd; }
  public:
    RT_ConsoleInputCB(): cmd( 1000 ), flag(1) { 
	fprintf( stdout, "-> " ); fflush( stdout ); 
    }
};

#endif

