////////////////////////////////////////////////////////////////////////////////
//  Implementation of the identity generator class                            //  
//  LAST EDIT: Fri Aug  5 08:55:12 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "ident.h"
#include "assert.h"

RT_IdentGenerator::RT_IdentGenerator(int maxsize) {
    pos = 0;
    size = sizeof( long );
    int tmp = size;
    ldsize = 3;
    while ( tmp = tmp >> 1 ) ldsize++;
    size *= 8;
    length = ( maxsize >> ldsize ) + 1;
    array = new long[ length ];
    for (int i = 0; i < length; i++) array[ i ] = 0;
}

int RT_IdentGenerator::getId() {
    int full = 0;
    long value;
    while ( 1 ) {
	if ( (value = array[pos]) != -1 ) {
	    long mask = 1;
	    for ( int i = 0; i < size; i++) {
		if ( !(value & mask )) {
		    array[ pos ] = value | mask;
		    return ( pos << ldsize ) + i;
		}
		mask = mask << 1;
	    }
	}
	else if ( ++pos == length ) {
	    pos = 0;
	    assert( !full );
	    full = 1;
	}
    }
}

void RT_IdentGenerator::freeId(int id) {
    pos = id >> ldsize;
    id = id % size;
    long mask = 1;
    for (int i = 0; i < id; i++) mask = mask << 1;
    array[ pos ] = array[ pos ] & ( - 1 - mask);
}



