#ifndef __USEFUL_LIGHT_H__
#define __USEFUL_LIGHT_H__

////////////////////////////////////////////////////////////////////////////////
//  Two simple light sources: Ambient and point light.                        //  
//  LAST EDIT: Fri Aug  5 08:54:57 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifdef RTD_RSY
#include "rsy/rsyscene.h"
#endif

#include "light.h"

extern const char *RTN_POINT_LIGHT;
extern const char *RTSN_PL;

class RT_PointLight: public RT_Light {
  public:
    //#### the Tcl/C++ methods:
    RT_PointLight(char *_name): RT_Light( _name) {}
    const char *get_description() const { return "A point light source."; }
    const char *get_class() const { return RTN_POINT_LIGHT; }
    int isA(const char *c) const { return RT_Light::isA( c ) || RTM_isA( c, RTN_POINT_LIGHT ); }

    //#### shader interface:
    void render();

    //#### ray-tracer interface:
    RT_Color shade( const RT_Vector &, const RT_Vector &, const RT_Vector &, const RT_Surface &, const RT_Camera *);

#ifdef RTD_RSY
    //#### radiosity interface:
    //Note:
    // A point light is a hard task for a radiosity method.
    // You should use a light emitting (extended) surface instead.
    void toRSY(RT_RSYScene* rsc);
#endif

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

extern const char *RTN_AMBIENT_LIGHT;
extern const char *RTSN_AL;

class RT_AmbientLight: public RT_Light {
  public:
    //#### the Tcl/C++ methods:
    RT_AmbientLight(char *_name):RT_Light( _name) {}
    const char *get_description() const { return "An ambient light source."; }
    const char *get_class() const { return RTN_AMBIENT_LIGHT; }
    int isA(const char *c) const { return RT_Light::isA( c ) || RTM_isA( c, RTN_AMBIENT_LIGHT ); }

    //#### ray-tracer interface:
    RT_Color shade( const RT_Vector &, const RT_Vector &, const RT_Vector &, const RT_Surface &, const RT_Camera *);

    //#### shader interface:
    void render();

#ifdef RTD_RSY
    //#### radiosity interface:
    void toRSY(RT_RSYScene *) {}
#endif

    //#### the Tcl-commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

#endif
