////////////////////////////////////////////////////////////////////////////////
//  Class for recording animations using image recording.                     //  
//  LAST EDIT: Fri Aug  5 08:55:02 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "recorder.h"
#include "lookat.h"

const char *RTN_IMAGE_RECORDER = "ImageRecorder";

/////// class Recorder:

int RT_Recorder::cmG, RT_Recorder::cmF, RT_Recorder::stF, RT_Recorder::nxF;
char *RT_Recorder::cmV;

RT_ParseEntry RT_Recorder::table[] = {
    { "-start", RTP_NONE, 0, &stF, "Start the animation by resetting the values and performing the first step.", RTPS_NONE },
    { "-next", RTP_NONE, 0, &nxF, "Steo to the next keyframe.", RTPS_NONE },
    { "-camera", RTP_STRING, (char*)&cmV, &cmF, "Set the {ARG 1 Camera} for the recorder object.", "Object" },
    { "-get_camera", RTP_NONE, 0, &cmG, "Return the related camera", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_Recorder::objectCMD(char *argv[]) { 
    int ret = 0;
    RT_parseTable( argv, table );
    if (stF) start();
    if (nxF) next();
    if (cmF) {
	RT_Object *obj = RT_Object::getObject( cmV );
	if (!obj) Tcl_AppendResult(rt_Ip, "No such object: ", cmV, "! ", NULL );
	else if (!(obj->isA( RTN_CAMERA ))) Tcl_AppendResult(rt_Ip, "Object ", cmV, " isn't a camera! ", NULL );
	else { camera( (RT_Camera*)obj ); ret++;}
    }
    if (cmG) RT_Object::result( get_camera() ?  get_camera()->get_name() : "" );
    return ret + stF + nxF + cmG;
}

void RT_Recorder::camera(RT_Camera *cam) { 
    if (xcam) {
	if (long(cam) == -1) cam = 0;
	else xcam->removeRelatedObject( this );
    }
    xcam = cam; 
    if (xcam) {
	xcam->addRelatedObject( this );
	addRelatedObject( xcam );
    }
}

/////// class ImageRecorder:

int RT_ImageRecorder::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String String} {Creates an image {ARG 1 Recorder}. The second argument specifies a filename {ARG 2 Template} but without extension.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if ( argc != 3 ) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <filetemplate>! ", NULL );
	    return TCL_ERROR;
	}
	new RT_ImageRecorder( argv[1], argv[2] ); 
	RTM_classReturn;
    }
    return res; 
}

int RT_ImageRecorder::imG, RT_ImageRecorder::imF;
char *RT_ImageRecorder::imV;

RT_ParseEntry RT_ImageRecorder::table[] = {
    { "-image", RTP_STRING, (char*)&imV, &imF, "Set the {ARG 1 Image} for the recorder object. The image cannot be internally handled, because the type of the image like RGB, Tiff, etc. should be open.", "Object" },
    { "-get_image", RTP_NONE, 0, &imG, "Return the current image", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_ImageRecorder::objectCMD(char *argv[]) { 
    int ret = RT_Recorder::objectCMD( argv );
    RT_parseTable( argv, table );
    if (imF) {
	RT_Object *obj = RT_Object::getObject( imV );
	if (!obj || !(obj->isA( RTN_IMAGE)) ) 
	    rt_Output->errorVar( get_name(), ": No such pixmap object: ", imV, "!", 0 );
	else { image( (RT_Image*)obj ); ret++;}
    }
    if (imG) RT_Object::result( get_image() ?  get_image()->get_name() : "" );
    return ret + imG;
}

void RT_ImageRecorder::next() {
    RT_Recorder::next();
    RT_Camera *cam = get_camera();
    if (!cam) return; 
    if (cam->isA( RTN_RAY_IMAGE_LOOKAT_CAMERA )) {
	RT_RayImageLookatCamera *camr = (RT_RayImageLookatCamera*)cam;
	if (!camr->get_image()) return;
	RT_String tmp(100);
	tmp = fname;
	char tmpno[10];
	sprintf( tmpno, "%04d", no );
	tmp += tmpno; tmp += '.'; tmp += camr->get_image()->get_extension();	
	camr->get_image()->filename( (char*)tmp );
    } 
    else {
	if (!get_image()) return;
	if (!get_camera()->get_pixmap()) return;
	RT_String tmp(100);
	tmp = fname;
	char tmpno[10];
	sprintf( tmpno, "%04d", no );
	tmp += tmpno; tmp += '.'; tmp+= get_image()->get_extension();	
	get_image()->filename( (char*)tmp );
	get_image()->readPixmap( get_camera()->get_pixmap() );
	get_image()->write();
    }
}

void RT_ImageRecorder::image(RT_Image *im) { 
    if (ximage) {
	if (long(im) == -1) im = 0;
	else ximage->removeRelatedObject( this );
    }
    ximage = im; 
    if (ximage) {
	ximage->addRelatedObject( this );
	addRelatedObject( ximage );
    }
}

