################################################################################
##  The popup procedure from xf.                                              ##  
##  LAST EDIT: Thu Aug  4 13:43:21 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

proc MenuPopupHandle { xfMenu xfW xfX xfY} {
    if {[winfo ismapped $xfMenu]} {
	set xfPopMinX [winfo rootx $xfMenu]
	set xfPopMaxX [expr "$xfPopMinX + [winfo width $xfMenu]"]
	if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
	    $xfMenu activate @[expr "$xfY - [winfo rooty $xfMenu]"]
	} {
	    $xfMenu activate none
	}
    }
}
    
# create the bindings for a popup menu on a canvas widget
# menu: the menu widget
# prefix_action: the action before the menu is posted
# postfix_action: the action after the menu is unposted
# type: the type of the canvas element: text,bitmap ,...

proc popup_to_canvas {canvas type menu 
{prefix_action ""} {postfix_action ""} } {
    $canvas bind $type <ButtonPress-3>   "eval \"$prefix_action\" ;\
	    $menu post %X %Y"
    $canvas bind $type <Button3-Motion>  "MenuPopupHandle $menu $canvas %X %Y "
    $canvas bind $type <ButtonRelease-3> "$menu unpost; \
	    eval \"$postfix_action\"\
	    $menu invoke active"
}

# make the bindings for a cascade menu of a popup menu
proc popup_cascademenu_bindings {widget menu} {
    bind $widget <Button3-Motion>  "MenuPopupHandle $menu $widget %X %Y "
    bind $widget <ButtonRelease-3> "$menu unpost; \
	    $menu invoke active"
    
}

