################################################################################
##  A camera with a pixmap and some decorations around.                       ##  
##  LAST EDIT: Thu Feb  9 19:11:48 1995 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

proc TKCamera {path name } {
    # path :  The TK-path of the new pixmap.
    # name :  The name of the camera object.

    # define the global variable for the class TKCamera
    global TKCamera FramedPixmap

    # generate a pixmap with dekoration
    set TKCamera($name,FramedPixmap) [FramedPixmap  $path $name 300 300]
    set TKCamera($name,Tk_Pixmap) $FramedPixmap($path.$name,Tk_Pixmap)

    # Set default values for some variables
    # of the TKCamera
    set TKCamera($name,Distance) 10

    set TKCamera($name,Center,x) 0
    set TKCamera($name,Center,y) 0 
    set TKCamera($name,Center,z) 0
    
    set TKCamera($name,Viewpoint,x) 0
    set TKCamera($name,Viewpoint,y) 0
    set TKCamera($name,Viewpoint,z) 10
    
    set TKCamera($name,Direction,x) 0
    set TKCamera($name,Direction,y) 0
    set TKCamera($name,Direction,z) -10
    
    # generate the camera and set the default values
#    LookatCamera $name "0 0 $TKCamera($name,Distance)" {0 0 0} 
    $name -background {0.000000 0.000000 0.000000} -pixmap $TKCamera($name,Tk_Pixmap)

    # make some bindings to the pixmap
    BindPixmap $TKCamera($name,FramedPixmap) "TKCamera.$name.UpdateCallback"
    
    #declare the update callback for the camera
    proc TKCamera.$name.UpdateCallback  {} {cam1 -rendering}
    
    # update the tk-system
    update
    
    # Define the event proc to handel the scale requests from pixmap

    proc $TKCamera($name,FramedPixmap).DesktopEventHandler { pixmap event args } {
	global FramedPixmap TKCamera
	# get the path of the Tk_Pixmap and send the method get_camera
	set camera [$FramedPixmap($pixmap,Tk_Pixmap) -get_camera]
	
	# clean the returnvalue of get_camera
	regsub -all " " $camera "" camera
	
	if [string length $camera] {
	    set distance $TKCamera($camera,Distance) 
	    case $event in {
		{Scale,Left1 Scale,Bottom2} { 
		    # Chance the refpoint 
		    # get the values of the scales
		    set xvalue [$FramedPixmap($pixmap,Scale,Left1,Path)  get]
		    set yvalue [$FramedPixmap($pixmap,Scale,Bottom2,Path) get]
		    
		    # transform the values from -100,100 to -3.14,3.14
		    set xangle [expr $xvalue*-0.00157]
		    set yangle [expr $yvalue*0.00314]
		    # Calculate the point witch is on position 0 0 distance
		    # and rotates around the xangle and yangle.
		    set TKCamera($camera,Viewpoint,y) [expr $distance*[sin $xangle]]
		    set rad                           [expr $distance*[cos $xangle]]
		    set TKCamera($camera,Viewpoint,x) [expr $rad*[sin $yangle]]
		    set TKCamera($camera,Viewpoint,z) [expr $rad*[cos $yangle]]
		    
		    # refresh the direction and the redraw
		    $FramedPixmap($pixmap,Scale,Left2,Path) set \
			    [expr -1*$xvalue]
		    $FramedPixmap($pixmap,Scale,Bottom1,Path) set \
			    [expr -1*$yvalue]
		}
		{Scale,Left2 Scale,Bottom1} { 
		    
		    # get the values of the scales:
		    set xangle [$FramedPixmap($pixmap,Scale,Left2,Path) get]
		    set yangle [$FramedPixmap($pixmap,Scale,Bottom1,Path) get]
		    
		    # transform the values from -100,100:
		    set xangle [expr $xangle*0.00157]
		    set yangle [expr $yangle*-0.00314]

		    # Calculate the point witch is on position 0 0 distance
		    # and rotates around the xangle and yangle:
		    set TKCamera($camera,Direction,y) [expr -$distance*[sin $xangle] ]
		    set rad                           [expr -$distance*[cos $xangle] ]
		    set TKCamera($camera,Direction,x) [expr  $rad*[sin $yangle]      ]
		    set TKCamera($camera,Direction,z) [expr  $rad*[cos $yangle]      ]
		    
		    # set the point to the camera
		    $camera -viewpoint "\
			    [expr "$TKCamera($camera,Center,x)\
			    +$TKCamera($camera,Viewpoint,x)"]\
			    [expr "$TKCamera($camera,Center,y)\
			    +$TKCamera($camera,Viewpoint,y)"]\
			    [expr "$TKCamera($camera,Center,z)\
			    +$TKCamera($camera,Viewpoint,z)"]"
		    # set the point to the camera
		    $camera -refpoint "\
			    [expr "$TKCamera($camera,Center,x)\
			    +$TKCamera($camera,Viewpoint,x)
		    +$TKCamera($camera,Direction,x)"]\
			    [expr "$TKCamera($camera,Center,y)\
			    +$TKCamera($camera,Viewpoint,y)
		    +$TKCamera($camera,Direction,y)"]\
			    [expr "$TKCamera($camera,Center,z)\
			    +$TKCamera($camera,Viewpoint,z)
		    +$TKCamera($camera,Direction,z)"]"
		    $camera -rendering
		}
		{Scale,Top Scale,Right} { 
		    
		    # get the values of the scales:
		    set xpos [$FramedPixmap($pixmap,Scale,Top,Path) get]
		    set ypos [$FramedPixmap($pixmap,Scale,Right,Path) get]
		    
		    # transform the values from -100,100:
		    set TKCamera($camera,Center,x) [expr $xpos*0.01]
		    set TKCamera($camera,Center,y) [expr $ypos*0.01]
		    
		    # set the point to the camera
		    $camera -viewpoint "\
			    [expr "$TKCamera($camera,Center,x)\
			    +$TKCamera($camera,Viewpoint,x)"]\
			    [expr "$TKCamera($camera,Center,y)\
			    +$TKCamera($camera,Viewpoint,y)"]\
			    [expr "$TKCamera($camera,Center,z)\
			    +$TKCamera($camera,Viewpoint,z)"]"
		    # set the point to the camera
		    $camera -refpoint "\
			    [expr "$TKCamera($camera,Center,x)\
			    +$TKCamera($camera,Viewpoint,x)
		    +$TKCamera($camera,Direction,x)"]\
			    [expr "$TKCamera($camera,Center,y)\
			    +$TKCamera($camera,Viewpoint,y)
		    +$TKCamera($camera,Direction,y)"]\
			    [expr "$TKCamera($camera,Center,z)\
			    +$TKCamera($camera,Viewpoint,z)
		    +$TKCamera($camera,Direction,z)"]"
		    $camera -rendering
		}
		{Scale,ANGLE} { 
		    
		    # get the values of the scales:
		    set angle [$FramedPixmap($pixmap,Scale,ANGLE,Path) get]
		    		
		    # transform the value from -100,100:
		    set angle [expr ($angle+1000)*0.085+1]
		    
		    # set the angle to the camera
		    $camera -angle $angle
		    $camera -rendering
		}
		{Scale,TWIST} { 
		    
		    # get the values of the scales:
		    set twist [$FramedPixmap($pixmap,Scale,TWIST,Path) get]
		    		
		    # transform the value from -100,100:
		    set twist [expr ($twist)*0.18]
		    
		    # set the twist to the camera
		    $camera -twist $twist
		    $camera -rendering
		}
		{Scale,NEAR} { 
		    # get the values of the scales:
		    set near [$FramedPixmap($pixmap,Scale,NEAR,Path) get]
		    # transform the value from -100,100:
		    set near [expr ($near+1000)*0.018+0.1]
		    # set the near to the camera
		    $camera -znear $near
		    $camera -rendering
		}
		{Scale,FAR} { 
		    # get the values of the scales:
		    set far [$FramedPixmap($pixmap,Scale,FAR,Path) get]
		    # transform the value from -100,100:
		    set far [expr ($far+1000)*0.018+0.1]
		    # set the far to the camera
		    $camera -zfar $far
		    $camera -rendering
		}
	    }
	}
    }
}

