################################################################################
##  A dialog box for rtsh-like Tcl input.                                     ##  
##  LAST EDIT: Thu Aug  4 10:58:02 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1993 - 1995 YART team                                        ##
################################################################################
	
IOM_TopBox ?
	
Tcl_Object IOM_ShellBox IOM_TopBox {executing} {Name} {String} \
	{Creates a new Shell editor box called {ARG 1 Name}.} \
	{
    wm title [set $THIS->tkTop] "IOM.shell"
    set path [set $THIS->frCenter]

    # Create text window and scrollbar, and set up bindings for text
    # window to foward commands to the interpreter.

    text $path.t -relief raised -bd 2 -yscrollcommand " $path.s set" -setgrid true
    scrollbar $path.s -relief flat -command "$path.t yview"
    pack append  $path  $path.s {right fill} $path.t {expand fill left}

    bind $path.t <1> {
	set tk_priv(selectMode) char
	%W mark set anchor @%x,%y
	if {[lindex [%W config -state] 4] == "normal"} {focus %W}
    }
    bind $path.t <Double-1> {
	set tk_priv(selectMode) word
	tk_textSelectTo %W @%x,%y
    }
    bind $path.t <Triple-1> {
	set tk_priv(selectMode) line
	tk_textSelectTo %W @%x,%y
    }
    bind $path.t <Control-u> {
	%W delete "insert linestart +  3 chars" "insert lineend"
	%W yview -pickplace insert
    }
    bind $path.t <Return> "%W insert insert \\n ; $THIS -invoke"
    bind $path.t <BackSpace> "$THIS -backspace"
    bind $path.t <Delete> "$THIS -backspace"
    bind $path.t <Control-h> "$THIS -backspace"
    bind $path.t <Control-v> "\
	    %W insert insert \[selection get\];\
	    %W yview -pickplace insert;\
	    if \[string match *.0 \[%W index insert\]\] {\
	    $THIS -invoke\
	} ;"
    
    bind $path.t <2> "\
	    %W insert insert \[selection get\];\
	    %W yview -pickplace insert;\
	    if \[string match *.0 \[%W index insert\]\] {\
	    $THIS -invoke\
	} ;"
    
    $path.t tag configure bold -font *-Courier-Bold-R-Normal-*-120-*
    set $THIS->executing 0
    
    $THIS -prompt
    focus $path.t
    $path.t mark set cmdStart "insert-1c"

    set path [set $THIS->frBottom]
    button $path.attrClear -text "Clear" -command  "$THIS -clear"
    button $path.update -text "Close" -command  "delete $THIS"
    pack append $path \
	$path.attrClear {fill expand left}\
	$path.update {fill expand left}
}

Tcl_Method IOM_ShellBox -prompt {} {} {The method is used to print out a prompt at the insertion point .} {
    set path [set $THIS->frCenter]

    $path.t insert "insert linestart" "-> "
    $path.t tag add bold "insert linestart" \
	    "insert linestart + 3 chars"
}

Tcl_Method IOM_ShellBox -invoke {} {} {The method executes a command. It takes everything on the current line after the prompt and sends it to the interpreter.} {
    set path [set $THIS->frCenter]

    set cmd [$path.t get cmdStart+1c insert]
    incr $THIS->executing 1
    if [info complete $cmd] {
	# "overload" exit:
	if [regexp {^ *exit *} $cmd] {
	    delete $THIS 
	    return
	}

	set result [catch [list uplevel #0 $cmd] msg]
	
	if {$result != 0} {
	    $path.t insert insert "Error: $msg\n"
	} else {
	    if {$msg != ""} {
		$path.t insert insert $msg\n
	    }
	}
	$THIS -prompt
	$path.t mark set cmdStart insert-1c
    }
    incr $THIS->executing -1
    $path.t yview -pickplace insert
}

Tcl_Method IOM_ShellBox -backspace {} {} {The method handles backspaces, being careful not to backspace over the prompt.} {
    set path [set $THIS->frCenter]
    scan [$path.t index insert] %*d.%d char
    if {$char > 3} {
	$path.t delete insert-1c insert
	$path.t yview -pickplace insert
    }
}

Tcl_Method IOM_ShellBox -clear {} {} {Clear the text widget.} {
    set path [set $THIS->frCenter]
    $path.t delete 0.0 end
    set $THIS->executing 0
    $THIS -prompt
    $path.t mark set cmdStart "insert-1c"
}

IOM_ShellBox -description {The text dialog to enter Tcl commands.}

IOM_ShellBox -keywords {IOM Userinterface Shell}

