/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *    Please See COPYRIGHT notice.                                  *
 *                                                                  *
/*   This  is  the  default terminal description file. It is used if  */
/*   we cannot find a tty-$BTERM.m file to load.		      */
/**********************************************************************/

# include	"tty.h"

void
main()
{

	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		'+',		/* Top left of window.			    */
		'+',		/* Top right of window.			    */
		'+',		/* Bottom left of window.		    */
		'+',		/* Bottom right of window.		    */
		'|',		/* Vertical bar for window sides.	    */
		'-',		/* Top and bottom horizontal bar for window.*/
		'+', 		/* Top join.				    */
		'+', 		/* Bottom join.				    */
		'+', 		/* Window 4-way intersection.		    */
		'+', 		/* Left hand join.			    */
		'+' 		/* Right hand join.			    */
		);

	/***********************************************/
	/*   Define   escape   sequences   used   for  */
	/*   special optimisations on output.	       */
	/***********************************************/
	set_term_features(
		NULL,		/* Sequence to clear 'n' spaces.	    */
		NULL,		/* Sequence to print characters with top    */
		     		/* bit set.				    */
		NULL,		/* Insert-mode cursor.			    */
		NULL,		/* Overwrite-mode cursor.		    */
		NULL,		/* Insert-mode cursor (on virtual space).   */
		NULL,		/* Overwrite-mode cursor (on virtual space).*/
		NULL,		/* Print ESCAPE character graphically.	    */
		NULL,		/* Escape sequence to repeat last character.*/
		FALSE,		/* ESC [0m resets color.		    */
		FALSE		/* Terminal does not supports color.	    */
		);

	/***********************************************/
	/*   Define  keyboard  layout  for  non-ascii  */
	/*   characters.  These  can only be used for  */
	/*   the console).			       */
	/***********************************************/
	set_term_keyboard(
		F1_F12, quote_list(
			"\x1BOP", "\x1BOQ", "\x1BOR", "\x1BOS", "\x1BOT",
			"\x1BOU", "\x1BOV", "\x1BOW", "\x1BOX", "\x1BOY", 
			"\x1BOZ", "\x1BO[" ),

		SHIFT_F1_F12, quote_list(
			"\x1BOp", "\x1BOq", "\x1BOr", "\x1BOs", "\x1BOt",
			"\x1BOu", "\x1BOv", "\x1BOw", "\x1BOx", "\x1BOy", 
			"\x1BOz", "\x1BO{" ),
		CTRL_F1_F12, quote_list(
			"\x1BO\x10", "\x1BO\x11", "\x1BO\x12", "\x1BO\x13", 
			"\x1BO\x14", "\x1BO\x15", "\x1BO\x16", "\x1BO\x17", 
			"\x1BO\x18", "\x1BO\x19", "\x1BO\x1a", "\x1BO\x1B" ),


		/***********************************************/
		/*   We   map   the   useful   ALT-keys  into  */
		/*   CTRL-key equivalents,		       */
		/***********************************************/
		ALT_A_Z, quote_list(
			"\x01", "\x02", "\x03", "\x04", "\x05", /* ALT-A..E */
			"\x06", "\x07", NULL,   "\x09", "\x0a", /* ALT-F..J */
			"\x0b", "\x0c", NULL,   "\x0e", "\x0f", /* ALT-K..O */
			"\x10", "\x11", "\x12", "\x13", "\x14", /* ALT-P..T */
			"\x15", NULL,   "\x17", "\x18", "\x19", /* ALT-U..Y */
			"\x1a"),
		KEYPAD_0_9, quote_list(
			"\x1B[@", "\x1B[Y", "\x1B[B", "\x1B[U", "\x1B[D",
			"\x1B[G", "\x1B[C", "\x1B[H", "\x1B[A", "\x1B[V"),
		CTRL_KEYPAD_0_9, quote_list(
			"\x1B?0", "\x1B?1", "\x1B?2", "\x1B?3", "\x1B?4",
			"\x1B?5", "\x1B?6", "\x1B?7", "\x1B?8", "\x1B?9"),
		ALT_0_9, quote_list(
			"\x1BN0", "\x1BN1", "\x1BN2", "\x1BN3", "\x1BN4",
			"\x1BN5", "\x1BN6", "\x1BN7", "\x1BN8", "\x1BN9"),
		CUT,	"\x1B[S",
		COPY,	"\x1B[T",
		BACK_TAB, "\x1B[Z"
		);
	
	/***********************************************/
	/*   Following  are  useful  ways  to  access  */
	/*   the  BRIEF  default  CTRL-keys.  We cant  */
	/*   do  these  direct because we substituted  */
	/*   the ALT-keys above).		       */
	/***********************************************/
	assign_to_key("^V^B", "set_bottom_of_window");
	assign_to_key("^V^C", "set_center_of_window");
	assign_to_key("^V^D", "page_down");
	assign_to_key("^V^G", "objects routines");
	assign_to_key("^V^H", "help");
	assign_to_key("^V^J", "goto_bookmark");
	assign_to_key("^V^K", "objects delete_word_left");
	assign_to_key("^V^L", "objects delete_word_right");
	assign_to_key("^V^N", "next_error");
	assign_to_key("^V^P", "next_error 1");
	assign_to_key("^V^R", "repeat");
	assign_to_key("^V^T", "set_top_of_window");
	assign_to_key("^V^U", "page_up");
	assign_to_key("^V^V", "version");
	assign_to_key("^V^W", "set_backup");
}
