/*-------------------------------------------------------------------------
 *
 * lsyscache.h--
 *    
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * lsyscache.h,v 1.4 1995/02/12 02:56:25 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef	LSYSCACHE_H
#define	LSYSCACHE_H

#include "access/htup.h"

extern bool op_class(Oid opid, int32 opclass);
extern Name get_attname(Oid relid, AttrNumber attnum);
extern AttrNumber get_attnum(Oid relid, Name attname);
extern Oid get_atttype(Oid relid, AttrNumber attnum);
extern bool get_attisset(Oid relid, Name attname);
extern RegProcedure get_opcode(Oid opid);
extern NameData get_opname(Oid opid);
extern bool op_mergesortable(Oid opid, Oid ltype, Oid rtype,
			     Oid *leftOp, Oid *rightOp);
extern Oid op_hashjoinable(Oid opid, Oid ltype, Oid rtype);
extern Oid get_commutator(Oid opid);
extern HeapTuple get_operator_tuple(Oid opno);
extern Oid get_negator(Oid opid);
extern RegProcedure get_oprrest(Oid opid);
extern RegProcedure get_oprjoin(Oid opid);
extern int get_relnatts(Oid relid);
extern Name get_rel_name(Oid relid);
extern struct varlena * get_relstub(Oid relid, int no, bool *islast);
extern Oid get_ruleid(Name rulename);
extern Oid get_eventrelid(Oid ruleid);
extern int16 get_typlen(Oid typid);
extern char get_typalign(Oid typid);
extern bool get_typbyval(Oid typid);
extern struct varlena *get_typdefault(Oid typid);
extern char get_typtype(Oid typid);

#endif	/* LSYSCACHE_H */

