/*-------------------------------------------------------------------------
 *
 * oidchar16.c--
 *    adt for multiple key indices involving oid and char16.  Used for cache
 *    index scans (could also be used in the general case with char16).
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/backend/utils/adt/oidchar16.c,v 1.4 1995/02/13 19:48:05 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#include <stdio.h>
#include <string.h>

#include "postgres.h"
#include "utils/oidcompos.h"	/* where function declarations go */
#include "utils/builtins.h"	/* for pg_atoi() */
#include "utils/elog.h"
#include "utils/palloc.h"

OidChar16
oidchar16in(char *inStr)
{
    OidChar16 oc;
    char *inptr;
    
    oc = (OidChar16) palloc(sizeof(OidChar16Data));
    
    memset(oc, 0, sizeof(OidChar16Data)); 
    for (inptr = inStr; *inptr && *inptr != ','; inptr++)
	;
    
    if (*inptr) {
	oc->id = (Oid) pg_atoi(inStr, sizeof(Oid), ',');
	(void) strncpy(oc->name.data, ++inptr, sizeof(char16));
    }else
	elog(WARN, "Bad input data for type oidchar16");
    
    return oc;
}

char *
oidchar16out(OidChar16 oidname)
{
    /*
     * 4294967295,char16identifier
     * 0        1         2
     * 1234567890123456789012345678
     */
    char buf[28];
    
    sprintf(buf, "%d,%.*s", oidname->id, sizeof(char16), oidname->name.data);
    return(strcpy((char*)palloc(strlen(buf) + 1), buf));
}

bool
oidchar16lt(OidChar16 o1, OidChar16 o2)
{
    return (bool)
	(o1->id < o2->id ||
	 (o1->id == o2->id && strncmp(&o1->name.data[0],
				      &o2->name.data[0],
				      sizeof(char16)) < 0));
}

bool
oidchar16le(OidChar16 o1, OidChar16 o2)
{
    return (bool)
	(o1->id < o2->id ||
    	 (o1->id == o2->id && strncmp(&o1->name.data[0],
				      &o2->name.data[0],
				      sizeof(char16)) <= 0));
}

bool
oidchar16eq(OidChar16 o1, OidChar16 o2)
{
    return (bool)
	(o1->id == o2->id &&
    	 (strncmp(&o1->name.data[0], &o2->name.data[0], sizeof(char16)) == 0));
}

bool
oidchar16ne(OidChar16 o1, OidChar16 o2)
{
    return (bool)
	(o1->id != o2->id ||
    	 (strncmp(&o1->name.data[0], &o2->name.data[0], sizeof(char16)) != 0));
}

bool
oidchar16ge(OidChar16 o1, OidChar16 o2)
{
    return (bool) (o1->id > o2->id || (o1->id == o2->id && 
				       strncmp(&o1->name.data[0],
					       &o2->name.data[0],
					       sizeof(char16)) >= 0));
}

bool
oidchar16gt(OidChar16 o1, OidChar16 o2)
{
    return (bool) (o1->id > o2->id ||  (o1->id == o2->id && 
					strncmp(&o1->name.data[0],
						&o2->name.data[0],
						sizeof(char16)) > 0));
}

int
oidchar16cmp(OidChar16 o1, OidChar16 o2)
{
    if (o1->id == o2->id)
    	return (strncmp(&o1->name.data[0], &o2->name.data[0], sizeof(char16)));
    
    return (o1->id < o2->id) ? -1 : 1;
}

OidChar16
mkoidchar16(Oid id, char *name)
{
    OidChar16 oidchar16;
    
    oidchar16 = (OidChar16) palloc(sizeof(Oid)+sizeof(char16));
    
    oidchar16->id = id;
    (void) strncpy(oidchar16->name.data, name, sizeof(char16));
    return oidchar16;
}
