/*-------------------------------------------------------------------------
 *
 * rusagestub.h--
 *    Stubs for getrusage(3).
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * rusagestub.h,v 1.1 1995/05/05 18:33:08 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef RUSAGESTUB_H
#define RUSAGESTUB_H

#include <sys/time.h>	/* for struct timeval */
#include <limits.h>	/* for CLK_TCK */

#define	RUSAGE_SELF	0
#define	RUSAGE_CHILDREN	-1

struct rusage {
    struct timeval ru_utime;		/* user time used */
    struct timeval ru_stime;		/* system time used */
};

extern int getrusage(int who, struct rusage *rusage);

#endif /* RUSAGESTUB_H */
