

#define YYDEBUG 1
/*-------------------------------------------------------------------------
 * 
 * gram.y--
 *    POSTGRES SQL YACC rules/actions
 * 
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/backend/port/win32/gram.c,v 1.1 1995/05/05 18:33:04 andrew Exp
 *
 * HISTORY
 *    AUTHOR		DATE		MAJOR EVENT
 *    Andrew Yu		Sept, 1994	POSTQUEL to SQL conversion
 *    Andrew Yu		Oct, 1994	lispy code conversion
 *
 * NOTES
 *    CAPITALS are used to represent terminal symbols.
 *    non-capitals are used to represent non-terminals.
 *
 *    if you use list, make sure the datum is a node so that the printing
 *    routines work
 *
 * WARNING
 *    sometimes we assign constants to makeStrings. Make sure we don't free
 *    those.
 *
 *-------------------------------------------------------------------------
 */
#include <string.h>
#include <ctype.h>
#include "postgres.h"
#include "nodes/parsenodes.h"
#include "parser/catalog_utils.h"
#include "utils/acl.h"
#include "catalog/pg_variable.h"	/* for Name_pg_variable */
#include "catalog/pg_log.h"		/* for Name_pg_log */
#include "catalog/pg_time.h"		/* for Name_pg_time */
#include "catalog/pg_magic.h"		/* for Name_pg_magic */
#include "utils/elog.h"


static char saved_relname[BUFSIZ];  /* need this for complex attributes */
static bool QueryIsRule = FALSE;

extern List *parsetree;

/*
 * If you need access to certain yacc-generated variables and find that 
 * they're static by default, uncomment the next line.  (this is not a
 * problem, yet.)
 */
/*#define __YYSCLASS*/

extern void yyerror(char message[]);

static Node *makeA_Expr(int op, char *opname, Node *lexpr, Node *rexpr);

typedef union  {
    double 		dval;
    int			ival;
    char		*str;
    bool		boolean;
    List		*list;
    Node		*node;
    Value		*value;

    Attr		*attr;

    ColumnDef		*coldef;
    TypeName		*typnam;
    DefElem		*defelt;
    ParamString		*param;
    SortBy		*sortby;
    IndexElem		*ielem;
    RangeVar		*range;
    RelExpr		*relexp;
    TimeRange		*trange;
    A_Indices		*aind;
    ResTarget		*target;
    ParamNo		*paramno;
	
    VersionStmt		*vstmt;
    DefineStmt		*dstmt;
    PurgeStmt		*pstmt;
    RuleStmt		*rstmt;
    AppendStmt		*astmt;
} YYSTYPE;
# define ABORT_TRANS 257
# define ACL 258
# define ADD 259
# define AFTER 260
# define AGGREGATE 261
# define ALL 262
# define ALTER 263
# define AND 264
# define APPEND 265
# define ARCHIVE 266
# define ARCH_STORE 267
# define AS 268
# define BACKWARD 269
# define BEFORE 270
# define BEGIN_TRANS 271
# define BINARY 272
# define BY 273
# define CHANGE 274
# define CLOSE 275
# define CLUSTER 276
# define COLUMN 277
# define COPY 278
# define CREATE 279
# define CREATEDB 280
# define CURRENT 281
# define CURSOR 282
# define DECLARE 283
# define DELETE 284
# define DESTROYDB 285
# define DISTINCT 286
# define DO 287
# define DROP 288
# define END_TRANS 289
# define EXTEND 290
# define FETCH 291
# define FOR 292
# define FORWARD 293
# define FROM 294
# define FUNCTION 295
# define GROUP 296
# define HAVING 297
# define HEAVY 298
# define IN 299
# define INDEX 300
# define INHERITS 301
# define INSERT 302
# define INSTEAD 303
# define INTO 304
# define ISNULL 305
# define LANGUAGE 306
# define LIGHT 307
# define LISTEN 308
# define LOAD 309
# define MERGE 310
# define MOVE 311
# define NEW 312
# define NONE 313
# define NOT 314
# define NOTHING 315
# define NOTIFY 316
# define NOTNULL 317
# define ON 318
# define OPERATOR 319
# define OR 320
# define ORDER 321
# define PNULL 322
# define PURGE 323
# define P_TYPE 324
# define RENAME 325
# define REPLACE 326
# define RETRIEVE 327
# define RETURNS 328
# define RULE 329
# define SELECT 330
# define SET 331
# define SETOF 332
# define STDIN 333
# define STDOUT 334
# define STORE 335
# define TABLE 336
# define TO 337
# define TRANSACTION 338
# define UPDATE 339
# define USING 340
# define VACUUM 341
# define VALUES 342
# define VERSION 343
# define VIEW 344
# define WHERE 345
# define WITH 346
# define EXECUTE 347
# define RECIPE 348
# define IDENT 349
# define SCONST 350
# define Op 351
# define ICONST 352
# define PARAM 353
# define FCONST 354
# define OP 355
# define UMINUS 356
# define TYPECAST 357
# define REDUCE 358
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256



static Node *makeA_Expr(int op, char *opname, Node *lexpr, Node *rexpr)
{
    A_Expr *a = makeNode(A_Expr);
    a->oper = op;
    a->opname = opname;
    a->lexpr = lexpr;
    a->rexpr = rexpr;
    return (Node *)a;
}

void parser_init(Oid *typev, int nargs)
{
    QueryIsRule = false;
    saved_relname[0]= '\0';

    param_type_init(typev, nargs);
}

void yyerror(char message[])
{
    extern char     yytext[];

    elog(WARN, "parser: %s at or near \"%s\"\n", message, yytext);
}

static yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 183,
	46, 316,
	40, 323,
	-2, 282,
-1, 238,
	351, 0,
	-2, 281,
-1, 254,
	351, 0,
	-2, 280,
-1, 263,
	46, 316,
	-2, 293,
-1, 308,
	60, 0,
	62, 0,
	-2, 271,
-1, 309,
	60, 0,
	62, 0,
	-2, 272,
-1, 311,
	351, 0,
	-2, 279,
-1, 480,
	40, 323,
	-2, 319,
-1, 489,
	46, 316,
	-2, 233,
-1, 535,
	46, 316,
	-2, 214,
	};
# define YYNPROD 342
# define YYLAST 1109
static yytabelem yyact[]={

   183,    24,   552,   534,   186,   509,   175,   460,   217,   548,
   484,   148,   488,   510,   300,   147,   391,   170,   477,   424,
   317,   187,   371,   206,   341,   390,   117,   225,   247,   245,
   561,   103,   562,   494,   133,    69,   355,   433,    87,   161,
   262,   282,   159,   102,   102,   158,   511,   274,   275,    70,
   467,   112,   430,   388,   159,   423,   114,   114,   102,   418,
   120,   102,   104,   102,   112,   323,   103,   102,   234,   231,
   296,   232,   102,   233,   102,   316,   132,    87,   132,   120,
   120,   287,    70,    92,   377,   189,   235,   237,   236,   120,
   120,   120,    70,   106,   526,    70,   218,   104,    87,    70,
   410,   129,   549,   191,   354,   203,    70,   169,   109,   108,
   107,   451,   339,   137,   135,   443,   136,    90,   138,   376,
   157,   162,    94,   102,   338,   102,   154,   120,   278,   303,
   102,   139,   141,   140,    70,   159,    70,    66,   470,   261,
   111,    91,   200,   415,   195,   384,    85,   102,   202,    58,
   485,    95,   285,   364,   181,   327,   326,   208,    88,   177,
   193,   416,   234,   231,   146,   232,    96,   233,   270,   502,
   184,   513,   178,   179,   122,   229,   546,   402,   503,    97,
   235,   237,   236,   222,   504,   220,   453,   421,   229,   413,
   301,   440,   280,   124,   258,   227,   263,   331,   414,   531,
   266,   333,   264,   118,   259,   279,   269,    81,   132,   102,
   345,   120,   320,   459,   343,   120,   120,   120,    59,    63,
   516,   120,   288,   234,   231,   454,   232,   293,   233,    72,
   119,    80,   166,   449,   271,   212,   167,    61,   180,   211,
   499,   235,   237,   236,   314,   318,   166,   445,   120,   144,
   145,    62,   226,   226,   167,    67,   219,   171,   318,   149,
   150,   151,    45,   164,   538,    58,   165,   521,   492,   342,
   473,   462,    86,   315,    60,   332,   461,   426,    71,   103,
   120,   102,   357,   246,   404,   379,   356,   273,   283,   235,
   241,   236,   159,   334,   335,   234,   159,   149,   137,   135,
   233,   136,   102,   138,   102,   565,   523,   361,   500,   369,
   104,   471,   387,   235,    65,   236,   139,   141,   140,   353,
   154,   560,   113,   515,   120,   318,   428,   441,   375,   257,
   336,   239,   324,   244,   263,   547,   563,   318,   266,   564,
   264,   385,   517,   240,   279,   120,   242,    70,   279,   142,
   507,   191,   491,   132,   356,   408,   422,    70,   368,    70,
    70,   411,   367,   214,   131,   558,   143,   347,   120,   120,
   155,   359,   397,   425,   152,   361,   318,   238,   199,   115,
   544,   149,    70,   214,   241,   291,   149,   295,   154,    70,
   406,   298,   173,   506,   405,   103,   429,   342,   194,   464,
   395,   434,   440,   396,   382,   439,   431,   383,   505,   351,
   381,   436,   352,   366,   365,   438,   363,   221,   322,   346,
    70,   442,   134,   102,   425,   239,   104,   543,   185,   224,
   508,   223,   447,   207,   450,   230,   192,   240,   301,   359,
   242,   301,   318,   456,   120,   455,   190,   120,   465,   480,
   322,   301,   102,   448,   463,   489,   458,   466,   446,   266,
   389,   490,   472,    70,   112,   182,   159,   191,   188,   479,
   496,   238,   398,   386,   268,   290,   403,   181,   497,   299,
   512,   255,   177,   495,   216,   215,   239,   302,   210,   493,
   226,   514,   348,   204,   380,   178,   179,   289,   240,   570,
    74,    83,   520,   126,     1,   427,   522,    64,   318,   120,
   372,   476,   512,   482,   226,   400,   318,   535,   489,   519,
   528,   266,   266,   536,   490,   529,   527,   358,   479,   539,
   537,   330,   238,   540,   542,   481,   532,   452,   417,   419,
    93,    98,    99,   176,   553,   512,   550,   557,   535,   321,
   554,   559,   266,   337,   536,   163,   130,    59,    63,   349,
   567,   180,   156,   160,   469,   553,   569,   568,   571,   412,
   248,   250,   251,   252,   253,   254,    61,   226,   256,   249,
   344,    89,   181,    75,   394,   498,   524,   177,   360,   556,
    62,   444,   501,   201,   545,   198,   487,   181,   420,   530,
   178,   179,   177,   281,    58,    70,   112,   153,   159,   541,
   362,   297,   260,    60,   468,   178,   179,   149,   328,   478,
   378,   370,   100,   105,   304,   305,   306,   307,   308,   309,
   310,   311,   475,   474,   312,   313,   533,   116,   340,   319,
   121,    51,   123,   267,   566,   555,   125,    32,   329,   294,
   292,   127,   286,   128,   209,    52,   409,   551,    33,    34,
    37,   525,    35,    36,    55,   401,   180,    59,    63,    56,
   277,   276,    38,    53,    39,    40,   101,   518,   457,   149,
   181,   180,   172,   228,   399,   177,    61,    68,   168,    59,
    63,   110,    42,    54,   407,    41,   272,   174,   178,   179,
    62,     9,   196,    50,   197,    49,    48,    43,    61,   205,
   234,   231,    47,   232,    58,   233,    46,    31,   103,    30,
    29,    28,    62,    60,    27,    57,   213,    26,   235,   237,
   236,    44,   392,   325,   234,   231,    58,   232,    25,   233,
    23,    22,    21,   234,   231,    60,   232,    20,   233,   104,
    19,   185,   235,   237,   236,    18,    17,    16,    15,   192,
    14,   235,   237,   236,   180,    13,    12,    11,    10,    84,
   432,     8,     7,     6,     5,   265,   435,    81,   234,   231,
   437,   232,   392,   233,     4,     3,    70,   112,   284,   159,
   191,   188,     2,     0,     0,     0,   235,   237,   236,   137,
   135,    80,   136,    77,   138,     0,     0,     0,    76,   174,
   234,   231,     0,   232,     0,   233,     0,   139,   141,   140,
     0,     0,     0,   103,     0,     0,     0,    82,   235,     0,
   236,     0,    85,   392,     0,     0,     0,    78,   103,     0,
     0,     0,     0,     0,    73,     0,   486,     0,     0,     0,
     0,     0,    79,     0,   104,     0,   185,     0,     0,     0,
   350,     0,     0,     0,   192,     0,     0,     0,     0,   104,
     0,   185,     0,     0,     0,     0,     0,     0,     0,   192,
     0,   373,     0,   374,     0,     0,     0,     0,     0,     0,
     0,    70,   112,   182,   159,   191,   188,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    70,   112,   182,   159,
   191,   188,     0,   265,     0,     0,     0,     0,     0,   393,
     0,   103,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   241,     0,     0,     0,   243,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   104,     0,   185,     0,   241,     0,     0,     0,
     0,     0,   192,     0,     0,   241,     0,     0,     0,   393,
     0,     0,     0,   239,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   240,     0,     0,   242,    70,
   112,   182,   159,   191,   188,     0,     0,   239,     0,     0,
   241,     0,   373,     0,     0,     0,   239,     0,     0,   240,
     0,     0,   242,     0,     0,     0,   174,     0,   240,   238,
   393,   242,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   483,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   239,     0,   238,     0,     0,     0,     0,     0,     0,
     0,     0,   238,   240,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   239,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   240,     0,   238,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   153 };
static yytabelem yypact[]={

   384, -1000,   384,   255, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,  -199,    -3,  -257,   -43,   508,  -257,  -178,  -121,
   -62,   -62,  -215,  -215,  -255, -1000, -1000, -1000, -1000, -1000,
 -1000,  -228,  -229,  -230,  -299,  -257,  -257,  -215,   -83,  -257,
  -215,  -130,  -215,  -101, -1000, -1000,  -215, -1000, -1000, -1000,
 -1000,  -215, -1000,  -215,  -242,    71,  -257,    71,  -257,  -257,
 -1000, -1000, -1000, -1000, -1000, -1000,  -154, -1000,  -257,  -257,
  -257,   757, -1000, -1000, -1000, -1000, -1000,  -257,  -217,  -298,
 -1000, -1000, -1000, -1000, -1000,   -24,  -257, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,   640,  -158,   -43,
 -1000,  -187,  -215, -1000,  -215,   336,  -257,  -189,   453,  -215,
 -1000,   393, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,  -161,   448,   -29,   -33,  -215, -1000,   319, -1000,
 -1000,   445,   444, -1000, -1000,  -249,  -114, -1000, -1000, -1000,
  -114,  -310, -1000, -1000,    -6,   -38,  -299,  -299, -1000, -1000,
   131, -1000, -1000,   668,   287,   192,  -329,   557,   557,   557,
   557,   557,   557, -1000,   441,   557,   283, -1000, -1000, -1000,
 -1000, -1000, -1000,  -257,   -78,    -2,   434,  -249,   -91, -1000,
 -1000,  -286, -1000, -1000,  -257,  -102, -1000,    71,  -215,  -176,
    40, -1000,  -181, -1000,  -257,  -257,  -243, -1000,   557, -1000,
  -257, -1000,  -114, -1000, -1000, -1000, -1000, -1000,  -104,   557,
  -207,   557,   557,   557,   557,   557,   557,   557,   437, -1000,
 -1000,   557,   557,  -257,    33, -1000,   557,  -267, -1000,   286,
   229,   229,   229,   692,   768,   114,   181,  -257, -1000,   -95,
   157, -1000, -1000,   192,   192,   284,   283,  -218,  -257, -1000,
   -63,   -67, -1000, -1000, -1000, -1000,   378,   323, -1000,  -267,
  -215,   368, -1000,   258,  -236,   256,   375, -1000,   319,  -165,
 -1000, -1000,   373,   319,   372,   318,   314,   701, -1000, -1000,
  -249,  -215, -1000,  -215,   253,   253,   229,   229, -1000, -1000,
   181,   768,   181,   736, -1000,   282, -1000, -1000, -1000,    26,
 -1000,   194, -1000,  -257,  -257, -1000,   369, -1000,   363,   701,
   282,  -185,  -249,  -250,   251, -1000,    11, -1000,   420,   542,
   359, -1000,   192,  -257,  -257, -1000,  -124,  -257, -1000, -1000,
   193, -1000,    71,   256,  -257,  -246, -1000, -1000, -1000, -1000,
  -257, -1000, -1000, -1000,  -141, -1000, -1000,  -254,  -257,  -109,
   312, -1000,  -213,   235, -1000,    10,   192,   557, -1000,   -56,
 -1000, -1000, -1000,   557,   -83, -1000, -1000,   557, -1000,   542,
   147, -1000,   701,   281, -1000, -1000,  -257, -1000, -1000,  -222,
 -1000,   -19,   418, -1000,  -299, -1000, -1000,   413, -1000,   -35,
   393, -1000,  -226, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
  -111,   -48,  -215,  -257, -1000, -1000, -1000, -1000,  -299, -1000,
 -1000, -1000,   120,   185,   178,   701,   640,   701,   358,  -249,
   542,     8, -1000,  -257,  -197,   250,  -257,   177,  -257,  -299,
 -1000,  -215,  -171,   557,  -250, -1000, -1000,   308,   175,   192,
 -1000,   -60,   185,   144, -1000, -1000, -1000, -1000, -1000,   -27,
   247,  -129,   367, -1000,   352,   306, -1000, -1000,   390,  -300,
 -1000,  -135,  -249,   277, -1000,   -53,   701,   298, -1000, -1000,
 -1000,  -299, -1000, -1000,   185,   174, -1000,  -249, -1000,   245,
  -299, -1000, -1000, -1000, -1000, -1000,  -252,  -257,  -257, -1000,
 -1000,  -257, -1000,  -299,   -88,  -257,  -250,  -250,   171, -1000,
 -1000,   185,  -171,  -299, -1000,  -249,   387, -1000,   339, -1000,
 -1000,  -127, -1000,   291, -1000,  -238,  -238, -1000, -1000, -1000,
 -1000, -1000, -1000,  -257,  -300,   274, -1000,  -250, -1000,   -30,
 -1000,   295, -1000,   244, -1000, -1000, -1000, -1000,   -65, -1000,
 -1000, -1000, -1000, -1000,  -257,  -257,   406, -1000, -1000, -1000,
 -1000, -1000 };
static yytabelem yypgo[]={

     0,   792,   785,   784,   774,   773,   772,   771,   768,   767,
   766,   765,   760,   758,   757,   756,   755,   750,   747,   742,
   741,   740,     1,   738,   727,   724,   721,   720,   719,   717,
   262,   716,   712,   706,   705,   703,   701,   579,   696,   288,
   322,   694,    20,    13,   272,    19,   170,   691,   688,   687,
   256,   263,   266,   282,    34,   684,    26,   683,     9,     5,
   678,   677,   676,   504,    15,   671,   670,   665,    23,   661,
   657,   656,   654,   652,   650,   649,   645,   644,   643,   638,
    25,    10,   636,   633,   632,    11,    14,   621,   620,     7,
   618,   273,   612,    17,   603,    29,   598,   596,   595,   278,
   594,   593,   592,   591,   585,   583,   500,   581,   580,   569,
   564,   563,   562,   559,   556,   555,   553,   212,   549,   128,
    41,    36,    24,    16,     8,   392,   543,   537,    12,   527,
   513,     6,     3,     2,    18,   511,    22,   510,   505,   139,
   257,     4,    21,    85,     0,    27,   503,   501,   497,   446 };
static yytabelem yyr1[]={

     0,    63,    63,     1,     1,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     3,   119,   146,     4,     5,     6,   101,
   101,    38,    38,    38,    99,    99,     7,     7,    65,    65,
    66,    66,   113,   113,   103,   103,   102,   102,   102,   110,
   110,   104,   104,    67,    67,     8,   114,   105,   105,   105,
    39,    39,    39,    68,    94,    94,   120,   120,   121,   121,
   121,   121,   121,     9,    11,   106,   106,   106,   112,   112,
   112,    13,    13,   111,   111,    50,    50,    12,    69,    69,
    70,    70,   133,    10,    17,    15,    71,    71,    72,    72,
    73,    16,   115,   115,   115,   115,   115,    51,    52,    20,
   107,   107,   107,   107,   107,    19,    74,    74,    18,    53,
    53,    54,    54,    54,    54,    54,    54,    54,    75,    75,
    75,    75,    21,    55,    55,   108,   108,   148,    23,    76,
    76,    76,    77,    77,   130,   130,   109,   109,   109,   109,
   100,   100,    34,    14,    24,    24,    24,    24,    24,    24,
    25,    26,    27,    28,    36,    29,    29,    22,    22,    22,
    22,    22,    22,    33,   116,   116,    78,    78,    79,    79,
   122,    80,    80,   123,   123,   123,    35,    32,    31,    30,
    57,    57,    56,    56,    56,    81,    81,    82,    82,   132,
   132,    58,    58,    58,    58,    83,    83,    84,    84,   135,
   134,    59,    59,    59,    98,    98,    64,    85,    85,    96,
    96,    97,    97,   128,   128,   127,   127,    86,    86,    87,
    87,   136,   136,   136,   124,   124,   137,   137,   137,   138,
   138,    60,    60,    61,    61,    88,    88,    88,    89,    89,
    89,   118,   118,   117,   125,   125,   125,   125,   125,   125,
   125,   125,   125,   125,   125,   125,   125,   125,   125,   125,
   125,   125,   125,   125,   125,   125,   125,   125,   125,   125,
   125,    95,    95,    95,    90,    90,   131,   131,    91,    91,
    91,    92,    92,    92,   139,   139,   139,    93,    93,    93,
   140,   140,   140,    49,    49,    37,    37,    40,    41,    42,
    43,    44,    45,    46,   145,    47,    48,   126,   126,   126,
   126,   126,   141,   129,   129,   142,   143,   144,    62,    62,
   147,   149 };
static yytabelem yyr2[]={

     0,     5,     3,     2,     5,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    15,     5,     1,     9,     5,    11,     3,
     3,     3,     3,     3,     3,     1,    21,    13,     3,     1,
     7,     3,     3,     9,     7,     1,     3,     3,     3,     7,
     1,     7,     1,     9,     1,     7,     5,     3,     3,     3,
     2,     2,     2,     7,     3,     7,     7,     3,     3,     3,
     3,     3,     5,     7,     9,     3,     3,     1,     3,     3,
     1,     9,    11,     3,     1,     5,     1,    25,     9,     1,
     7,     3,     7,     9,     7,    23,     5,     1,     7,     5,
     2,     7,     3,     3,     5,     5,     1,     5,     5,     7,
     3,     3,     3,     3,     3,    13,     3,     1,    13,     2,
     2,     3,     3,     3,     3,     3,     3,     3,     3,     7,
     7,     7,    19,     3,     1,     3,     1,     1,    27,     3,
     3,     7,     3,     5,     7,     3,     3,     3,     3,     3,
     3,     1,     5,     5,     5,     5,     5,     3,     3,     3,
    11,     5,     5,     5,     9,     3,     5,     2,     2,     2,
     2,     2,     2,    11,     9,     9,     7,     1,     7,     3,
     5,     7,     3,     3,     7,     3,     9,    13,    23,    19,
     7,     1,     3,     7,     1,     7,     1,     3,     7,     5,
     5,     5,     5,     5,     1,     3,     3,     7,     3,    11,
     5,     2,     5,     1,     3,     1,     2,     3,     7,     7,
     1,     3,     7,     3,     3,     5,     1,     5,     1,     7,
     3,     7,     5,     3,     5,     1,     3,     5,     5,    11,
     7,     2,     1,     2,     1,     7,     9,     1,     7,     9,
     1,     3,     5,     5,     5,     3,     5,     7,     7,     7,
     7,     7,     7,     7,     5,     5,     5,     7,     7,     7,
     5,     5,     3,     9,     7,     9,     5,     5,     7,     7,
     5,     9,    13,     1,     3,     7,     7,     7,     3,     7,
     7,     7,     3,     3,     9,     5,     7,     7,     3,     3,
     7,     3,     7,     3,     1,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     2,     2 };
static yytabelem yychk[]={

 -1000,   -63,    -1,    -2,    -3,    -4,    -5,    -6,    -7,   -36,
    -8,    -9,   -10,   -11,   -12,   -13,   -14,   -15,   -16,   -17,
   -18,   -19,   -20,   -21,   -22,   -23,   -24,   -25,   -26,   -27,
   -28,   -29,   263,   274,   275,   278,   279,   276,   288,   290,
   291,   311,   308,   323,   347,   -30,   -31,   -32,   -33,   -34,
   -35,   257,   271,   289,   309,   280,   285,   341,   330,   283,
   339,   302,   316,   284,   -63,    59,   336,   258,   -49,  -144,
   349,   -99,   272,   336,  -106,  -105,   300,   295,   329,   344,
   293,   269,   319,  -147,   261,   324,   -44,  -144,   336,  -107,
   295,   319,   261,  -147,   300,   329,   344,   300,  -106,  -106,
   -37,   -62,  -144,   281,   312,   -37,   348,   338,   338,   338,
   -47,  -143,   350,   -40,  -144,   -40,   -37,   -56,   286,   -46,
  -144,   -37,   304,   -37,   294,   -37,  -146,   -37,   -37,   343,
  -114,   -39,  -144,   -54,   351,    43,    45,    42,    47,    60,
    62,    61,   -44,   -39,   -46,   -46,   318,   -64,   -85,   -46,
   -46,   -46,   -53,   351,   -54,   -44,  -112,  -142,   262,   352,
  -111,   337,  -142,  -115,   -51,   -52,   270,   260,   -48,  -144,
   -93,  -140,    42,  -125,   -37,  -131,  -126,    45,    58,    59,
   124,    40,   351,  -144,   -46,   314,  -141,  -142,   354,  -143,
  -149,   353,   322,   318,   -99,   331,   -37,   -37,   -98,    42,
   -64,  -101,   337,   294,    40,   -37,   -68,    40,   318,   -72,
    40,   268,   268,   -37,    44,    40,    40,  -124,   345,   -50,
   299,   -50,  -142,   -52,   -51,  -145,  -143,  -145,   -57,    44,
   304,    43,    45,    47,    42,    60,    62,    61,   351,   305,
   317,   264,   320,   268,    46,   -95,    91,   357,  -125,   -37,
  -125,  -125,  -125,  -125,  -125,    40,  -125,    46,  -144,   282,
   -92,  -139,    42,  -144,  -131,   -37,  -141,   -78,    40,  -124,
   259,   325,   -38,  -143,   333,   334,   -65,   -66,  -119,  -144,
   294,   -94,  -120,   -39,   -37,   328,   -73,    41,   -85,  -148,
   -30,   -46,   -74,   -85,   -75,   -46,   313,  -125,   -46,   -50,
   -86,   294,  -140,   336,  -125,  -125,  -125,  -125,  -125,  -125,
  -125,  -125,  -125,  -125,  -144,   -91,    42,   -42,  -144,  -125,
  -117,  -118,   -46,   332,    46,    41,    42,    41,   -90,  -125,
   -91,   292,   -86,    44,   -95,   -95,    46,  -116,   342,   330,
   -79,  -122,  -144,   277,  -108,   277,    41,    44,  -117,  -113,
   -37,    41,    44,    61,   340,  -121,  -144,   -53,  -129,  -143,
   332,  -142,   354,    41,   318,    41,    41,    44,    44,  -124,
   -87,  -136,  -137,   -37,   -37,    46,    93,    58,   -88,    91,
   -46,    41,    41,    44,   330,  -124,  -139,    61,    42,    40,
   -80,  -123,  -125,   -37,    42,    41,    44,   -95,  -119,   -55,
   -46,   -67,   301,  -119,    91,  -120,  -121,   -41,  -144,   -71,
   346,  -144,  -109,   330,   339,   284,   302,   -46,   313,   -46,
   -96,   296,    44,   268,   -45,  -144,    42,  -138,    91,   -42,
    42,   -95,  -125,    93,  -142,  -125,   -56,  -125,   -80,   -86,
    44,    46,  -122,   337,  -103,   266,    40,  -145,    40,   268,
   -68,   337,  -127,   297,   273,  -136,   -45,   -60,  -145,    93,
   -89,    91,    93,   -93,    41,  -124,  -123,    42,   -46,  -110,
   335,    61,   -64,    93,   -83,   -84,  -135,  -134,   -46,   -42,
  -144,  -143,  -130,   -37,   -81,   321,  -125,   -97,  -128,  -144,
  -131,    44,    93,   -95,    93,  -142,   -89,   -86,  -104,   267,
    61,  -102,   298,   307,   313,    41,    41,    44,    40,   -59,
   -43,   346,  -144,   306,  -124,    46,   273,    44,   -61,  -145,
   -89,    93,  -124,    61,  -143,   -69,   346,  -134,   -85,   -43,
  -143,   287,   -42,   -82,  -132,  -144,  -131,  -128,    93,   -89,
   -81,  -143,  -124,    40,    41,  -100,   303,    44,   -58,   340,
   -58,   -70,  -133,  -144,   -59,   -76,   315,   -22,    91,  -132,
   351,    60,    62,    41,    44,    61,   -77,   -22,  -133,  -144,
    93,   -22 };
static yytabelem yydef[]={

     0,    -2,     2,     3,     5,     6,     7,     8,     9,    10,
    11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
    21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
    31,    32,     0,     0,   314,    45,    87,     0,     0,     0,
    87,    87,     0,     0,     0,   177,   178,   179,   180,   181,
   182,   167,   168,   169,     0,     0,     0,   175,   204,     0,
     0,     0,     0,     0,     1,     4,     0,    35,    37,   313,
   337,     0,    44,     0,     0,     0,     0,     0,     0,     0,
    85,    86,    67,    68,    69,   340,     0,   321,     0,     0,
     0,     0,   120,   121,   122,   123,   124,     0,    90,    94,
   163,   315,   316,   338,   339,   116,     0,   164,   165,   166,
   171,   325,   336,   172,   317,   173,   176,     0,   202,    45,
   323,     0,     0,   162,     0,   225,     0,     0,     0,     0,
    65,     0,    70,    71,    72,   131,   132,   133,   134,   135,
   136,   137,     0,     0,     0,     0,     0,    83,   226,   227,
   119,     0,     0,   129,   130,   245,    96,    88,    89,   335,
    96,     0,    93,   111,   112,   113,     0,     0,   104,   326,
   201,   308,   309,   311,     0,   293,   265,     0,     0,     0,
     0,     0,     0,    -2,     0,     0,   330,   327,   328,   329,
   331,   332,   341,     0,     0,     0,   187,   245,     0,   224,
    36,     0,    39,    40,    49,     0,    66,     0,     0,     0,
     0,   147,     0,   174,     0,   127,     0,   103,     0,    84,
     0,    91,    96,   114,   115,   117,   324,   118,   238,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    -2,   286,
   287,     0,     0,     0,     0,   264,     0,     0,   266,     0,
   274,   275,   276,     0,    -2,     0,   290,     0,   203,     0,
   238,   302,   303,    -2,   293,     0,     0,     0,     0,   196,
     0,   146,    38,    41,    42,    43,     0,    48,    51,     0,
     0,     0,    74,    77,     0,     0,     0,   109,   110,     0,
   170,   228,     0,   126,     0,   138,     0,   244,    95,    92,
   245,     0,   307,     0,   267,   268,   269,   270,    -2,    -2,
   273,    -2,   288,   289,   310,   296,   312,   298,   319,     0,
   277,   257,   261,     0,     0,   278,     0,   284,     0,   294,
   297,     0,   245,     0,     0,   305,     0,   183,     0,     0,
     0,   189,   293,     0,   144,   145,    64,     0,    34,    47,
    52,    73,     0,     0,     0,   107,    78,    79,    80,    81,
     0,   333,   334,   108,     0,   125,   128,     0,     0,   230,
   237,   240,   243,   246,   200,     0,   293,     0,   263,     0,
   262,   283,   285,     0,   204,   197,   301,     0,   306,     0,
   238,   192,   193,     0,   195,   186,     0,   190,    33,     0,
   143,    55,     0,    50,     0,    75,    76,     0,   318,     0,
     0,    82,     0,   156,   157,   158,   159,   139,   141,   140,
   236,     0,     0,     0,   242,   322,   247,   248,   252,   299,
   300,   291,     0,   260,     0,   295,     0,   304,     0,   245,
     0,     0,   188,     0,    60,     0,     0,     0,     0,     0,
   106,     0,   206,     0,     0,   239,   241,     0,   251,   293,
   255,     0,   260,   238,   184,   185,   191,   194,   142,    62,
     0,     0,     0,    53,     0,   215,   216,   218,     0,   223,
    -2,     0,   245,   155,   199,     0,   235,   229,   231,    -2,
   234,   254,   250,   292,   260,     0,   256,   245,    46,     0,
     0,    54,    56,    57,    58,    63,    99,     0,     0,   220,
   221,     0,   320,     0,     0,     0,     0,     0,     0,   253,
   258,   260,   206,     0,    59,   245,     0,   217,     0,   222,
   105,   161,   154,   205,   207,    -2,   214,   232,   249,   259,
   198,    61,    97,     0,   223,     0,   160,     0,   209,     0,
   210,     0,   101,     0,   219,   148,   149,   150,     0,   208,
   211,   212,   213,    98,     0,     0,     0,   152,   100,   102,
   151,   153 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"ABORT_TRANS",	257,
	"ACL",	258,
	"ADD",	259,
	"AFTER",	260,
	"AGGREGATE",	261,
	"ALL",	262,
	"ALTER",	263,
	"AND",	264,
	"APPEND",	265,
	"ARCHIVE",	266,
	"ARCH_STORE",	267,
	"AS",	268,
	"BACKWARD",	269,
	"BEFORE",	270,
	"BEGIN_TRANS",	271,
	"BINARY",	272,
	"BY",	273,
	"CHANGE",	274,
	"CLOSE",	275,
	"CLUSTER",	276,
	"COLUMN",	277,
	"COPY",	278,
	"CREATE",	279,
	"CREATEDB",	280,
	"CURRENT",	281,
	"CURSOR",	282,
	"DECLARE",	283,
	"DELETE",	284,
	"DESTROYDB",	285,
	"DISTINCT",	286,
	"DO",	287,
	"DROP",	288,
	"END_TRANS",	289,
	"EXTEND",	290,
	"FETCH",	291,
	"FOR",	292,
	"FORWARD",	293,
	"FROM",	294,
	"FUNCTION",	295,
	"GROUP",	296,
	"HAVING",	297,
	"HEAVY",	298,
	"IN",	299,
	"INDEX",	300,
	"INHERITS",	301,
	"INSERT",	302,
	"INSTEAD",	303,
	"INTO",	304,
	"ISNULL",	305,
	"LANGUAGE",	306,
	"LIGHT",	307,
	"LISTEN",	308,
	"LOAD",	309,
	"MERGE",	310,
	"MOVE",	311,
	"NEW",	312,
	"NONE",	313,
	"NOT",	314,
	"NOTHING",	315,
	"NOTIFY",	316,
	"NOTNULL",	317,
	"ON",	318,
	"OPERATOR",	319,
	"OR",	320,
	"ORDER",	321,
	"PNULL",	322,
	"PURGE",	323,
	"P_TYPE",	324,
	"RENAME",	325,
	"REPLACE",	326,
	"RETRIEVE",	327,
	"RETURNS",	328,
	"RULE",	329,
	"SELECT",	330,
	"SET",	331,
	"SETOF",	332,
	"STDIN",	333,
	"STDOUT",	334,
	"STORE",	335,
	"TABLE",	336,
	"TO",	337,
	"TRANSACTION",	338,
	"UPDATE",	339,
	"USING",	340,
	"VACUUM",	341,
	"VALUES",	342,
	"VERSION",	343,
	"VIEW",	344,
	"WHERE",	345,
	"WITH",	346,
	"EXECUTE",	347,
	"RECIPE",	348,
	"IDENT",	349,
	"SCONST",	350,
	"Op",	351,
	"ICONST",	352,
	"PARAM",	353,
	"FCONST",	354,
	"OP",	355,
	"=",	61,
	"+",	43,
	"-",	45,
	"*",	42,
	"/",	47,
	"|",	124,
	";",	59,
	":",	58,
	"<",	60,
	">",	62,
	"UMINUS",	356,
	".",	46,
	"[",	91,
	"]",	93,
	"TYPECAST",	357,
	"REDUCE",	358,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
      "queryblock : query queryblock",
      "queryblock : query",
      "query : stmt",
      "query : stmt ';'",
      "stmt : AddAttrStmt",
      "stmt : ChangeACLStmt",
      "stmt : ClosePortalStmt",
      "stmt : CopyStmt",
      "stmt : CreateStmt",
      "stmt : ClusterStmt",
      "stmt : DefineStmt",
      "stmt : DestroyStmt",
      "stmt : ExtendStmt",
      "stmt : FetchStmt",
      "stmt : IndexStmt",
      "stmt : MoveStmt",
      "stmt : ListenStmt",
      "stmt : ProcedureStmt",
      "stmt : PurgeStmt",
      "stmt : RecipeStmt",
      "stmt : RemoveOperStmt",
      "stmt : RemoveFuncStmt",
      "stmt : RemoveStmt",
      "stmt : RenameStmt",
      "stmt : OptimizableStmt",
      "stmt : RuleStmt",
      "stmt : TransactionStmt",
      "stmt : ViewStmt",
      "stmt : LoadStmt",
      "stmt : CreatedbStmt",
      "stmt : DestroydbStmt",
      "stmt : VacuumStmt",
      "AddAttrStmt : ALTER TABLE relation_name opt_inh_star ADD COLUMN columnDef",
      "columnDef : Id Typename",
      "ChangeACLStmt : CHANGE ACL",
      "ChangeACLStmt : CHANGE ACL relation_name_list",
      "ClosePortalStmt : CLOSE opt_id",
      "CopyStmt : COPY opt_binary relation_name copy_dirn copy_file_name",
      "copy_dirn : TO",
      "copy_dirn : FROM",
      "copy_file_name : Sconst",
      "copy_file_name : STDIN",
      "copy_file_name : STDOUT",
      "opt_binary : BINARY",
      "opt_binary : /* empty */",
      "CreateStmt : CREATE TABLE relation_name '(' OptTableElementList ')' OptInherit OptArchiveType OptLocation OptArchiveLocation",
      "CreateStmt : CREATE opt_direction VERSION relation_name FROM relation_name_version",
      "OptTableElementList : tableElementList",
      "OptTableElementList : /* empty */",
      "tableElementList : tableElementList ',' columnDef",
      "tableElementList : columnDef",
      "relation_name_version : relation_name",
      "relation_name_version : relation_name '[' date ']'",
      "OptArchiveType : ARCHIVE '=' archive_type",
      "OptArchiveType : /* empty */",
      "archive_type : HEAVY",
      "archive_type : LIGHT",
      "archive_type : NONE",
      "OptLocation : STORE '=' Sconst",
      "OptLocation : /* empty */",
      "OptArchiveLocation : ARCH_STORE '=' Sconst",
      "OptArchiveLocation : /* empty */",
      "OptInherit : INHERITS '(' relation_name_list ')'",
      "OptInherit : /* empty */",
      "DefineStmt : CREATE def_type def_rest",
      "def_rest : def_name definition",
      "def_type : OPERATOR",
      "def_type : Type",
      "def_type : AGGREGATE",
      "def_name : Id",
      "def_name : MathOp",
      "def_name : Op",
      "definition : '(' def_list ')'",
      "def_list : def_elem",
      "def_list : def_list ',' def_elem",
      "def_elem : def_name '=' def_arg",
      "def_elem : def_name",
      "def_arg : Id",
      "def_arg : all_Op",
      "def_arg : NumConst",
      "def_arg : Sconst",
      "def_arg : SETOF Id",
      "DestroyStmt : DROP TABLE relation_name_list",
      "FetchStmt : FETCH opt_direction fetch_how_many opt_portal_name",
      "opt_direction : FORWARD",
      "opt_direction : BACKWARD",
      "opt_direction : /* empty */",
      "fetch_how_many : Iconst",
      "fetch_how_many : ALL",
      "fetch_how_many : /* empty */",
      "MoveStmt : MOVE opt_direction opt_move_where opt_portal_name",
      "MoveStmt : MOVE opt_direction TO Iconst opt_portal_name",
      "opt_move_where : Iconst",
      "opt_move_where : /* empty */",
      "opt_portal_name : IN name",
      "opt_portal_name : /* empty */",
      "IndexStmt : CREATE INDEX index_name ON relation_name USING access_method '(' index_params ')' with_clause where_clause",
      "with_clause : WITH '(' param_list ')'",
      "with_clause : /* empty */",
      "param_list : param_list ',' param",
      "param_list : param",
      "param : Id '=' Id",
      "ExtendStmt : EXTEND INDEX index_name where_clause",
      "RecipeStmt : EXECUTE RECIPE recipe_name",
      "ProcedureStmt : CREATE FUNCTION def_name def_args RETURNS def_arg opt_with AS Sconst LANGUAGE Sconst",
      "opt_with : WITH definition",
      "opt_with : /* empty */",
      "def_args : '(' def_name_list ')'",
      "def_args : '(' ')'",
      "def_name_list : name_list",
      "PurgeStmt : PURGE relation_name purge_quals",
      "purge_quals : before_clause",
      "purge_quals : after_clause",
      "purge_quals : before_clause after_clause",
      "purge_quals : after_clause before_clause",
      "purge_quals : /* empty */",
      "before_clause : BEFORE date",
      "after_clause : AFTER date",
      "RemoveStmt : DROP remove_type name",
      "remove_type : AGGREGATE",
      "remove_type : Type",
      "remove_type : INDEX",
      "remove_type : RULE",
      "remove_type : VIEW",
      "RemoveFuncStmt : DROP FUNCTION name '(' func_argtypes ')'",
      "func_argtypes : name_list",
      "func_argtypes : /* empty */",
      "RemoveOperStmt : DROP OPERATOR all_Op '(' oper_argtypes ')'",
      "all_Op : Op",
      "all_Op : MathOp",
      "MathOp : '+'",
      "MathOp : '-'",
      "MathOp : '*'",
      "MathOp : '/'",
      "MathOp : '<'",
      "MathOp : '>'",
      "MathOp : '='",
      "oper_argtypes : name",
      "oper_argtypes : name ',' name",
      "oper_argtypes : NONE ',' name",
      "oper_argtypes : name ',' NONE",
      "RenameStmt : ALTER TABLE relation_name opt_inh_star RENAME opt_column opt_name TO name",
      "opt_name : name",
      "opt_name : /* empty */",
      "opt_column : COLUMN",
      "opt_column : /* empty */",
      "RuleStmt : CREATE RULE name AS",
      "RuleStmt : CREATE RULE name AS ON event TO event_object where_clause DO opt_instead OptStmtList",
      "OptStmtList : NOTHING",
      "OptStmtList : OptimizableStmt",
      "OptStmtList : '[' OptStmtBlock ']'",
      "OptStmtBlock : OptimizableStmt",
      "OptStmtBlock : OptStmtBlock OptimizableStmt",
      "event_object : relation_name '.' attr_name",
      "event_object : relation_name",
      "event : SELECT",
      "event : UPDATE",
      "event : DELETE",
      "event : INSERT",
      "opt_instead : INSTEAD",
      "opt_instead : /* empty */",
      "NotifyStmt : NOTIFY relation_name",
      "ListenStmt : LISTEN relation_name",
      "TransactionStmt : ABORT_TRANS TRANSACTION",
      "TransactionStmt : BEGIN_TRANS TRANSACTION",
      "TransactionStmt : END_TRANS TRANSACTION",
      "TransactionStmt : ABORT_TRANS",
      "TransactionStmt : BEGIN_TRANS",
      "TransactionStmt : END_TRANS",
      "ViewStmt : CREATE VIEW name AS RetrieveStmt",
      "LoadStmt : LOAD file_name",
      "CreatedbStmt : CREATEDB database_name",
      "DestroydbStmt : DESTROYDB database_name",
      "ClusterStmt : CLUSTER index_name ON relation_name",
      "VacuumStmt : VACUUM",
      "VacuumStmt : VACUUM relation_name",
      "OptimizableStmt : RetrieveStmt",
      "OptimizableStmt : CursorStmt",
      "OptimizableStmt : ReplaceStmt",
      "OptimizableStmt : AppendStmt",
      "OptimizableStmt : NotifyStmt",
      "OptimizableStmt : DeleteStmt",
      "AppendStmt : INSERT INTO relation_name opt_column_list insert_rest",
      "insert_rest : VALUES '(' exprList ')'",
      "insert_rest : SELECT exprList from_clause where_clause",
      "opt_column_list : '(' columnList ')'",
      "opt_column_list : /* empty */",
      "columnList : columnList ',' columnElem",
      "columnList : columnElem",
      "columnElem : Id opt_indirection",
      "exprList : exprList ',' exprElem",
      "exprList : exprElem",
      "exprElem : a_expr",
      "exprElem : relation_name '.' '*'",
      "exprElem : '*'",
      "DeleteStmt : DELETE FROM relation_name where_clause",
      "ReplaceStmt : UPDATE relation_name SET res_target_list from_clause where_clause",
      "CursorStmt : DECLARE name opt_binary CURSOR FOR SELECT opt_unique res_target_list2 from_clause where_clause sort_clause",
      "RetrieveStmt : SELECT opt_unique res_target_list2 result from_clause where_clause group_clause having_clause sort_clause",
      "result : INTO TABLE relation_name",
      "result : /* empty */",
      "opt_unique : DISTINCT",
      "opt_unique : DISTINCT ON Id",
      "opt_unique : /* empty */",
      "sort_clause : ORDER BY sortby_list",
      "sort_clause : /* empty */",
      "sortby_list : sortby",
      "sortby_list : sortby_list ',' sortby",
      "sortby : Id OptUseOp",
      "sortby : attr OptUseOp",
      "OptUseOp : USING Op",
      "OptUseOp : USING '<'",
      "OptUseOp : USING '>'",
      "OptUseOp : /* empty */",
      "index_params : index_list",
      "index_params : func_index",
      "index_list : index_list ',' index_elem",
      "index_list : index_elem",
      "func_index : name '(' name_list ')' opt_class",
      "index_elem : attr_name opt_class",
      "opt_class : class",
      "opt_class : WITH class",
      "opt_class : /* empty */",
      "opt_inh_star : '*'",
      "opt_inh_star : /* empty */",
      "relation_name_list : name_list",
      "name_list : name",
      "name_list : name_list ',' name",
      "group_clause : GROUP BY groupby_list",
      "group_clause : /* empty */",
      "groupby_list : groupby",
      "groupby_list : groupby_list ',' groupby",
      "groupby : Id",
      "groupby : attr",
      "having_clause : HAVING a_expr",
      "having_clause : /* empty */",
      "from_clause : FROM from_list",
      "from_clause : /* empty */",
      "from_list : from_list ',' from_val",
      "from_list : from_val",
      "from_val : relation_expr AS var_name",
      "from_val : relation_expr var_name",
      "from_val : relation_expr",
      "where_clause : WHERE a_expr",
      "where_clause : /* empty */",
      "relation_expr : relation_name",
      "relation_expr : relation_name '*'",
      "relation_expr : relation_name time_range",
      "time_range : '[' opt_range_start ',' opt_range_end ']'",
      "time_range : '[' date ']'",
      "opt_range_start : date",
      "opt_range_start : /* empty */",
      "opt_range_end : date",
      "opt_range_end : /* empty */",
      "opt_array_bounds : '[' ']' nest_array_bounds",
      "opt_array_bounds : '[' Iconst ']' nest_array_bounds",
      "opt_array_bounds : /* empty */",
      "nest_array_bounds : '[' ']' nest_array_bounds",
      "nest_array_bounds : '[' Iconst ']' nest_array_bounds",
      "nest_array_bounds : /* empty */",
      "typname : name",
      "typname : SETOF name",
      "Typename : typname opt_array_bounds",
      "a_expr : attr opt_indirection",
      "a_expr : AexprConst",
      "a_expr : '-' a_expr",
      "a_expr : a_expr '+' a_expr",
      "a_expr : a_expr '-' a_expr",
      "a_expr : a_expr '/' a_expr",
      "a_expr : a_expr '*' a_expr",
      "a_expr : a_expr '<' a_expr",
      "a_expr : a_expr '>' a_expr",
      "a_expr : a_expr '=' a_expr",
      "a_expr : ':' a_expr",
      "a_expr : ';' a_expr",
      "a_expr : '|' a_expr",
      "a_expr : AexprConst TYPECAST Typename",
      "a_expr : '(' a_expr ')'",
      "a_expr : a_expr Op a_expr",
      "a_expr : Op a_expr",
      "a_expr : a_expr Op",
      "a_expr : Id",
      "a_expr : name '(' '*' ')'",
      "a_expr : name '(' ')'",
      "a_expr : name '(' expr_list ')'",
      "a_expr : a_expr ISNULL",
      "a_expr : a_expr NOTNULL",
      "a_expr : a_expr AND a_expr",
      "a_expr : a_expr OR a_expr",
      "a_expr : NOT a_expr",
      "opt_indirection : '[' a_expr ']' opt_indirection",
      "opt_indirection : '[' a_expr ':' a_expr ']' opt_indirection",
      "opt_indirection : /* empty */",
      "expr_list : a_expr",
      "expr_list : expr_list ',' a_expr",
      "attr : relation_name '.' attrs",
      "attr : ParamNo '.' attrs",
      "attrs : attr_name",
      "attrs : attrs '.' attr_name",
      "attrs : attrs '.' '*'",
      "res_target_list : res_target_list ',' res_target_el",
      "res_target_list : res_target_el",
      "res_target_list : '*'",
      "res_target_el : Id opt_indirection '=' a_expr",
      "res_target_el : attr opt_indirection",
      "res_target_el : relation_name '.' '*'",
      "res_target_list2 : res_target_list2 ',' res_target_el2",
      "res_target_list2 : res_target_el2",
      "res_target_list2 : '*'",
      "res_target_el2 : a_expr AS Id",
      "res_target_el2 : a_expr",
      "res_target_el2 : relation_name '.' '*'",
      "opt_id : Id",
      "opt_id : /* empty */",
      "relation_name : SpecialRuleRelation",
      "relation_name : Id",
      "database_name : Id",
      "access_method : Id",
      "attr_name : Id",
      "class : Id",
      "index_name : Id",
      "var_name : Id",
      "name : Id",
      "date : Sconst",
      "file_name : Sconst",
      "recipe_name : Id",
      "AexprConst : Iconst",
      "AexprConst : FCONST",
      "AexprConst : Sconst",
      "AexprConst : ParamNo",
      "AexprConst : Pnull",
      "ParamNo : PARAM",
      "NumConst : Iconst",
      "NumConst : FCONST",
      "Iconst : ICONST",
      "Sconst : SCONST",
      "Id : IDENT",
      "SpecialRuleRelation : CURRENT",
      "SpecialRuleRelation : NEW",
      "Type : P_TYPE",
      "Pnull : PNULL",
};
#endif /* YYDEBUG */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1, 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
YYSTYPE *yypvt;			/* top of value stack for $vars */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(yytmp){

case 1:
{ parsetree = lcons(yypvt[-1].node, parsetree); } /*NOTREACHED*/ break;
case 2:
{ parsetree = lcons(yypvt[-0].node, NIL); } /*NOTREACHED*/ break;
case 4:
{  yyval.node = yypvt[-1].node;  } /*NOTREACHED*/ break;
case 33:
{
		    AddAttrStmt *n = makeNode(AddAttrStmt);
		    n->relname = yypvt[-4].str;
		    n->inh = yypvt[-3].boolean;
		    n->colDef = yypvt[-0].coldef;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 34:
{  
		    yyval.coldef = makeNode(ColumnDef);
		    yyval.coldef->colname = yypvt[-1].str;
		    yyval.coldef->typename = yypvt[-0].typnam;
		} /*NOTREACHED*/ break;
case 35:
{
		ChangeACLStmt *n = makeNode(ChangeACLStmt);
		extern char *Ch;

		n->aclitem = (AclItem*)palloc(sizeof(AclItem));
		Ch = aclparse(Ch, n->aclitem, (unsigned *)&n->modechg);
		yyval.node = (Node*)n;
	} /*NOTREACHED*/ break;
case 36:
{
		    ((ChangeACLStmt*)yypvt[-1].node)->relNames = yypvt[-0].list;
		    yyval.node = yypvt[-1].node;
		} /*NOTREACHED*/ break;
case 37:
{  
		    ClosePortalStmt *n = makeNode(ClosePortalStmt);
		    n->portalname = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 38:
{
		    CopyStmt *n = makeNode(CopyStmt);
		    n->binary = yypvt[-3].boolean;
		    n->relname = yypvt[-2].str;
		    n->direction = yypvt[-1].ival;
		    n->filename = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 39:
{ yyval.ival = TO; } /*NOTREACHED*/ break;
case 40:
{ yyval.ival = FROM; } /*NOTREACHED*/ break;
case 41:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 42:
{ yyval.str = NULL; } /*NOTREACHED*/ break;
case 43:
{ yyval.str = NULL; } /*NOTREACHED*/ break;
case 44:
{ yyval.boolean = TRUE; } /*NOTREACHED*/ break;
case 45:
{ yyval.boolean = FALSE; } /*NOTREACHED*/ break;
case 46:
{
		    CreateStmt *n = makeNode(CreateStmt);
		    n->relname = yypvt[-7].str;
		    n->tableElts = yypvt[-5].list;
		    n->inhRelnames = yypvt[-3].list;
		    n->archiveType = yypvt[-2].ival;
		    n->location = yypvt[-1].ival;
		    n->archiveLoc = yypvt[-0].ival;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 47:
{   
		    yypvt[-0].vstmt->direction = yypvt[-4].ival;
		    yypvt[-0].vstmt->fromRelname = yypvt[-2].str;
		    yyval.node = (Node *)yypvt[-0].vstmt;
		} /*NOTREACHED*/ break;
case 48:
{ yyval.list = yypvt[-0].list; } /*NOTREACHED*/ break;
case 49:
{ yyval.list = NULL; } /*NOTREACHED*/ break;
case 50:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].coldef); } /*NOTREACHED*/ break;
case 51:
{ yyval.list = lcons(yypvt[-0].coldef, NIL); } /*NOTREACHED*/ break;
case 52:
{
		    yyval.vstmt = makeNode(VersionStmt);
		    yyval.vstmt->fromRelname = yypvt[-0].str;
		    yyval.vstmt->date = NULL;
		} /*NOTREACHED*/ break;
case 53:
{
		    yyval.vstmt = makeNode(VersionStmt);
		    yyval.vstmt->fromRelname = yypvt[-3].str;
		    yyval.vstmt->date = yypvt[-1].str;
		} /*NOTREACHED*/ break;
case 54:
{ yyval.ival = yypvt[-0].ival; } /*NOTREACHED*/ break;
case 55:
{ yyval.ival = ARCH_NONE; } /*NOTREACHED*/ break;
case 56:
{ yyval.ival = ARCH_HEAVY; } /*NOTREACHED*/ break;
case 57:
{ yyval.ival = ARCH_LIGHT; } /*NOTREACHED*/ break;
case 58:
{ yyval.ival = ARCH_NONE; } /*NOTREACHED*/ break;
case 59:
{  yyval.ival = smgrin(yypvt[-0].str);  } /*NOTREACHED*/ break;
case 60:
{  yyval.ival = -1;  } /*NOTREACHED*/ break;
case 61:
{  yyval.ival = smgrin(yypvt[-0].str);  } /*NOTREACHED*/ break;
case 62:
{  yyval.ival = -1;  } /*NOTREACHED*/ break;
case 63:
{ yyval.list = yypvt[-1].list; } /*NOTREACHED*/ break;
case 64:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 65:
{
		    yypvt[-0].dstmt->defType = yypvt[-1].ival;
		    yyval.node = (Node *)yypvt[-0].dstmt;
		} /*NOTREACHED*/ break;
case 66:
{
		    yyval.dstmt = makeNode(DefineStmt);
		    yyval.dstmt->defname = yypvt[-1].str;
		    yyval.dstmt->definition = yypvt[-0].list;
		} /*NOTREACHED*/ break;
case 67:
{ yyval.ival = OPERATOR; } /*NOTREACHED*/ break;
case 68:
{ yyval.ival = P_TYPE; } /*NOTREACHED*/ break;
case 69:
{ yyval.ival = AGGREGATE; } /*NOTREACHED*/ break;
case 73:
{ yyval.list = yypvt[-1].list; } /*NOTREACHED*/ break;
case 74:
{ yyval.list = lcons(yypvt[-0].defelt, NIL); } /*NOTREACHED*/ break;
case 75:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].defelt); } /*NOTREACHED*/ break;
case 76:
{ 
		    yyval.defelt = makeNode(DefElem);
		    yyval.defelt->defname = yypvt[-2].str;
		    yyval.defelt->arg = (Node *)yypvt[-0].node;
		} /*NOTREACHED*/ break;
case 77:
{
		    yyval.defelt = makeNode(DefElem);
		    yyval.defelt->defname = yypvt[-0].str;
		    yyval.defelt->arg = (Node *)NULL;
		} /*NOTREACHED*/ break;
case 78:
{  yyval.node = (Node *)makeString(yypvt[-0].str); } /*NOTREACHED*/ break;
case 79:
{  yyval.node = (Node *)makeString(yypvt[-0].str); } /*NOTREACHED*/ break;
case 80:
{  yyval.node = (Node *)yypvt[-0].value; /* already a Value */ } /*NOTREACHED*/ break;
case 81:
{  yyval.node = (Node *)makeString(yypvt[-0].str); } /*NOTREACHED*/ break;
case 82:
{ 
				   TypeName *n = makeNode(TypeName);
				   n->name = yypvt[-0].str;
				   n->setof = TRUE;
				   n->arrayBounds = NULL;
				   yyval.node = (Node *)n;
				} /*NOTREACHED*/ break;
case 83:
{ 
		    DestroyStmt *n = makeNode(DestroyStmt);
		    n->relNames = yypvt[-0].list;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 84:
{
		    FetchStmt *n = makeNode(FetchStmt);
		    n->direction = yypvt[-2].ival;
		    n->howMany = yypvt[-1].ival;
		    n->portalname = yypvt[-0].str;
		    yyval.node = (Node *)n;
	        } /*NOTREACHED*/ break;
case 85:
{ yyval.ival = FORWARD; } /*NOTREACHED*/ break;
case 86:
{ yyval.ival = BACKWARD; } /*NOTREACHED*/ break;
case 87:
{ yyval.ival = FORWARD; /* default */ } /*NOTREACHED*/ break;
case 88:
{ yyval.ival = yypvt[-0].ival;
		 if (yypvt[-0].ival <= 0) elog(WARN,"Please specify nonnegative count for fetch"); } /*NOTREACHED*/ break;
case 89:
{ yyval.ival = 0; /* 0 means fetch all tuples*/} /*NOTREACHED*/ break;
case 90:
{ yyval.ival = 0; /*default*/ } /*NOTREACHED*/ break;
case 91:
{ 
		    MoveStmt *n = makeNode(MoveStmt);
		    n->direction = yypvt[-2].ival;
		    n->to = FALSE;
		    n->where = yypvt[-1].ival;
		    n->portalname = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 92:
{ 
		    MoveStmt *n = makeNode(MoveStmt);
		    n->direction = yypvt[-3].ival;
		    n->to = TRUE;
		    n->where = yypvt[-1].ival;
		    n->portalname = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 93:
{ yyval.ival = yypvt[-0].ival; } /*NOTREACHED*/ break;
case 94:
{ yyval.ival = 1; /* default */ } /*NOTREACHED*/ break;
case 95:
{ yyval.str = yypvt[-0].str;} /*NOTREACHED*/ break;
case 96:
{ yyval.str = NULL; } /*NOTREACHED*/ break;
case 97:
{
		    /* should check that access_method is valid,
		       etc ... but doesn't */
		    IndexStmt *n = makeNode(IndexStmt);
		    n->idxname = yypvt[-9].str;
		    n->relname = yypvt[-7].str;
		    n->accessMethod = yypvt[-5].str;
		    n->indexParams = yypvt[-3].list;
		    n->withClause = yypvt[-1].list;
		    n->whereClause = yypvt[-0].node;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 98:
{ yyval.list = yypvt[-1].list; } /*NOTREACHED*/ break;
case 99:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 100:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].param); } /*NOTREACHED*/ break;
case 101:
{ yyval.list = lcons(yypvt[-0].param, NIL); } /*NOTREACHED*/ break;
case 102:
{ 
		    yyval.param = makeNode(ParamString);
		    yyval.param->name = yypvt[-2].str;
		    yyval.param->val = yypvt[-0].str;
		} /*NOTREACHED*/ break;
case 103:
{
		    ExtendStmt *n = makeNode(ExtendStmt);
		    n->idxname = yypvt[-1].str;
		    n->whereClause = yypvt[-0].node;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 104:
{
		    RecipeStmt *n;
		    if (!IsTransactionBlock())
			elog(WARN, "EXECUTE RECIPE may only be used in begin/end transaction blocks.");

		    n = makeNode(RecipeStmt);
		    n->recipeName = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 105:
{
		    ProcedureStmt *n = makeNode(ProcedureStmt);
		    n->funcname = yypvt[-8].str;
		    n->defArgs = yypvt[-7].list;
		    n->returnType = (Node *)yypvt[-5].node;
		    n->withClause = yypvt[-4].list;
		    n->as = yypvt[-2].str;
		    n->language = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 106:
{ yyval.list = yypvt[-0].list; } /*NOTREACHED*/ break;
case 107:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 108:
{ yyval.list = yypvt[-1].list; } /*NOTREACHED*/ break;
case 109:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 111:
{ 
		    yypvt[-0].pstmt->relname = yypvt[-1].str;
		    yyval.node = (Node *)yypvt[-0].pstmt;
		} /*NOTREACHED*/ break;
case 112:
{ 
		    yyval.pstmt = makeNode(PurgeStmt);
		    yyval.pstmt->beforeDate = yypvt[-0].str;
		    yyval.pstmt->afterDate = NULL;
		} /*NOTREACHED*/ break;
case 113:
{ 
		    yyval.pstmt = makeNode(PurgeStmt);
		    yyval.pstmt->beforeDate = NULL;
		    yyval.pstmt->afterDate = yypvt[-0].str;
		} /*NOTREACHED*/ break;
case 114:
{ 
		    yyval.pstmt = makeNode(PurgeStmt);
		    yyval.pstmt->beforeDate = yypvt[-1].str;
		    yyval.pstmt->afterDate = yypvt[-0].str;
		} /*NOTREACHED*/ break;
case 115:
{ 
		    yyval.pstmt = makeNode(PurgeStmt);
		    yyval.pstmt->beforeDate = yypvt[-0].str;
		    yyval.pstmt->afterDate = yypvt[-1].str;
		} /*NOTREACHED*/ break;
case 116:
{ 
		    yyval.pstmt = makeNode(PurgeStmt);
		    yyval.pstmt->beforeDate = NULL;
		    yyval.pstmt->afterDate = NULL;
		} /*NOTREACHED*/ break;
case 117:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 118:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 119:
{
		    RemoveStmt *n = makeNode(RemoveStmt);
		    n->removeType = yypvt[-1].ival;
		    n->name = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 120:
{  yyval.ival = AGGREGATE; } /*NOTREACHED*/ break;
case 121:
{  yyval.ival = P_TYPE; } /*NOTREACHED*/ break;
case 122:
{  yyval.ival = INDEX; } /*NOTREACHED*/ break;
case 123:
{  yyval.ival = RULE; } /*NOTREACHED*/ break;
case 124:
{  yyval.ival = VIEW; } /*NOTREACHED*/ break;
case 125:
{
		    RemoveFuncStmt *n = makeNode(RemoveFuncStmt);
		    n->funcname = yypvt[-3].str;
		    n->args = yypvt[-1].list;
		    yyval.node = (Node *)n;
	        } /*NOTREACHED*/ break;
case 126:
{ yyval.list = yypvt[-0].list; } /*NOTREACHED*/ break;
case 127:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 128:
{
		    RemoveOperStmt *n = makeNode(RemoveOperStmt);
		    n->opname = yypvt[-3].str;
		    n->args = yypvt[-1].list;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 131:
{ yyval.str = "+"; } /*NOTREACHED*/ break;
case 132:
{ yyval.str = "-"; } /*NOTREACHED*/ break;
case 133:
{ yyval.str = "*"; } /*NOTREACHED*/ break;
case 134:
{ yyval.str = "/"; } /*NOTREACHED*/ break;
case 135:
{ yyval.str = "<"; } /*NOTREACHED*/ break;
case 136:
{ yyval.str = ">"; } /*NOTREACHED*/ break;
case 137:
{ yyval.str = "="; } /*NOTREACHED*/ break;
case 138:
{ 
		   elog(WARN, "parser: argument type missing (use NONE for unary operators)");
		} /*NOTREACHED*/ break;
case 139:
{ yyval.list = makeList(makeString(yypvt[-2].str), makeString(yypvt[-0].str), -1); } /*NOTREACHED*/ break;
case 140:
{ yyval.list = makeList(NULL, makeString(yypvt[-0].str), -1); } /*NOTREACHED*/ break;
case 141:
{ yyval.list = makeList(makeString(yypvt[-2].str), NULL, -1); } /*NOTREACHED*/ break;
case 142:
{ 
		    RenameStmt *n = makeNode(RenameStmt);
		    n->relname = yypvt[-6].str;
		    n->inh = yypvt[-5].boolean;
		    n->column = yypvt[-2].str;
		    n->newname = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 143:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 144:
{ yyval.str = NULL; } /*NOTREACHED*/ break;
case 145:
{ yyval.ival = COLUMN; } /*NOTREACHED*/ break;
case 146:
{ yyval.ival = 0; } /*NOTREACHED*/ break;
case 147:
{ QueryIsRule=TRUE; } /*NOTREACHED*/ break;
case 148:
{
		    RuleStmt *n = makeNode(RuleStmt);
		    n->rulename = yypvt[-10].str;
		    n->event = yypvt[-6].ival;
		    n->object = yypvt[-4].attr;
		    n->whereClause = yypvt[-3].node;
		    n->instead = yypvt[-1].boolean;
		    n->actions = yypvt[-0].list;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 149:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 150:
{ yyval.list = lcons(yypvt[-0].node, NIL); } /*NOTREACHED*/ break;
case 151:
{ yyval.list = yypvt[-1].list; } /*NOTREACHED*/ break;
case 152:
{ yyval.list = lcons(yypvt[-0].node, NIL); } /*NOTREACHED*/ break;
case 153:
{  yyval.list = lappend(yypvt[-1].list, yypvt[-0].node); } /*NOTREACHED*/ break;
case 154:
{ 
		    yyval.attr = makeNode(Attr);
		    yyval.attr->relname = yypvt[-2].str;
		    yyval.attr->paramNo = NULL;
		    yyval.attr->attrs = lcons(makeString(yypvt[-0].str), NIL);
		    yyval.attr->indirection = NIL;
		} /*NOTREACHED*/ break;
case 155:
{
		    yyval.attr = makeNode(Attr);
		    yyval.attr->relname = yypvt[-0].str;
		    yyval.attr->paramNo = NULL;
		    yyval.attr->attrs = NIL;
		    yyval.attr->indirection = NIL;
		} /*NOTREACHED*/ break;
case 156:
{ yyval.ival = CMD_SELECT; } /*NOTREACHED*/ break;
case 157:
{ yyval.ival = CMD_UPDATE; } /*NOTREACHED*/ break;
case 158:
{ yyval.ival = CMD_DELETE; } /*NOTREACHED*/ break;
case 159:
{ yyval.ival = CMD_INSERT; } /*NOTREACHED*/ break;
case 160:
{ yyval.boolean = TRUE; } /*NOTREACHED*/ break;
case 161:
{ yyval.boolean = FALSE; } /*NOTREACHED*/ break;
case 162:
{
		    NotifyStmt *n = makeNode(NotifyStmt);
		    n->relname = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 163:
{
		    ListenStmt *n = makeNode(ListenStmt);
		    n->relname = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 164:
{ 
		    TransactionStmt *n = makeNode(TransactionStmt); 
		    n->command = ABORT_TRANS; 
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 165:
{ 
		    TransactionStmt *n = makeNode(TransactionStmt); 
		    n->command = BEGIN_TRANS;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 166:
{ 
		    TransactionStmt *n = makeNode(TransactionStmt); 
		    n->command = END_TRANS;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 167:
{ 
		    TransactionStmt *n = makeNode(TransactionStmt); 
		    n->command = ABORT_TRANS; 
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 168:
{ 
		    TransactionStmt *n = makeNode(TransactionStmt); 
		    n->command = BEGIN_TRANS;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 169:
{ 
		    TransactionStmt *n = makeNode(TransactionStmt); 
		    n->command = END_TRANS;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 170:
{ 
		    ViewStmt *n = makeNode(ViewStmt);
		    n->viewname = yypvt[-2].str;
		    n->query = (Query *)yypvt[-0].node;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 171:
{ 
		    LoadStmt *n = makeNode(LoadStmt);
		    n->filename = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 172:
{
		    CreatedbStmt *n = makeNode(CreatedbStmt);
		    n->dbname = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 173:
{
		    DestroydbStmt *n = makeNode(DestroydbStmt);
		    n->dbname = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 174:
{
		   ClusterStmt *n = makeNode(ClusterStmt);
		   n->relname = yypvt[-0].str;
		   n->indexname = yypvt[-2].str;
		   yyval.node = (Node*)n;
		} /*NOTREACHED*/ break;
case 175:
{
                   yyval.node = (Node *)makeNode(VacuumStmt);
               } /*NOTREACHED*/ break;
case 176:
{
                   VacuumStmt *n = makeNode(VacuumStmt);
                   n->vacrel = yypvt[-0].str;
                   yyval.node = (Node *)n;
               } /*NOTREACHED*/ break;
case 183:
{
		    yypvt[-0].astmt->relname = yypvt[-2].str;
		    yypvt[-0].astmt->cols = yypvt[-1].list;
		    yyval.node = (Node *)yypvt[-0].astmt;
                } /*NOTREACHED*/ break;
case 184:
{
		    yyval.astmt = makeNode(AppendStmt);
		    yyval.astmt->exprs = yypvt[-1].list;
		    yyval.astmt->fromClause = NIL;
		    yyval.astmt->whereClause = NULL;
		} /*NOTREACHED*/ break;
case 185:
{
		    yyval.astmt = makeNode(AppendStmt);
		    yyval.astmt->exprs = yypvt[-2].list;
		    yyval.astmt->fromClause = yypvt[-1].list;
		    yyval.astmt->whereClause = yypvt[-0].node;
		} /*NOTREACHED*/ break;
case 186:
{ yyval.list = yypvt[-1].list; } /*NOTREACHED*/ break;
case 187:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 188:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].node); } /*NOTREACHED*/ break;
case 189:
{ yyval.list = lcons(yypvt[-0].node, NIL); } /*NOTREACHED*/ break;
case 190:
{
		    Ident *id = makeNode(Ident);
		    id->name = yypvt[-1].str;
		    id->indirection = yypvt[-0].list;
		    yyval.node = (Node *)id;
		} /*NOTREACHED*/ break;
case 191:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].node); } /*NOTREACHED*/ break;
case 192:
{ yyval.list = lcons(yypvt[-0].node, NIL); } /*NOTREACHED*/ break;
case 193:
{   yyval.node = (Node *)yypvt[-0].node;  } /*NOTREACHED*/ break;
case 194:
{
		    Attr *n = makeNode(Attr);
		    n->relname = yypvt[-2].str;
		    n->paramNo = NULL;
		    n->attrs = lcons(makeString("*"), NIL);
		    n->indirection = NIL;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 195:
{
		    Attr *n = makeNode(Attr);
		    n->relname = "*";
		    n->paramNo = NULL;
		    n->attrs = NIL;
		    n->indirection = NIL;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 196:
{
		    DeleteStmt *n = makeNode(DeleteStmt);
		    n->relname = yypvt[-1].str;
		    n->whereClause = yypvt[-0].node;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 197:
{
		    ReplaceStmt *n = makeNode(ReplaceStmt);
		    n->relname = yypvt[-4].str;
		    n->targetList = yypvt[-2].list;
		    n->fromClause = yypvt[-1].list;
		    n->whereClause = yypvt[-0].node;
		    yyval.node = (Node *)n;
                } /*NOTREACHED*/ break;
case 198:
{
		    CursorStmt *n = makeNode(CursorStmt);

		    /* from PORTAL name */
		    /*
		     *  15 august 1991 -- since 3.0 postgres does locking
		     *  right, we discovered that portals were violating
		     *  locking protocol.  portal locks cannot span xacts.
		     *  as a short-term fix, we installed the check here. 
		     *				-- mao
		     */
		    if (!IsTransactionBlock())
			elog(WARN, "Named portals may only be used in begin/end transaction blocks.");

		    n->portalname = yypvt[-9].str;
		    n->binary = yypvt[-8].boolean;
		    n->unique = yypvt[-4].str;
		    n->targetList = yypvt[-3].list;
		    n->fromClause = yypvt[-2].list;
		    n->whereClause = yypvt[-1].node;
		    n->orderClause = yypvt[-0].list;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 199:
{
		    RetrieveStmt *n = makeNode(RetrieveStmt);
		    n->unique = yypvt[-7].str;
		    n->targetList = yypvt[-6].list;
		    n->into = yypvt[-5].str;
		    n->fromClause = yypvt[-4].list;
		    n->whereClause = yypvt[-3].node;
		    n->groupClause = yypvt[-2].list;
		    n->havingClause = yypvt[-1].node;
		    n->orderClause = yypvt[-0].list;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 200:
{  yyval.str= yypvt[-0].str;  /* should check for archive level */  } /*NOTREACHED*/ break;
case 201:
{  yyval.str = NULL;  } /*NOTREACHED*/ break;
case 202:
{ yyval.str = "*"; } /*NOTREACHED*/ break;
case 203:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 204:
{ yyval.str = NULL;} /*NOTREACHED*/ break;
case 205:
{ yyval.list = yypvt[-0].list; } /*NOTREACHED*/ break;
case 206:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 207:
{ yyval.list = lcons(yypvt[-0].sortby, NIL); } /*NOTREACHED*/ break;
case 208:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].sortby); } /*NOTREACHED*/ break;
case 209:
{ 
		    yyval.sortby = makeNode(SortBy);
		    yyval.sortby->name = yypvt[-1].str;
		    yyval.sortby->useOp = yypvt[-0].str;
		} /*NOTREACHED*/ break;
case 210:
{ /* i had to do this since a bug in yacc wouldn't catch */
                  /* this syntax error - ron choi 4/11/91 */
                  yyerror("syntax error: use \"sort by attribute_name\"");
                } /*NOTREACHED*/ break;
case 211:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 212:
{ yyval.str = "<"; } /*NOTREACHED*/ break;
case 213:
{ yyval.str = ">"; } /*NOTREACHED*/ break;
case 214:
{ yyval.str = "<"; /*default*/ } /*NOTREACHED*/ break;
case 215:
{ yyval.list = yypvt[-0].list; } /*NOTREACHED*/ break;
case 216:
{ yyval.list = lcons(yypvt[-0].ielem,NIL); } /*NOTREACHED*/ break;
case 217:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].ielem); } /*NOTREACHED*/ break;
case 218:
{ yyval.list = lcons(yypvt[-0].ielem, NIL); } /*NOTREACHED*/ break;
case 219:
{
		    yyval.ielem = makeNode(IndexElem);
		    yyval.ielem->name = yypvt[-4].str;
		    yyval.ielem->args = yypvt[-2].list;
		    yyval.ielem->class = yypvt[-0].str;
		} /*NOTREACHED*/ break;
case 220:
{
		    yyval.ielem = makeNode(IndexElem);
		    yyval.ielem->name = yypvt[-1].str;
		    yyval.ielem->args = NIL;
		    yyval.ielem->class = yypvt[-0].str;
		} /*NOTREACHED*/ break;
case 222:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 223:
{ yyval.str = NULL; } /*NOTREACHED*/ break;
case 224:
{ yyval.boolean = TRUE; } /*NOTREACHED*/ break;
case 225:
{ yyval.boolean = FALSE; } /*NOTREACHED*/ break;
case 227:
{ yyval.list=lcons(makeString(yypvt[-0].str),NIL); } /*NOTREACHED*/ break;
case 228:
{ yyval.list=lappend(yypvt[-2].list,makeString(yypvt[-0].str)); } /*NOTREACHED*/ break;
case 229:
{ yyval.list = yypvt[-0].list; } /*NOTREACHED*/ break;
case 230:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 231:
{ yyval.list = lcons(yypvt[-0].node, NIL); } /*NOTREACHED*/ break;
case 232:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].node); } /*NOTREACHED*/ break;
case 233:
{ 
		   Ident *n = makeNode(Ident);
		   n->name = yypvt[-0].str;
		   n->indirection = NULL;
		   yyval.node = (Node*)n;
		} /*NOTREACHED*/ break;
case 234:
{
		   yyval.node = (Node*)yypvt[-0].attr;
		} /*NOTREACHED*/ break;
case 235:
{ yyval.node = yypvt[-0].node; } /*NOTREACHED*/ break;
case 236:
{ yyval.node = NULL; } /*NOTREACHED*/ break;
case 237:
{ yyval.list = yypvt[-0].list; } /*NOTREACHED*/ break;
case 238:
{ yyval.list = NIL; } /*NOTREACHED*/ break;
case 239:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].range); } /*NOTREACHED*/ break;
case 240:
{ yyval.list = lcons(yypvt[-0].range, NIL); } /*NOTREACHED*/ break;
case 241:
{
		    yyval.range = makeNode(RangeVar);
		    yyval.range->relExpr = yypvt[-2].relexp;
		    yyval.range->name = yypvt[-0].str;
		} /*NOTREACHED*/ break;
case 242:
{
		    yyval.range = makeNode(RangeVar);
		    yyval.range->relExpr = yypvt[-1].relexp;
		    yyval.range->name = yypvt[-0].str;
		} /*NOTREACHED*/ break;
case 243:
{
		    yyval.range = makeNode(RangeVar);
		    yyval.range->relExpr = yypvt[-0].relexp;
		    yyval.range->name = NULL;
		} /*NOTREACHED*/ break;
case 244:
{ yyval.node = yypvt[-0].node; } /*NOTREACHED*/ break;
case 245:
{ yyval.node = NULL;  /* no qualifiers */ } /*NOTREACHED*/ break;
case 246:
{ 
		    /* normal relations */
		    yyval.relexp = makeNode(RelExpr);
		    yyval.relexp->relname = yypvt[-0].str;
		    yyval.relexp->inh = FALSE;
		    yyval.relexp->timeRange = NULL;
		} /*NOTREACHED*/ break;
case 247:
{ 
		    /* inheiritance query */
		    yyval.relexp = makeNode(RelExpr);
		    yyval.relexp->relname = yypvt[-1].str;
		    yyval.relexp->inh = TRUE;
		    yyval.relexp->timeRange = NULL;
		} /*NOTREACHED*/ break;
case 248:
{ 
		    /* time-qualified query */
		    yyval.relexp = makeNode(RelExpr);
		    yyval.relexp->relname = yypvt[-1].str;
		    yyval.relexp->inh = FALSE;
		    yyval.relexp->timeRange = yypvt[-0].trange;
		} /*NOTREACHED*/ break;
case 249:
{ 
		    yyval.trange = makeNode(TimeRange);
		    yyval.trange->startDate = yypvt[-3].str;
		    yyval.trange->endDate = yypvt[-1].str;
		} /*NOTREACHED*/ break;
case 250:
{ 
		    yyval.trange = makeNode(TimeRange);
		    yyval.trange->startDate = yypvt[-1].str;
		    yyval.trange->endDate = NULL;
		} /*NOTREACHED*/ break;
case 252:
{ yyval.str = "epoch"; } /*NOTREACHED*/ break;
case 254:
{ yyval.str = "now"; } /*NOTREACHED*/ break;
case 255:
{  yyval.list = lcons(makeInteger(-1), yypvt[-0].list); } /*NOTREACHED*/ break;
case 256:
{  yyval.list = lcons(makeInteger(yypvt[-2].ival), yypvt[-0].list); } /*NOTREACHED*/ break;
case 257:
{  yyval.list = NIL; } /*NOTREACHED*/ break;
case 258:
{  yyval.list = lcons(makeInteger(-1), yypvt[-0].list); } /*NOTREACHED*/ break;
case 259:
{  yyval.list = lcons(makeInteger(yypvt[-2].ival), yypvt[-0].list); } /*NOTREACHED*/ break;
case 260:
{  yyval.list = NIL; } /*NOTREACHED*/ break;
case 261:
{
		    yyval.typnam = makeNode(TypeName);
		    yyval.typnam->name = yypvt[-0].str;

		    /* Is this the name of a complex type? If so, implement
		     * it as a set.
		     */
		    if (!strcmp(saved_relname, yypvt[-0].str)) {
		 	/* This attr is the same type as the relation 
			 * being defined. The classic example: create
			 * emp(name=text,mgr=emp)
			 */
			yyval.typnam->setof = TRUE;
		    }else if (get_typrelid((Type)type(yypvt[-0].str))
				!= InvalidOid) {
			 /* (Eventually add in here that the set can only 
			  * contain one element.)
			  */
			yyval.typnam->setof = TRUE;
	    	    } else {
			yyval.typnam->setof = FALSE;
		    }
		} /*NOTREACHED*/ break;
case 262:
{
		    yyval.typnam = makeNode(TypeName);
		    yyval.typnam->name = yypvt[-0].str;
		    yyval.typnam->setof = TRUE;
		} /*NOTREACHED*/ break;
case 263:
{ 
		    yyval.typnam = yypvt[-1].typnam;
		    yyval.typnam->arrayBounds = yypvt[-0].list;
		} /*NOTREACHED*/ break;
case 264:
{
		    yypvt[-1].attr->indirection = yypvt[-0].list;
		    yyval.node = (Node *)yypvt[-1].attr;
		} /*NOTREACHED*/ break;
case 265:
{   yyval.node = yypvt[-0].node;  } /*NOTREACHED*/ break;
case 266:
{   yyval.node = makeA_Expr(OP, "-", NULL, yypvt[-0].node); } /*NOTREACHED*/ break;
case 267:
{   yyval.node = makeA_Expr(OP, "+", yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 268:
{   yyval.node = makeA_Expr(OP, "-", yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 269:
{   yyval.node = makeA_Expr(OP, "/", yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 270:
{   yyval.node = makeA_Expr(OP, "*", yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 271:
{   yyval.node = makeA_Expr(OP, "<", yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 272:
{   yyval.node = makeA_Expr(OP, ">", yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 273:
{   yyval.node = makeA_Expr(OP, "=", yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 274:
{   yyval.node = makeA_Expr(OP, ":", NULL, yypvt[-0].node); } /*NOTREACHED*/ break;
case 275:
{   yyval.node = makeA_Expr(OP, ";", NULL, yypvt[-0].node); } /*NOTREACHED*/ break;
case 276:
{   yyval.node = makeA_Expr(OP, "|", NULL, yypvt[-0].node); } /*NOTREACHED*/ break;
case 277:
{ 
		    /* AexprConst can be either A_Const or ParamNo */
		    if (nodeTag(yypvt[-2].node) == T_A_Const) {
			((A_Const *)yypvt[-2].node)->typename = yypvt[-0].typnam;
		    }else {
			((ParamNo *)yypvt[-2].node)->typename = yypvt[-0].typnam;
		    }
		    yyval.node = (Node *)yypvt[-2].node;
		} /*NOTREACHED*/ break;
case 278:
{   yyval.node = yypvt[-1].node; } /*NOTREACHED*/ break;
case 279:
{   yyval.node = makeA_Expr(OP, yypvt[-1].str, yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 280:
{   yyval.node = makeA_Expr(OP, yypvt[-1].str, NULL, yypvt[-0].node); } /*NOTREACHED*/ break;
case 281:
{   yyval.node = makeA_Expr(OP, yypvt[-0].str, yypvt[-1].node, NULL); } /*NOTREACHED*/ break;
case 282:
{   /* could be a column name or a relation_name */
		    Ident *n = makeNode(Ident);
		    n->name = yypvt[-0].str;
		    n->indirection = NULL;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 283:
{
		    FuncCall *n = makeNode(FuncCall);
		    Ident *star = makeNode(Ident);

		    /* cheap hack for aggregate (eg. count) */
		    star->name = "oid"; 
		    n->funcname = yypvt[-3].str;
		    n->args = lcons(star, NIL);
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 284:
{
		    FuncCall *n = makeNode(FuncCall);
		    n->funcname = yypvt[-2].str;
		    n->args = NIL;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 285:
{
		    FuncCall *n = makeNode(FuncCall);
		    n->funcname = yypvt[-3].str;
		    n->args = yypvt[-1].list;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 286:
{   yyval.node = makeA_Expr(ISNULL, NULL, yypvt[-1].node, NULL); } /*NOTREACHED*/ break;
case 287:
{   yyval.node = makeA_Expr(NOTNULL, NULL, yypvt[-1].node, NULL); } /*NOTREACHED*/ break;
case 288:
{   yyval.node = makeA_Expr(AND, NULL, yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 289:
{   yyval.node = makeA_Expr(OR, NULL, yypvt[-2].node, yypvt[-0].node); } /*NOTREACHED*/ break;
case 290:
{   yyval.node = makeA_Expr(NOT, NULL, NULL, yypvt[-0].node); } /*NOTREACHED*/ break;
case 291:
{
		    A_Indices *ai = makeNode(A_Indices);
		    ai->lidx = NULL;
		    ai->uidx = yypvt[-2].node;
		    yyval.list = lcons(ai, yypvt[-0].list);
		} /*NOTREACHED*/ break;
case 292:
{
		    A_Indices *ai = makeNode(A_Indices);
		    ai->lidx = yypvt[-4].node;
		    ai->uidx = yypvt[-2].node;
		    yyval.list = lcons(ai, yypvt[-0].list);
		} /*NOTREACHED*/ break;
case 293:
{   yyval.list = NIL; } /*NOTREACHED*/ break;
case 294:
{ yyval.list = lcons(yypvt[-0].node, NIL); } /*NOTREACHED*/ break;
case 295:
{ yyval.list = lappend(yypvt[-2].list, yypvt[-0].node); } /*NOTREACHED*/ break;
case 296:
{
		    yyval.attr = makeNode(Attr);
		    yyval.attr->relname = yypvt[-2].str;
		    yyval.attr->paramNo = NULL;
		    yyval.attr->attrs = yypvt[-0].list;
		    yyval.attr->indirection = NULL;
		} /*NOTREACHED*/ break;
case 297:
{
		    yyval.attr = makeNode(Attr);
		    yyval.attr->relname = NULL;
		    yyval.attr->paramNo = yypvt[-2].paramno;
		    yyval.attr->attrs = yypvt[-0].list;
		    yyval.attr->indirection = NULL;
		} /*NOTREACHED*/ break;
case 298:
{ yyval.list = lcons(makeString(yypvt[-0].str), NIL); } /*NOTREACHED*/ break;
case 299:
{ yyval.list = lappend(yypvt[-2].list, makeString(yypvt[-0].str)); } /*NOTREACHED*/ break;
case 300:
{ yyval.list = lappend(yypvt[-2].list, makeString("*")); } /*NOTREACHED*/ break;
case 301:
{   yyval.list = lappend(yypvt[-2].list,yypvt[-0].target);  } /*NOTREACHED*/ break;
case 302:
{   yyval.list = lcons(yypvt[-0].target, NIL);  } /*NOTREACHED*/ break;
case 303:
{
		    ResTarget *rt = makeNode(ResTarget);
		    Attr *att = makeNode(Attr);
		    att->relname = "*";
		    att->paramNo = NULL;
		    att->attrs = NULL;
		    att->indirection = NIL;
		    rt->name = NULL;
		    rt->indirection = NULL;
		    rt->val = (Node *)att;
		    yyval.list = lcons(rt, NIL);
		} /*NOTREACHED*/ break;
case 304:
{
		    yyval.target = makeNode(ResTarget);
		    yyval.target->name = yypvt[-3].str;
		    yyval.target->indirection = yypvt[-2].list;
		    yyval.target->val = (Node *)yypvt[-0].node;
		} /*NOTREACHED*/ break;
case 305:
{
		    yyval.target = makeNode(ResTarget);
		    yyval.target->name = NULL;
		    yyval.target->indirection = yypvt[-0].list;
		    yyval.target->val = (Node *)yypvt[-1].attr;
		} /*NOTREACHED*/ break;
case 306:
{   
		    Attr *att = makeNode(Attr);
		    att->relname = yypvt[-2].str;
		    att->paramNo = NULL;
		    att->attrs = lcons(makeString("*"), NIL);
		    att->indirection = NIL;
		    yyval.target = makeNode(ResTarget);
		    yyval.target->name = NULL;
		    yyval.target->indirection = NULL;
		    yyval.target->val = (Node *)att;
		} /*NOTREACHED*/ break;
case 307:
{   yyval.list = lappend(yypvt[-2].list, yypvt[-0].target);  } /*NOTREACHED*/ break;
case 308:
{   yyval.list = lcons(yypvt[-0].target, NIL);  } /*NOTREACHED*/ break;
case 309:
{
		    ResTarget *rt = makeNode(ResTarget);
		    Attr *att = makeNode(Attr);
		    att->relname = "*";
		    att->paramNo = NULL;
		    att->attrs = NULL;
		    att->indirection = NIL;
		    rt->name = NULL;
		    rt->indirection = NULL;
		    rt->val = (Node *)att;
		    yyval.list = lcons(rt, NIL);
		} /*NOTREACHED*/ break;
case 310:
{
		    yyval.target = makeNode(ResTarget);
		    yyval.target->name = yypvt[-0].str;
		    yyval.target->indirection = NULL;
		    yyval.target->val = (Node *)yypvt[-2].node;
		} /*NOTREACHED*/ break;
case 311:
{
		    yyval.target = makeNode(ResTarget);
		    yyval.target->name = NULL;
		    yyval.target->indirection = NULL;
		    yyval.target->val = (Node *)yypvt[-0].node;
		} /*NOTREACHED*/ break;
case 312:
{
		    Attr *att = makeNode(Attr);
		    att->relname = yypvt[-2].str;
		    att->paramNo = NULL;
		    att->attrs = lcons(makeString("*"), NIL);
		    att->indirection = NIL;
		    yyval.target = makeNode(ResTarget);
		    yyval.target->name = NULL;
		    yyval.target->indirection = NULL;
		    yyval.target->val = (Node *)att;
		} /*NOTREACHED*/ break;
case 313:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 314:
{ yyval.str = NULL; } /*NOTREACHED*/ break;
case 315:
{
                   yyval.str = yypvt[-0].str;
                   strcpy(saved_relname, yypvt[-0].str);
	        } /*NOTREACHED*/ break;
case 316:
{
		    /* disallow refs to magic system tables */
 		    if (namestrcmp(Name_pg_log, yypvt[-0].str) == 0
 		       || namestrcmp(Name_pg_variable, yypvt[-0].str) == 0
 		       || namestrcmp(Name_pg_time, yypvt[-0].str) == 0
 		       || namestrcmp(Name_pg_magic, yypvt[-0].str) == 0) {
			elog(WARN, "%s cannot be accessed by users", yypvt[-0].str);
		    } else {
			yyval.str = yypvt[-0].str;
		    }
		    strcpy(saved_relname, yypvt[-0].str);
		} /*NOTREACHED*/ break;
case 317:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 318:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 319:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 320:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 321:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 322:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 323:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 324:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 325:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 326:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 327:
{  
		    A_Const *n = makeNode(A_Const);
		    n->val.type = T_Integer;
		    n->val.val.ival = yypvt[-0].ival;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 328:
{  
		    A_Const *n = makeNode(A_Const);
		    n->val.type = T_Float;
		    n->val.val.dval = yypvt[-0].dval;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 329:
{  
		    A_Const *n = makeNode(A_Const);
		    n->val.type = T_String;
		    n->val.val.str = yypvt[-0].str;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 330:
{   yyval.node = (Node *)yypvt[-0].paramno;  } /*NOTREACHED*/ break;
case 331:
{	
		    A_Const *n = makeNode(A_Const);
		    n->val.type = T_Null;
		    yyval.node = (Node *)n;
		} /*NOTREACHED*/ break;
case 332:
{
		    yyval.paramno = makeNode(ParamNo);
		    yyval.paramno->number = yypvt[-0].ival;
		} /*NOTREACHED*/ break;
case 333:
{ yyval.value = makeInteger(yypvt[-0].ival); } /*NOTREACHED*/ break;
case 334:
{ yyval.value = makeFloat(yypvt[-0].dval); } /*NOTREACHED*/ break;
case 335:
{ yyval.ival = yypvt[-0].ival; } /*NOTREACHED*/ break;
case 336:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 337:
{ yyval.str = yypvt[-0].str; } /*NOTREACHED*/ break;
case 338:
{ 
		    if (QueryIsRule)
			yyval.str = "*CURRENT*";
		    else 
			elog(WARN,"CURRENT used in non-rule query");
		} /*NOTREACHED*/ break;
case 339:
{ 
		    if (QueryIsRule)
			yyval.str = "*NEW*";
		    else 
			elog(WARN,"NEW used in non-rule query"); 
		} /*NOTREACHED*/ break;
}


	goto yystack;		/* reset registers in driver code */
}
