
/*-------------------------------------------------------------------------
 *
 *    yacc parser grammer for the "backend" initialization program.
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *
 *-------------------------------------------------------------------------
 */
#include "access/heapam.h"
#include "bootstrap/bootstrap.h"
#include "utils/portal.h" 
#include "storage/smgr.h" 
#include "nodes/pg_list.h"
#include "catalog/catalog.h"
#include "catalog/catname.h"
#include "catalog/index.h"
#include "commands/rename.h"
#include "access/transam.h"
#include "access/xact.h"


#undef BOOTSTRAP

#define TRUE 1
#define FALSE 0

#define DO_QUERY(query) { StartTransactionCommand();\
			  query;\
			  CommitTransactionCommand();\
			  if (!Quiet) { EMITPROMPT; }\
			}

#define DO_START { StartTransactionCommand();\
		 }

#define DO_END   { CommitTransactionCommand();\
		   if (!Quiet) { EMITPROMPT; }\
		   fflush(stdout); \
		 }

int num_tuples_read = 0;
extern int DebugMode;
extern int Quiet;
static Oid objectid;

# define OPEN 257
# define XCLOSE 258
# define XCREATE 259
# define P_RELN 260
# define INSERT_TUPLE 261
# define QUIT 262
# define ID 263
# define STRING 264
# define FLOAT 265
# define INT 266
# define XDEFINE 267
# define MACRO 268
# define XDECLARE 269
# define INDEX 270
# define ON 271
# define USING 272
# define XBUILD 273
# define INDICES 274
# define COMMA 275
# define COLON 276
# define EQUALS 277
# define LPAREN 278
# define RPAREN 279
# define AS 280
# define XIN 281
# define XTO 282
# define XDESTROY 283
# define XRENAME 284
# define RELATION 285
# define ATTR 286
# define ADD 287
# define DISPLAY 288
# define OBJ_ID 289
# define SHOW 290
# define BOOTSTRAP 291
# define NULLVAL 292
# define low 293
# define high 294
#define Int_yyclearin Int_yychar = -1
#define Int_yyerrok Int_yyerrflag = 0
extern int Int_yychar;
extern int Int_yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE long
#endif
YYSTYPE Int_yylval, Int_yyval;
typedef int Int_yytabelem;
# define YYERRCODE 256




static Int_yytabelem Int_yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 63
# define YYLAST 169
static Int_yytabelem Int_yyact[]={

    17,    18,    20,    19,    22,    23,    39,    43,    45,    46,
    28,    92,    24,   108,    71,    49,    29,   107,    35,    69,
    80,    81,    68,    36,    62,   102,    21,    25,    61,    97,
    90,    30,    50,    31,    88,    35,    35,    80,    81,   104,
    36,    36,    98,    65,    64,    70,    63,    79,    56,    35,
    62,    34,    48,    91,    36,    67,    35,    44,    47,    53,
    41,    36,    76,    52,    79,    51,     3,    78,    27,    32,
    26,   105,   100,    99,    75,    55,    42,    33,    37,    93,
    74,    40,    38,    16,    15,    14,    13,    12,    11,    10,
     9,     8,     7,     6,     5,     4,     2,     1,    54,     0,
     0,     0,     0,     0,    57,    58,    59,    60,     0,     0,
     0,     0,     0,     0,     0,     0,    66,     0,     0,     0,
     0,     0,     0,    73,     0,    77,    72,    82,    83,    84,
    85,    86,     0,     0,     0,    77,     0,     0,    89,     0,
    87,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    77,    95,    96,    94,     0,     0,     0,     0,   101,     0,
   103,     0,     0,     0,   106,     0,     0,     0,   109 };
static Int_yytabelem Int_yypact[]={

  -257, -1000,  -257, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -227,  -207, -1000,
  -285,  -214,  -282, -1000,  -213,  -277, -1000, -1000,  -210,  -222,
  -253, -1000, -1000, -1000,  -207, -1000, -1000, -1000,  -207, -1000,
 -1000, -1000, -1000,  -229,  -207,  -207,  -207,  -207, -1000, -1000,
 -1000,  -251, -1000,  -231,  -234,  -235,  -207,  -216,  -258,  -261,
  -232,  -266,  -207,  -207, -1000,  -228, -1000,  -207,  -207,  -207,
  -207,  -207, -1000, -1000,  -207,  -245, -1000, -1000, -1000, -1000,
 -1000, -1000,  -219, -1000,  -270, -1000, -1000,  -225, -1000, -1000,
  -228,  -207,  -207,  -250, -1000,  -236, -1000, -1000,  -207,  -254,
  -207,  -239, -1000, -1000,  -207,  -262, -1000, -1000,  -207, -1000 };
static Int_yytabelem Int_yypgo[]={

     0,    97,    96,    66,    95,    94,    93,    92,    91,    90,
    89,    88,    87,    86,    85,    84,    83,    59,    65,    82,
    80,    79,    76,    75,    74,    73,    72,    71,    70,    68,
    63,    62,    67 };
static Int_yytabelem Int_yyr1[]={

     0,     1,     1,     2,     2,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     4,     4,
     5,     5,     6,    20,    21,     7,     8,     8,    23,     9,
    10,    11,    16,    25,    26,    26,    27,    27,    12,    13,
    14,    14,    28,    29,    29,    15,    19,    19,    18,    18,
    30,    22,    22,    24,    24,    24,    31,    31,    31,    17,
    17,    32,    32 };
static Int_yytabelem Int_yyr2[]={

     0,     2,     0,     2,     4,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     5,    13,
     5,     3,     3,     1,     1,    17,     5,     5,     1,    13,
     3,    21,     5,     5,     3,     9,     3,     7,    11,    15,
     2,     2,     5,     5,     3,    11,     3,     1,     2,     6,
     7,     7,     1,     2,     4,     6,     3,     3,     3,     3,
     3,     3,     3 };
static Int_yytabelem Int_yychk[]={

 -1000,    -1,    -2,    -3,    -4,    -5,    -6,    -7,    -8,    -9,
   -10,   -11,   -12,   -13,   -14,   -15,   -16,   257,   258,   260,
   259,   283,   261,   262,   269,   284,   -28,   -29,   267,   273,
   288,   290,    -3,   -17,   278,   263,   268,   -17,   -19,   291,
   -17,   274,   -22,   289,   270,   285,   286,   268,   274,   268,
   285,   -18,   -30,   -17,   -17,   -23,   277,   -17,   -17,   -17,
   -17,   279,   275,   277,   278,   278,   -17,   271,   280,   280,
   277,   280,   -30,   -17,   -20,   -24,   -31,   -17,   -32,   292,
   265,   266,   -17,   -17,   -17,   -17,   -17,   -18,   279,   -31,
   275,   272,   281,   -21,   -31,   -17,   -17,   279,   278,   -25,
   -26,   -17,   279,   -17,   278,   -27,   -17,   279,   275,   -17 };
static Int_yytabelem Int_yydef[]={

     2,    -2,     1,     3,     5,     6,     7,     8,     9,    10,
    11,    12,    13,    14,    15,    16,    17,     0,    21,    22,
    47,     0,    52,    30,     0,     0,    40,    41,     0,     0,
     0,    44,     4,    18,     0,    59,    60,    20,     0,    46,
    26,    27,    28,     0,     0,     0,     0,     0,    32,    42,
    43,     0,    48,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    23,     0,    51,     0,     0,     0,
     0,     0,    49,    50,     0,     0,    53,    56,    57,    58,
    61,    62,     0,    38,     0,    45,    19,    24,    29,    54,
     0,     0,     0,     0,    55,     0,    39,    25,     0,     0,
     0,    34,    31,    33,     0,     0,    36,    35,     0,    37 };
typedef struct { char *t_name; int t_val; } Int_yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

Int_yytoktype Int_yytoks[] =
{
	"OPEN",	257,
	"XCLOSE",	258,
	"XCREATE",	259,
	"P_RELN",	260,
	"INSERT_TUPLE",	261,
	"QUIT",	262,
	"ID",	263,
	"STRING",	264,
	"FLOAT",	265,
	"INT",	266,
	"XDEFINE",	267,
	"MACRO",	268,
	"XDECLARE",	269,
	"INDEX",	270,
	"ON",	271,
	"USING",	272,
	"XBUILD",	273,
	"INDICES",	274,
	"COMMA",	275,
	"COLON",	276,
	"EQUALS",	277,
	"LPAREN",	278,
	"RPAREN",	279,
	"AS",	280,
	"XIN",	281,
	"XTO",	282,
	"XDESTROY",	283,
	"XRENAME",	284,
	"RELATION",	285,
	"ATTR",	286,
	"ADD",	287,
	"DISPLAY",	288,
	"OBJ_ID",	289,
	"SHOW",	290,
	"BOOTSTRAP",	291,
	"NULLVAL",	292,
	"low",	293,
	"high",	294,
	"-unknown-",	-1	/* ends search */
};

char * Int_yyreds[] =
{
	"-no such reduction-",
      "TopLevel : Queries",
      "TopLevel : /* empty */",
      "Queries : Query",
      "Queries : Queries Query",
      "Query : OpenStmt",
      "Query : CloseStmt",
      "Query : PrintStmt",
      "Query : CreateStmt",
      "Query : DestroyStmt",
      "Query : InsertStmt",
      "Query : QuitStmt",
      "Query : DeclareIndexStmt",
      "Query : RenameRelnStmt",
      "Query : RenameAttrStmt",
      "Query : DisplayStmt",
      "Query : MacroDefStmt",
      "Query : BuildIndsStmt",
      "OpenStmt : OPEN ident",
      "OpenStmt : OPEN LPAREN typelist RPAREN AS ident",
      "CloseStmt : XCLOSE ident",
      "CloseStmt : XCLOSE",
      "PrintStmt : P_RELN",
      "CreateStmt : XCREATE optbootstrap ident LPAREN",
      "CreateStmt : XCREATE optbootstrap ident LPAREN typelist",
      "CreateStmt : XCREATE optbootstrap ident LPAREN typelist RPAREN",
      "DestroyStmt : XDESTROY ident",
      "DestroyStmt : XDESTROY INDICES",
      "InsertStmt : INSERT_TUPLE optoideq",
      "InsertStmt : INSERT_TUPLE optoideq LPAREN tuplelist RPAREN",
      "QuitStmt : QUIT",
      "DeclareIndexStmt : XDECLARE INDEX ident ON ident USING ident LPAREN index_params RPAREN",
      "BuildIndsStmt : XBUILD INDICES",
      "index_params : index_on ident",
      "index_on : ident",
      "index_on : ident LPAREN arg_list RPAREN",
      "arg_list : ident",
      "arg_list : arg_list COMMA ident",
      "RenameRelnStmt : XRENAME RELATION ident AS ident",
      "RenameAttrStmt : XRENAME ATTR ident AS ident XIN ident",
      "DisplayStmt : DisplayMacro",
      "DisplayStmt : DisplayReln",
      "DisplayMacro : DISPLAY MACRO",
      "DisplayReln : DISPLAY RELATION",
      "DisplayReln : SHOW",
      "MacroDefStmt : XDEFINE MACRO ident EQUALS ident",
      "optbootstrap : BOOTSTRAP",
      "optbootstrap : /* empty */",
      "typelist : typething",
      "typelist : typelist COMMA typething",
      "typething : ident EQUALS ident",
      "optoideq : OBJ_ID EQUALS ident",
      "optoideq : /* empty */",
      "tuplelist : tuple",
      "tuplelist : tuplelist tuple",
      "tuplelist : tuplelist COMMA tuple",
      "tuple : ident",
      "tuple : const",
      "tuple : NULLVAL",
      "ident : ID",
      "ident : MACRO",
      "const : FLOAT",
      "const : INT",
};
#endif /* YYDEBUG */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1, 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto Int_yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( Int_yychar >= 0 || ( Int_yyr2[ Int_yytmp ] >> 1 ) != 1 )\
	{\
		Int_yyerror( "syntax error - cannot backup" );\
		goto Int_yyerrlab;\
	}\
	Int_yychar = newtoken;\
	Int_yystate = *Int_yyps;\
	Int_yylval = newvalue;\
	goto Int_yynewstate;\
}
#define YYRECOVERING()	(!!Int_yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int Int_yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*Int_yyf[])(); \
			register int Int_yyret; \
			if (Int_yyf[Int_yytmp]) \
			    if ((Int_yyret=(*Int_yyf[Int_yytmp])()) == -2) \
				    goto Int_yyerrlab; \
				else if (Int_yyret>=0) return(Int_yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE Int_yyv[ YYMAXDEPTH ];	/* value stack */
int Int_yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *Int_yypv;			/* top of value stack */
YYSTYPE *Int_yypvt;			/* top of value stack for $vars */
int *Int_yyps;			/* top of state stack */

int Int_yystate;			/* current state */
int Int_yytmp;			/* extra var (lasts between blocks) */

int Int_yynerrs;			/* number of errors */
int Int_yyerrflag;			/* error recovery flag */
int Int_yychar;			/* current input token number */



/*
** Int_yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
Int_yyparse()
{
	/*
	** Initialize externals - Int_yyparse may be called more than once
	*/
	Int_yypv = &Int_yyv[-1];
	Int_yyps = &Int_yys[-1];
	Int_yystate = 0;
	Int_yytmp = 0;
	Int_yynerrs = 0;
	Int_yyerrflag = 0;
	Int_yychar = -1;

	goto Int_yystack;
	{
		register YYSTYPE *Int_yy_pv;	/* top of value stack */
		register int *Int_yy_ps;		/* top of state stack */
		register int Int_yy_state;		/* current state */
		register int  Int_yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	Int_yynewstate:
		Int_yy_pv = Int_yypv;
		Int_yy_ps = Int_yyps;
		Int_yy_state = Int_yystate;
		goto Int_yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	Int_yystack:
		Int_yy_pv = Int_yypv;
		Int_yy_ps = Int_yyps;
		Int_yy_state = Int_yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	Int_yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( Int_yydebug )
		{
			register int Int_yy_i;

			printf( "State %d, token ", Int_yy_state );
			if ( Int_yychar == 0 )
				printf( "end-of-file\n" );
			else if ( Int_yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( Int_yy_i = 0; Int_yytoks[Int_yy_i].t_val >= 0;
					Int_yy_i++ )
				{
					if ( Int_yytoks[Int_yy_i].t_val == Int_yychar )
						break;
				}
				printf( "%s\n", Int_yytoks[Int_yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++Int_yy_ps >= &Int_yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			Int_yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*Int_yy_ps = Int_yy_state;
		*++Int_yy_pv = Int_yyval;

		/*
		** we have a new state - find out what to do
		*/
	Int_yy_newstate:
		if ( ( Int_yy_n = Int_yypact[ Int_yy_state ] ) <= YYFLAG )
			goto Int_yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		Int_yytmp = Int_yychar < 0;
#endif
		if ( ( Int_yychar < 0 ) && ( ( Int_yychar = Int_yylex() ) < 0 ) )
			Int_yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( Int_yydebug && Int_yytmp )
		{
			register int Int_yy_i;

			printf( "Received token " );
			if ( Int_yychar == 0 )
				printf( "end-of-file\n" );
			else if ( Int_yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( Int_yy_i = 0; Int_yytoks[Int_yy_i].t_val >= 0;
					Int_yy_i++ )
				{
					if ( Int_yytoks[Int_yy_i].t_val == Int_yychar )
						break;
				}
				printf( "%s\n", Int_yytoks[Int_yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( Int_yy_n += Int_yychar ) < 0 ) || ( Int_yy_n >= YYLAST ) )
			goto Int_yydefault;
		if ( Int_yychk[ Int_yy_n = Int_yyact[ Int_yy_n ] ] == Int_yychar )	/*valid shift*/
		{
			Int_yychar = -1;
			Int_yyval = Int_yylval;
			Int_yy_state = Int_yy_n;
			if ( Int_yyerrflag > 0 )
				Int_yyerrflag--;
			goto Int_yy_stack;
		}

	Int_yydefault:
		if ( ( Int_yy_n = Int_yydef[ Int_yy_state ] ) == -2 )
		{
#if YYDEBUG
			Int_yytmp = Int_yychar < 0;
#endif
			if ( ( Int_yychar < 0 ) && ( ( Int_yychar = Int_yylex() ) < 0 ) )
				Int_yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( Int_yydebug && Int_yytmp )
			{
				register int Int_yy_i;

				printf( "Received token " );
				if ( Int_yychar == 0 )
					printf( "end-of-file\n" );
				else if ( Int_yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( Int_yy_i = 0;
						Int_yytoks[Int_yy_i].t_val >= 0;
						Int_yy_i++ )
					{
						if ( Int_yytoks[Int_yy_i].t_val
							== Int_yychar )
						{
							break;
						}
					}
					printf( "%s\n", Int_yytoks[Int_yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *Int_yyxi = Int_yyexca;

				while ( ( *Int_yyxi != -1 ) ||
					( Int_yyxi[1] != Int_yy_state ) )
				{
					Int_yyxi += 2;
				}
				while ( ( *(Int_yyxi += 2) >= 0 ) &&
					( *Int_yyxi != Int_yychar ) )
					;
				if ( ( Int_yy_n = Int_yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( Int_yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( Int_yyerrflag )
			{
			case 0:		/* new error */
				Int_yyerror( "syntax error" );
				goto skip_init;
			Int_yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				Int_yy_pv = Int_yypv;
				Int_yy_ps = Int_yyps;
				Int_yy_state = Int_yystate;
				Int_yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				Int_yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( Int_yy_ps >= Int_yys )
				{
					Int_yy_n = Int_yypact[ *Int_yy_ps ] + YYERRCODE;
					if ( Int_yy_n >= 0 && Int_yy_n < YYLAST &&
						Int_yychk[Int_yyact[Int_yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						Int_yy_state = Int_yyact[ Int_yy_n ];
						goto Int_yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( Int_yydebug )
						printf( _POP_, *Int_yy_ps,
							Int_yy_ps[-1] );
#	undef _POP_
#endif
					Int_yy_ps--;
					Int_yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( Int_yydebug )
				{
					register int Int_yy_i;

					printf( "Error recovery discards " );
					if ( Int_yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( Int_yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( Int_yy_i = 0;
							Int_yytoks[Int_yy_i].t_val >= 0;
							Int_yy_i++ )
						{
							if ( Int_yytoks[Int_yy_i].t_val
								== Int_yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							Int_yytoks[Int_yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( Int_yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				Int_yychar = -1;
				goto Int_yy_newstate;
			}
		}/* end if ( Int_yy_n == 0 ) */
		/*
		** reduction by production Int_yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( Int_yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				Int_yy_n, Int_yyreds[ Int_yy_n ] );
#endif
		Int_yytmp = Int_yy_n;			/* value to switch over */
		Int_yypvt = Int_yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using Int_yy_state here as temporary
		** register variable, but why not, if it works...
		** If Int_yyr2[ Int_yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto Int_yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int Int_yy_len = Int_yyr2[ Int_yy_n ];

			if ( !( Int_yy_len & 01 ) )
			{
				Int_yy_len >>= 1;
				Int_yyval = ( Int_yy_pv -= Int_yy_len )[1];	/* $$ = $1 */
				Int_yy_state = Int_yypgo[ Int_yy_n = Int_yyr1[ Int_yy_n ] ] +
					*( Int_yy_ps -= Int_yy_len ) + 1;
				if ( Int_yy_state >= YYLAST ||
					Int_yychk[ Int_yy_state =
					Int_yyact[ Int_yy_state ] ] != -Int_yy_n )
				{
					Int_yy_state = Int_yyact[ Int_yypgo[ Int_yy_n ] ];
				}
				goto Int_yy_stack;
			}
			Int_yy_len >>= 1;
			Int_yyval = ( Int_yy_pv -= Int_yy_len )[1];	/* $$ = $1 */
			Int_yy_state = Int_yypgo[ Int_yy_n = Int_yyr1[ Int_yy_n ] ] +
				*( Int_yy_ps -= Int_yy_len ) + 1;
			if ( Int_yy_state >= YYLAST ||
				Int_yychk[ Int_yy_state = Int_yyact[ Int_yy_state ] ] != -Int_yy_n )
			{
				Int_yy_state = Int_yyact[ Int_yypgo[ Int_yy_n ] ];
			}
		}
					/* save until reenter driver code */
		Int_yystate = Int_yy_state;
		Int_yyps = Int_yy_ps;
		Int_yypv = Int_yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(Int_yytmp){

case 18:
{ 
		    DO_START;
		    boot_openrel(LexIDStr(Int_yypvt[-0]));
		    DO_END; 
		} /*NOTREACHED*/ break;
case 19:
{ 
		    if (!Quiet) putchar('\n');
		    DO_START;
		    createrel(LexIDStr(Int_yypvt[-0]));
		    DO_END;
		} /*NOTREACHED*/ break;
case 20:
{
		    DO_START;
		    closerel(LexIDStr(Int_yypvt[-0]));
		    DO_END;
		} /*NOTREACHED*/ break;
case 21:
{
		    DO_START;
		    closerel(NULL);
		    DO_END;
		} /*NOTREACHED*/ break;
case 22:
{
		    DO_START;
		    printrel();
		    DO_END;
		} /*NOTREACHED*/ break;
case 23:
{ 
		    DO_START; 
		    numattr=(int)0;
		} /*NOTREACHED*/ break;
case 24:
{ 
		    if (!Quiet) putchar('\n');
		    DO_END;
		} /*NOTREACHED*/ break;
case 25:
{ 
		    DO_START; 
		    if (Int_yypvt[-6]) {
			extern Relation reldesc;

			if (reldesc) {
			    puts("create bootstrap: Warning, open relation");
			    puts("exists, closing first");
			    closerel(NULL);
			}
			if (DebugMode)
			    puts("creating bootstrap relation");
			reldesc = heap_creatr(LexIDStr(Int_yypvt[-5]),
					      numattr,
					      DEFAULT_SMGR,
					      attrtypes);
			if (DebugMode)
			    puts("bootstrap relation created ok");
		    } else {
			Oid id;
			extern Oid heap_create();

			id = heap_create(LexIDStr(Int_yypvt[-5]),
					 'n',
					 numattr,
					 DEFAULT_SMGR,
					 attrtypes);
			if (!Quiet)
			    printf("CREATED relation %s with OID %d\n",
				   LexIDStr(Int_yypvt[-5]), id);
		    }
		    DO_END;
		    if (DebugMode)
			puts("Commit End");
		} /*NOTREACHED*/ break;
case 26:
{ DO_START; heap_destroy(LexIDStr(Int_yypvt[-0])); DO_END;} /*NOTREACHED*/ break;
case 27:
{
		    Relation rdesc;
		    HeapScanDesc sdesc;
		    HeapTuple htp;
		    Form_pg_class rp;

		    DO_START;
		    rdesc = heap_openr(RelationRelationName);
		    sdesc = heap_beginscan(rdesc,
					   0,
					   NowTimeQual,
					   (unsigned) 0,
					   (ScanKey) NULL);
		    while ((htp = heap_getnext(sdesc, 0,
					       (Buffer *) NULL))!=NULL) {
			rp = (Form_pg_class) GETSTRUCT(htp);
			if (issystem(rp->relname.data) &&
			    (rp->relkind == 'i')) {
			    if (!Quiet)
				fprintf(stderr, "Destroying %.*s...\n",
					NAMEDATALEN, rp->relname.data);
			    index_destroy(htp->t_oid);
			}
		    }
		    heap_endscan(sdesc);
		    heap_close(rdesc);
		    DO_END;
		} /*NOTREACHED*/ break;
case 28:
{ 
		    DO_START;
		    if (DebugMode)
		        printf("tuple %d<", Int_yypvt[-0]);
		    num_tuples_read = 0;
		} /*NOTREACHED*/ break;
case 29:
{
		    if (num_tuples_read != numattr)
		        elog(WARN,"incorrect number of values for tuple");
		    if (reldesc == (Relation)NULL) {
		        elog(WARN,"must OPEN RELATION before INSERT\n");
		        err();
		    }
		    if (DebugMode)
			puts("Insert Begin");
		    objectid = Int_yypvt[-4];
		    InsertOneTuple(objectid);
		    if (DebugMode)
			puts("Insert End");
		    if (!Quiet) { putchar('\n'); }
		    DO_END;
		    if (DebugMode)
			puts("Transaction End");
		} /*NOTREACHED*/ break;
case 30:
{
		  StartTransactionCommand();
		  StartPortalAllocMode(DefaultAllocMode, 0);
		  cleanup();
		} /*NOTREACHED*/ break;
case 31:
{
		  List *params;

		  DO_START;

		  params = lappend(NIL, (List*)Int_yypvt[-1]);
		  defineindex(LexIDStr(Int_yypvt[-5]), 
			      LexIDStr(Int_yypvt[-7]), 
			      LexIDStr(Int_yypvt[-3]),
			      params);
		  DO_END;
		} /*NOTREACHED*/ break;
case 32:
{ build_indices(); } /*NOTREACHED*/ break;
case 33:
{
		    IndexElem *n = (IndexElem*)Int_yypvt[-1];
		    n->class = LexIDStr(Int_yypvt[-0]);
		    Int_yyval = (YYSTYPE)n;
		} /*NOTREACHED*/ break;
case 34:
{
		    IndexElem *n = makeNode(IndexElem);
		    n->name = LexIDStr(Int_yypvt[-0]);
		    Int_yyval = (YYSTYPE)n;
		} /*NOTREACHED*/ break;
case 35:
{
		    IndexElem *n = makeNode(IndexElem);
		    n->name = LexIDStr(Int_yypvt[-3]);
		    n->args = (List*)Int_yypvt[-1];
		    Int_yyval = (YYSTYPE)n;
		} /*NOTREACHED*/ break;
case 36:
{
		  Int_yyval = (YYSTYPE)lappend(NIL, makeString(LexIDStr(Int_yypvt[-0])));
		} /*NOTREACHED*/ break;
case 37:
{
		  Int_yyval = (YYSTYPE)lappend((List*)Int_yypvt[-2], makeString(LexIDStr(Int_yypvt[-0])));
		} /*NOTREACHED*/ break;
case 38:
{
		    DO_START;
		    renamerel(LexIDStr(Int_yypvt[-2]), LexIDStr(Int_yypvt[-0]));
		    DO_END;
		} /*NOTREACHED*/ break;
case 39:
{ DO_START;
		  renameatt(LexIDStr(Int_yypvt[-0]), LexIDStr(Int_yypvt[-4]), LexIDStr(Int_yypvt[-2]),
			    (Name) NULL, 0);
		  DO_END;
		} /*NOTREACHED*/ break;
case 42:
{ 
		  DO_START;
		  printmacros(); 
		  DO_END;
		} /*NOTREACHED*/ break;
case 43:
{
		  DO_START;
		  boot_openrel(RelationRelationName->data);
		  printrel();
		  closerel(RelationRelationName->data);
		  DO_END;
		} /*NOTREACHED*/ break;
case 44:
{
		  DO_START;
		  printrel();
		  DO_END;
		} /*NOTREACHED*/ break;
case 45:
{ /* for now, simple subst only */
		  DO_START;
		  DefineMacro(Int_yypvt[-2],Int_yypvt[-0]);
		  DO_END;
		} /*NOTREACHED*/ break;
case 46:
{ Int_yyval = 1; } /*NOTREACHED*/ break;
case 47:
{ Int_yyval = 0; } /*NOTREACHED*/ break;
case 50:
{ 
		   if(++numattr > MAXATTR)
			elog(FATAL,"Too many attributes\n");
		   DefineAttr(LexIDStr(Int_yypvt[-2]),LexIDStr(Int_yypvt[-0]),numattr-1);
		   if (DebugMode)
		       printf("\n");
		} /*NOTREACHED*/ break;
case 51:
{ Int_yyval = atol(LexIDStr(Int_yypvt[-0])); 		} /*NOTREACHED*/ break;
case 52:
{ extern Oid newoid(); Int_yyval = newoid();	} /*NOTREACHED*/ break;
case 56:
{ InsertOneValue(objectid, LexIDStr(Int_yypvt[-0]), num_tuples_read++); } /*NOTREACHED*/ break;
case 57:
{ InsertOneValue(objectid, LexIDStr(Int_yypvt[-0]), num_tuples_read++); } /*NOTREACHED*/ break;
case 58:
{ InsertOneNull(num_tuples_read++); } /*NOTREACHED*/ break;
case 59:
{ Int_yyval=Int_yylval; } /*NOTREACHED*/ break;
case 60:
{ Int_yyval=Int_yylval; } /*NOTREACHED*/ break;
case 61:
{ Int_yyval=Int_yylval; } /*NOTREACHED*/ break;
case 62:
{ Int_yyval=Int_yylval; } /*NOTREACHED*/ break;
}


	goto Int_yystack;		/* reset registers in driver code */
}
