/*-------------------------------------------------------------------------
 *
 * libpq-fe.h--
 *    This file contains definitions for structures and
 *    externs for functions used by frontend applications.
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * libpq-fe.h,v 1.4 1995/02/13 19:47:33 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef LIBPQ_FE_H
#define LIBPQ_FE_H

/* ----------------
 *	include stuff common to fe and be
 * ----------------
 */
#include "libpq/libpq.h"

typedef void *TUPLE;
/* ----------------
 *	declarations for frontend libpq support routines
 * ----------------
 */
#undef palloc
#undef pfree


/* these are the real decls from executor/executor.h
extern char *GetAttributeByName(TupleTableSlot slot, Name attname,
				bool *isNull);
extern char *GetAttributeByNum(TupleTableSlot slot, AttributeNumber attrno,
			bool *isNull);
*/

extern char *GetAttributeByName(TUPLE tuple, char *attname, char *isnull );
extern char *GetAttributeByNum(TUPLE tuple, int attnum, char *isnull );

extern int dump_data(char *portal_name, int rule_p);
extern void read_remark(char id[]);
extern char *PQdb(void);
extern void PQsetdb(char *dbname);
extern void PQreset(void);
extern void PQfinish(void);
extern int PQFlushI(int i_count);
extern char *PQfn(int fnid, int *result_buf, int result_len, int *actual_result_len, int result_type, PQArgBlock *args, int nargs);
extern char *PQexec(char *query);
extern void *palloc(Size size);
extern void pfree(void *pointer);
extern void AssertionFailed(const String assertionName, const String fileName, const int lineNumber);

#endif /* LIBPQ_FE_H */
