/*-------------------------------------------------------------------------
 *
 * defrem.h--
 *    POSTGRES define and remove utility definitions.
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * defrem.h,v 1.2 1995/03/15 23:25:43 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef	DEFREM_H
#define DEFREM_H

#include "postgres.h"
#include "nodes/pg_list.h"
#include "nodes/primnodes.h"
#include "nodes/parsenodes.h"
#include "tcop/dest.h"

/*
 * prototypes in defind.c
 */
extern void DefineIndex(Name heapRelationName, Name indexRelationName,
			Name accessMethodName, List *attributeList,
			List *parameterList, Expr *predicate,
			List *rangetable);
extern void ExtendIndex(Name indexRelationName, Expr *predicate,
			List *rangetable);
extern void RemoveIndex(Name name);

/*
 * prototypes in define.c
 */
extern void DefineFunction(ProcedureStmt *nameargsexe, CommandDest dest);
extern void DefineOperator(Name name, List *parameters);
extern void DefineAggregate(Name name, List *parameters);
extern void DefineType(Name name, List *parameters);

/*
 * prototypes in remove.c
 */
extern void RemoveFunction(Name functionName, int nargs, List *argNameList);
extern void RemoveOperator(Name operatorName, Name typeName1, Name typeName2);
extern void RemoveType(Name typeName);
extern void RemoveAggregate(Name aggName);

#endif	/* DEFREM_H */
