/*-------------------------------------------------------------------------
 *
 * tupdesc.h--
 *    POSTGRES tuple descriptor definitions.
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * tupdesc.h,v 1.5 1995/02/12 02:54:53 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef	TUPDESC_H
#define TUPDESC_H

#include "postgres.h"
#include "access/attnum.h"
#include "nodes/pg_list.h"	/* for List */
#include "catalog/pg_attribute.h"

/*
 * a TupleDesc is an array of AttributeTupleForms, each of which is a
 * pointer to a AttributeTupleForm
 */
typedef AttributeTupleForm      *TupleDesc;


extern TupleDesc CreateTemplateTupleDesc(int natts);

extern bool TupleDescInitEntry(TupleDesc desc,
			       AttrNumber attributeNumber,
			       Name attributeName, 
			       Name typeName, 
			       int attdim, 
			       bool attisset);

extern TupleDesc BuildDescForRelation(List *schema, Name relname);

#endif	/* TUPDESC_H */
