/*
 * dynamic_syms.c --
 *	Linkable POSTGRES symbols code.
 *
 * Description:
 *	This file contains an array of function and data symbols with symbol
 * names for use during dynamic linking of external object code.
 *
 *	In addition, identification strings for header files are located at
 * the end of this file.
 *
 * Note:
 *	Most of the POSTGRES definitions should disappear to be replaced
 * by "FILENAME_SYMBOLS" lines as header files are converted to use the
 * ExternDecl and SymbolDecl macros.  No effort has been made to make this
 * file lintable; at present, don't even try.  -hirohama
 */

/* Hack to avoid including math.h, which causes stuff to screw up on the
 * Sparcstation running SunOS 4.
 */

#include <math.h>

#include "tmp/postgres.h"

RcsId("$Header: /private/postgres/src/port/dec/RCS/dynamic_syms.c,v 1.39 1992/07/06 05:04:28 mao Exp $");

/*
 * Files which define the "FILENAME_H" strings and "FILENAME_SYMBOLS" lists.
 */
#include "access/att.h"
#include "access/attnum.h"
#include "access/htup.h"
#include "access/istrat.h"
#include "access/skey.h"
#include "access/tqual.h"
#include "access/tupdesc.h"
#include "catalog/catname.h"
#include "rules/rlock.h"
#include "storage/block.h"
#include "storage/buf.h"
#include "storage/bufmgr.h"
#include "storage/bufpage.h"
#include "storage/fd.h"
#include "storage/itemid.h"
#include "storage/itemptr.h"
#include "storage/off.h"
#include "storage/page.h"
#include "storage/pagenum.h"
#include "storage/part.h"
#include "storage/pos.h"
#include "tmp/miscadmin.h"
#include "utils/exc.h"
#include "utils/excid.h"
#include "utils/palloc.h"
#include "utils/rel.h"
#include "utils/module.h"

#define BuiltinsIncluded
#include "utils/fmgr.h"
#include "utils/syms.h"

#ifdef PALLOC_DEBUG
#undef palloc
#undef pfree
#undef MemoryContextAlloc
#undef MemoryContextFree
#undef AllocSetReset
#undef malloc
#undef free
extern free();
#endif PALLOC_DEBUG

/*
 * data_ptr --
 *	Pointers to external data are treated identically to function pointers
 * in BSD UNIX a.out(5).
 */
#define data_ptr	func_ptr

/*
 * Preliminary security configuration control.
 *
 * Note:
 *	At present, does not take ordering or dependencies into account.
 */

/*
 * Fake external declarations which should be removed as migration to header
 * files occurs.
 *
 * Functions are grouped by type of functionality and sorted within groups.
 */

extern	pq_getnchar(),
	pq_getint(),
	pq_getstr(),
	pq_putint(),
	pq_putnchar(),
	pq_getinaddr(),
	pq_getinserv(),    
	pq_putstr();

extern	inter_lb(),
	inter_sb(),
	inter_sl(),
	interpt_sl(),
	path_in(),
	path_inter(),
	path_is_cheaper(),
	path_length(),
	path_ln(),
	path_n_eq(),
	path_n_ge(),
	path_n_gt(),
	path_n_le(),
	path_n_lt(),
	path_out(),
	point_above(),
	point_below(),
	point_construct(),
	point_copy(),
	point_distance(),
	point_dt(),
	point_eq(),
	point_horiz(),
	point_in(),
	point_left(),
	point_out(),
	point_right(),
	point_sl(),
	point_slope(),
	point_vert(),
	pointdist(),
	position();

extern	NumberOfBitsPerByte(),
	TimeIsBefore(),
	TransactionIdAdd(),
	abstimeeq(),
	abstimege(),
	abstimegt(),
	abstimein(),
	abstimele(),
	abstimelt(),
	abstimene(),
	abstimeout(),
	atof1(),
	boolin(),
	boolout(),
	byteain(),
	byteaout(),
	char16eq(),
	char16in(),
	char16ne(),
	char16out(),
	char16regexeq(),
	chardiv(),
	chareq(),
	charge(),
	chargt(),
	charin(),
	charle(),
	charlt(),
	charmi(),
	charmul(),
	charne(),
	charout(),
	charpl(),
	dtin(),
	dtof(),
	dtout(),
	float48div(),
	float48eq(),
	float48ge(),
	float48gt(),
	float48le(),
	float48lt(),
	float48mi(),
	float48mul(),
	float48ne(),
	float48pl(),
	float4abs(),
	float4div(),
	float4eq(),
	float4ge(),
	float4gt(),
	float4in(),
	float4inAd(),
	float4le(),
	float4lt(),
	float4mi(),
	float4mul(),
	float4ne(),
	float4out(),
	float4outAd(),
	float4pl(),
	float4um(),
	float84div(),
	float84eq(),
	float84ge(),
	float84gt(),
	float84le(),
	float84lt(),
	float84mi(),
	float84mul(),
	float84ne(),
	float84pl(),
	float8abs(),
	float8div(),
	float8eq(),
	float8ge(),
	float8gt(),
	float8in(),
	float8inAd(),
	float8le(),
	float8lt(),
	float8mi(),
	float8mul(),
	float8ne(),
	float8out(),
	float8outAd(),
	float8pl(),
	float8um(),
	ftoa(),
	ftod(),
	int28in(),
	int28out(),
	int44in(),
	int44out(),
	int2div(),
	int2eq(),
	int2fac(),
	int2ge(),
	int2gt(),
	int2in(),
	int2le(),
	int2lt(),
	int2mi(),
	int2mod(),
	int2mul(),
	int2ne(),
	int2out(),
	int2pl(),
	int4div(),
	int4eq(),
	int4fac(),
	int4ge(),
	int4gt(),
	int4in(),
	int4le(),
	int4lt(),
	int4mi(),
	int4mod(),
	int4mul(),
	int4ne(),
	int4out(),
	int4pl(),
	ininterval(),
	intervalct(),
	intervalend(),
	intervaleq(),
	intervalleneq(),
	intervallenge(),
	intervallengt(),
	intervallenle(),
	intervallenlt(),
	intervallenne(),
	intervalov(),
	intervalrel(),
	intervalstart(),
	isabstime(),
	isreltime(),
	istinterval(),
	itoa(),
	ltoa(),
	keyfirsteq(),
	oid8in(),
	oid8out(),
	regprocin(),
	regprocout(),
	reltimeeq(),
	reltimege(),
	reltimegt(),
	reltimein(),
	reltimele(),
	reltimelt(),
	reltimene(),
	reltimeout(),
	texteq(),
	textin(),
	textne(),
	textout(),
	textregexeq(),
	timeinsec(),
	timemi(),
	timenow(),
	timenowout(),
	timepl(),
	tintervalin(),
	tintervalout(),
	tlen(),
	oidnotin(),
	int4notin(),
	xideq(),
	xidge(),
	xidgt(),
	xidle(),
	xidmi();

extern	dlog(),
	elog();

extern	NodeIsType(),
	NodeTagGetSize(),
	SetNodeType();

extern	GetCurrentCommandId(),
	GetCurrentTransactionId(),
	GetCurrentTransactionStartTime(),
	GetDataHome(),
	OverrideTransactionSystem();

extern	EnablePortalManager(),
	GetPortalByName(),
	BlankPortalAssignName(),
	/* CreatePortal(), */
	PortalSetQuery(),
	PortalGetQueryDesc(),
	PortalGetState(),
	PortalDestroy(),
	PortalResetHeapMemory(),
	StartPortalAllocMode();
	EndPortalAllocMode(),
	PortalGetVariableMemory(),
	PortalGetHeapMemory(),
	PortalVariableMemoryGetPortal(),
	PortalHeapMemoryGetPortal(),
	PortalVariableMemoryGetHeapMemory(),
	PortalHeapMemoryGetVariableMemory();

extern	CreateGlobalMemory(),
	GlobalMemoryDestroy(),
	MemoryContextAlloc(),
	MemoryContextFree(),
	MemoryContextGetName(),
	MemoryContextRealloc(),
	MemoryContextSwitchTo(),
	PointerGetAllocSize();

extern	PageIndexTupleDelete(),
	PageIndexTupleDeleteAdjustLinePointers(),
	endpskip(),
	pskip(),
	startpskip();

extern	AbortCurrentTransaction(),
	AttributeGetAttName(),
	BitArrayBitIsSet(),
	BitArrayClearBit(),
	BitArraySetBit(),
	BitArrayZero(),
	CommandIdIsCurrentCommandId(),
	ItemPointerFormGeneralInsertIndexResult(),
	ItemPointerFormGeneralRetrieveIndexResult(),
	ItemPointerFormInsertIndexResult(),
	ItemPointerFormRetrieveIndexResult(),
	RelationGetStrategy(),
	RelationInvokeStrategy(),
	StrategyEvaluationIsValid(),
	StrategyExpressionIsValid(),
	StrategyOperatorIsValid(),
	StrategyTermIsValid(),
	TransactionIdDidAbort(),
	TransactionIdDidCommit(),
	TransactionIdGetCommitTime(),
	TransactionIdIsCurrentTransactionId(),
	TransactionIdIsInProgress(),
	relpath();


extern	LocalInvalidRegister(),
	RegisterInvalid(),
	RelationInvalidateCatalogCacheTuple(),
	RelationInvalidateHeapTuple();

extern	prs2StubQualIsEqual(),
	prs2StubToString(),
	prs2StringToStub(),
	prs2RawStubToStub(),
	prs2StubToRawStub(),
	prs2OneStubIsEqual(),
	prs2SearchStub(),
	prs2AddOneStub(),
	prs2DeleteOneStub(),
	prs2MakeStub(),
	prs2MakeOneStub(),
	prs2FreeStub(),
	prs2RemoveStubsOfRule(),
	prs2FreeLocks(),
	prs2MakeLocks(),
	prs2AddLock(),
	prs2GetOneLockFromLocks(),
	prs2OneLocksAreTheSame(),
	prs2OneLockIsMemberOfLocks(),
	prs2GetLocksFromTuple(),
	prs2PutLocksInTuple(),
	prs2PrintLocks(),
	prs2CopyLocks(),
	prs2RemoveOneLockInPlace(),
	prs2RemoveAllLocksOfRuleInPlace(),
	prs2RemoveAllLocksOfRule(),
	prs2LockUnion(),
	prs2LockDifference(),
	prs2FindLocksOfType(),
	prs2RemoveLocksOfTypeInPlace();

extern	FetchDefault(),
	HeapTupleGetAttributeValue(),
	HeapTupleGetRuleLock(),
	HeapTupleSetRuleLock(),
	HeapTupleStoreRuleLock(),
	RelationContainsUsableBlock(),
	SearchSysCache(),
	SearchSysCacheGetAttribute(),
	SearchSysCacheStruct(),
	SearchSysCacheTuple(),
	SetHeapAccessMethodImmediateInvalidation(),
	SetRefreshWhenInvalidate(),
	getstruct(),
	newoid();

extern	AmiTransactionOverride(),
	DefaultBuild(),
	GetHeapTuple(),
	IndexScanEnd(),
	IndexScanGetGeneralRetrieveIndexResult(),
	IndexScanGetRetrieveIndexResult(),
	IndexScanMarkPosition(),
	IndexScanRestart(),
	IndexScanRestorePosition(),
	IndexTupleGetAttributeValue(),
	IndexTupleGetIndexAttributeBitMap(),
	RelationGetIndexScan(),
	getattnvals(),
	gethilokey();

extern	CAtom(),
	CDouble(),
	CInteger(),
	CString(),
	LispDelete(),
	LispUnion(),
	append(),
	append1(),
	apply(),
	equal(),
	evalList(),
	every_func(),
	find(),
	last(),
	last_element(),
	length(),
	lispArray(),
	lispAssoc(),
	lispAtom(),
	lispCons(),
	lispDisplay(),
	lispDottedPair(),
	lispFloat(),
	lispInteger(),
	lispList(),
	lispString(),
	lispVectori(),
	mapcar(),
	max(),
	member(),
	nappend1(),
	nconc(),
	nreverse(),
	nthCdr(),
	push(),
	quote(),
	LispRemove(),
	remove_duplicates(),
	rplaca(),
	rplacd(),
	same(),
	setf(),
	some();

extern	MakeAppend(),
	MakeAppendState(),
	MakeCInfo(),
	MakeCommonState(),
	MakeConst(),
	MakeEState(),
	MakeExistential(),
	MakeExpr(),
	MakeExprContext(),
	MakeFunc(),
	MakeHInfo(),
	MakeHash(),
	MakeHashJoin(),
	MakeHashPath(),
	MakeIndexPath(),
	MakeIndexScan(),
	MakeJInfo(),
	MakeJoin(),
	MakeJoinKey(),
	MakeJoinMethod(),
	MakeJoinPath(),
	MakeMInfo(),
	MakeMergeJoinState(),
	MakeMergeOrder(),
	MakeMergePath(),
	MakeMergeJoin(),
	MakeNestLoop(),
	MakeNestLoopState(),
	MakeOper(),
	MakeOrderKey(),
	MakeParam(),
	MakePath(),
	MakePlan(),
	MakeQueryDesc(),
	MakeRangeTableEntry(),
	MakeRel(),
	MakeResdom(),
	MakeResult(),
	MakeResultState(),
	MakeRoot(),
	/* MakeRuleLock(), */
	/* MakeRuleLockIntermediate(), */
	/* MakeRuleLockIntermediateLock(), */
	MakeScan(),
	MakeScanState(),
	MakeSeqScan(),
	MakeSort(),
	MakeSortKey(),
	MakeSortState(),
	MakeCommonScanState(),
	MakeTLE(),
	MakeTemp(),
	MakeTimeRange(),
	MakeVar(),
	ModifyQueryTree(),
	ScanKeywordLookup(),
	StripRangeTable(),
	VarnoGetRelname(),
	add_clause_to_rels(),
	add_join_clause_info_to_rels(),
	add_pathlist(),
	/* add_read_locks(), */
	add_tl_element(),
	add_vars_to_rels(),
	and_clause(),
	att_typeid(),
	/* authnone_create(), */
	best_innerjoin(),
	best_or_subclause_index(),
	best_or_subclause_indices(),
	better_path(),
	cheaper_path(),
	clause_args(),
	clause_head(),
	clause_relids_vars(),
	clause_subclauses(),
	clause_type(),
/* 	clntudp_bufcreate(), */
/* 	clntudp_create(), */
	cnfify(),
	collect(),
	collect_index_pathkeys(),
	comphash(),
	compute_attribute_width(),
	compute_clause_selec(),
	compute_joinrel_size(),
	compute_rel_size(),
	compute_rel_width(),
	compute_selec(),
	compute_targetlist_width(),
	constant_p(),
	contains_not(),
	convtypeinfo(),
	copy_seq_tree(),
	copy_vars(),
	cost_hash(),
	cost_hashjoin(),
	cost_index(),
	cost_mergesort(),
	cost_nestloop(),
	cost_result(),
	cost_seqscan(),
	cost_sort(),
	create_hashjoin_node(),
	create_hashjoin_path(),
	create_index_path(),
	create_index_paths(),
	create_indexscan_node(),
	create_join_node(),
	create_mergejoin_node(),
	create_mergesort_path(),
	create_nestloop_node(),
	create_nestloop_path(),
	create_or_index_paths(),
	create_plan(),
	create_scan_node(),
	create_seqscan_node(),
	create_seqscan_path(),
	create_tl_element(),
	distribute_args(),
	find_all_inheritors(),
	find_all_join_paths(),
	/* find_all_vars(), */
	find_clause_joins(),
	find_clauseless_joins(),
	find_if(),
	find_if_not(),
	find_index_paths(),
	find_inheritance_children(),
	find_join_paths(),
	find_join_rels(),
	find_joininfo_node(),
	find_nots(),
	find_paths(),
	/* find_qual_update_vars(), */
	find_rel_paths(),
	find_relation_indices(),
	find_secondary_index(),
	/* find_tlist_read_vars(), */
	find_version_parents(),
	first_matching_rt_entry(),
	fix_indxqual_references(),
	fix_opid(),
	fix_opids(),
	fix_parsetree_attnums(),
	fix_rangetable(),
	fix_targetlist(),
	flatten_tlist(),
	flatten_tlist_vars(),
/*	get_BkwdMarkPos(),	*/
/*	get_Flag(),	*/
/*	get_FrwdMarkPos(),	*/
/*	get_ISortopO(),	*/
/*	get_IndexPtr(),	*/
/*	get_Keys(),	*/
/*	get_Loop(),	*/
/*	get_OSortopI(),	*/
/*	get_OldRelId(),	*/
/*	get_OuterTuple(),	*/
/*	get_PortalFlag(),	*/
/*	get_ProcLeftFlag(),	*/
/*	get_RuleDesc(),	*/
/*	get_RuleFlag(),	*/
/*	get_SatState(),	*/
/*	get_ScanType(),	*/
/*	get_Skeys(),	*/
/*	get_SkeysCount(),	*/
/*	get_TupType(),	*/
/*	get_TupValue(),	*/
	get_actual_clauses(),
	get_actual_tlist(),
	get_andclauseargs(),
/*	get_arkFlag(),	*/
	get_attname(),
	get_attnum(),
	get_atttype(),
	get_commutator(),
/*	get_currentRelation(),	*/
/*	get_currentScanDesc(),	*/
/*	get_direction(),	*/
	get_entry(),
/*	get_error_message(),	*/
	get_expr(),
	get_funcargs(),
	get_function(),
	get_id_type(),
/*	get_initialized(),	*/
	get_joinlist(),
	get_joinvar(),
	get_joinvars(),
	get_leftop(),
/*	get_locks(),	*/
	get_negator(),
	get_notclausearg(),
/*	get_nplans(),	*/
	get_op(),
	get_opargs(),
	get_opcode(),
	get_opnos(),
	get_oprjoin(),
	get_oprrest(),
	get_orclauseargs(),
	get_rel(),
	get_rel_name(),
	get_relattval(),
	get_relattvals(),
	get_relnatts(),
	get_relsatts(),
	get_resdom(),
	get_rightop(),
	get_typbyval(),
	get_typdefault(),
	get_typlen(),
	group_clauses_by_hashop(),
	group_clauses_by_indexkey(),
	group_clauses_by_order(),
	index(),
	index_info(),
	index_innerjoin(),
	index_outerjoin_references(),
	index_selectivity(),
	indexable_joinclauses(),
	initialize_join_clause_info(),
	initialize_qualification(),
	initialize_targetlist(),
	is_clause(),
	is_funcclause(),
	is_null(),
	is_opclause(),
#ifdef	sun
	isinf(),
#endif
	join_clause_p(),
	join_p(),
	join_references(),
	join_selectivity(),
	joininfo_member(),
	joinmethod_clauses(),
	joinmethod_keys(),
	make_andclause(),
	make_append(),
	make_clause(),
	make_const(),
	make_existential(),
	make_funcclause(),
	make_hash(),
	make_hashjoin(),
	make_indexscan(),
	make_nestloop(),
	make_notclause(),
	make_op(),
	make_opclause(),
	make_orclause(),
	/* make_parameterized_plans(), */
	make_result(),
	/* make_rule_lock(), */
	/* make_rule_locks(), */
	/* make_rule_plans(), */
	make_seqscan(),
	make_temp(),
	make_var(),
	left_oper(),
	match_clause_to_indexkey(),
	match_hashop_hashinfo(),
	match_index_orclause(),
	match_index_orclauses(),
	match_indexkey_operand(),
	match_order_mergeinfo(),
	match_pathkey_joinkeys(),
	match_pathkeys_joinkeys(),
	match_paths_joinkeys(),
	match_sortkeys_pathkeys(),
	match_unsorted_inner(),
	match_unsorted_outer(),
	match_varid(),
	matching2_tlvar(),
	/* matching_rule_locks(), */
	matching_tlvar(),
	mergesortop(),
	new_filestr(),
	new_join_pathkey(),
	new_join_pathkeys(),
	new_join_tlist(),
	new_joininfo_list(),
	new_level_qual(),
	new_level_tlist(),
	new_matching_subkeys(),
	new_rangetable_entry(),
	new_relation_targetlist(),
	new_result_qual(),
	new_result_tlist(),
	new_unsorted_tlist(),
	/* no_var_read_locks_yet(), */
	non_null(),
	normalize(),
	/* normalize_attnos(), */
	not_clause(),
	number_list(),
	numlevels(),
	op_class(),
	op_hashjoinable(),
	op_mergesortable(),
	oper(),
	oprid(),
	or_clause(),
	or_normalize(),
	other_join_clause_var(),
	outstr(),
	/* parameterize(), */
	plan_p(),
	plan_union_queries(),
	plan_union_query(),
	preprocess_qualification(),
	preprocess_targetlist(),
	/* process_rules(), */
	product_selec(),
	prune_joinrel(),
	prune_joinrels(),
	prune_rel_path(),
	prune_rel_paths(),
	pull_ands(),
	pull_args(),
	pull_constant_clauses(),
	pull_ors(),
	pull_relation_level_clauses(),
	pull_var_clause(),
	push_nots(),
	qual_clause_p(),
	qualcleanup(),
	query_planner(),
	/* read_decorate(), */
	rel_member(),
	relation_info(),
	relation_level_clause_p(),
	relation_sortkeys(),
	remove_ands(),
	/* remove_duplicate_vars(), */
	replace_clause_joinvar_refs(),
	replace_clause_resultvar_refs(),
	replace_joinvar_refs(),
	replace_matching_resname(),
	replace_opid(),
	replace_resultvar_refs(),
	replace_subclause_joinvar_refs(),
	replace_subclause_resultvar_refs(),
	restore_globals(),
	restriction_selectivity(),
	right_oper(),
	samekeys(),
	save_globals(),
	scan_p(),
	set_cheapest(),
	set_clause_selectivities(),
	set_difference(),
	set_entry(),
	set_join_tlist_references(),
	set_joinlist(),
	set_lefttree(),
	set_rest_relselec(),
	set_rest_selec(),
	set_righttree(),
	set_temp_tlist_operators(),
	set_temp_tlist_references(),
	set_tempscan_tlist_references(),
	set_tlist_references(),
	single_node(),
	sort(),
	sort_argv(),
	sort_inner_and_outer(),
	sort_level_result(),
	sort_list_car(),
	sort_relation_paths(),
	subplanner(),
	subst_rangetable(),
	switch_outer(),
	targetlist_resdom_numbers(),
	tbyvalue(),
	tname(),
	translate_relid(),
	tlist_member(),
	tlist_temp_references(),
	tlistentry_member(),
	type(),
	typeid(),
	update_clauses(),
	update_relations(),
	v1prot_dofirst(),
	v1prot_donext(),
	valid_numkeys(),
	valid_or_clause(),
	valid_sortkeys(),
	var_equal(),
	var_is_inner(),
	var_is_mat(),
	var_is_outer(),
	var_is_rel();

extern	DefineFunction(),
	DefineIndex(),
	DefineOperator(),
	DefineRelation(),
	DefineType(),
	RemoveFunction(),
	RemoveIndex(),
	RemoveOperator(),
	RemoveRelation(),
	RemoveType();

extern	ExecMain(),
	ExecutePlan(),
	ProcessQuery(),
	ProcessUtility(),
	parser(),
	planner();

/*
 * for c function access to attributes of tuple arguments
 */
extern GetAttributeByName();
extern GetAttributeByNum();

/*
 * BSD UNIX external functions
 */
extern accept(), bind(), chdir(), close(), connect(), dup(), fcntl(), flock(),
	fork(), fstat(), fsync(), getdtablesize(), geteuid(), getuid(), ioctl(),
	kill(), listen(), lseek(), open(), read(), rename(),
	select(), semctl(), semget(), semop(), sendto(), shmat(), shmctl(),
	shmdt(), shmget(), socket(), stat(), /*syscall(),*/ umask(), unlink(),
	write(), writev();

/*
 * LIBC math external functions
 */
extern dexp(),
#ifdef	sun
#ifndef NO_DMINUS
	dminus(),
#endif
#endif
	dround(), dsqrt(), dtrunc(), 

#ifdef sparc
	exp(),fabs(),floor(),log(),log10(),pow(),sqrt(),atof(),
#endif

#if	defined(mips) || defined(sparc) 
#ifndef sprite
	rint(),
#endif  /* !sprite */
#endif

	dpow();

/*
 * LIBC external data variables
 */
extern environ, errno, sys_nerr;

/*
 * LIBC non-math external functions
 */
extern
#ifndef NO_ALLOCA
alloca(),
#endif
atoi(), atol(), bcmp(), bcopy(), bzero(), calloc(),
	ecvt(), endhostent(), endpwent(), endservent(), fflush(),
#ifdef	sun
	fgetpwent(),
#endif
	fgets(), fclose(), fcvt(), fdopen(), fopen(), fprintf(), fputs(),
	fread(), /* free(), */ freopen(), fscanf(), fseek(), gcvt(), getenv(),
	gethostbyaddr(), gethostbyname(), /* gethostent(),*/ getpagesize(),
        getpid(), getpwent(), getpwnam(),
	getpwuid(), gets(), getservbyname(), getservbyport(), getservent(),
	getsockname(), gettimeofday(), htons(), isatty(),
	/* malloc(), */
#ifdef	sun
	memalign(),
#endif
	/*memccpy(),*/ memchr(), memcpy(), memset(), perror(), printf(), puts(),
	qsort(), random(), realloc(), rewind(), scanf(), setbuf(), setstate(),
	sethostent(), _setjmp(), setjmp(), setpwent(), setreuid(), setservent(),
	setuid(), sleep(), sprintf(), srandom(), sscanf(), strcat(), strchr(),
	strcmp(), strcpy(), strlen(), strncmp(), strncpy(), strtol(),
	sys_errlist(), time(), ungetc() /*, valloc()*/;

/*
 * ExtSyms --
 *	Externally visible symbol list.
 */
FList ExtSyms[] = {
	C_SYMBOLS,
	BUF_SYMBOLS,
	BUFMGR_SYMBOLS,
	BUFPAGE_SYMBOLS,
	CATNAME_SYMBOLS,
	EXC_SYMBOLS,
	EXCID_SYMBOLS,
	FD_SYMBOLS,
	GLOBALS_SYMBOLS,
	ITEMPTR_SYMBOLS,
	NAME_SYMBOLS,
	PALLOC_SYMBOLS,
	PART_SYMBOLS,
	PMOD_SYMBOLS,
	REL_SYMBOLS,
	/* RLOCK_SYMBOLS, */
	SKEY_SYMBOLS,
	TIM_SYMBOLS,
	TQUAL_SYMBOLS,
	TUPDESC_SYMBOLS,
	XID_SYMBOLS,

/*
 * Random stuff follows:
 */
/* COMMUNICATION */
	SymbolDecl(pq_getnchar),
	SymbolDecl(pq_getint),
	SymbolDecl(pq_getstr),
	SymbolDecl(pq_putint),
	SymbolDecl(pq_putnchar),
	SymbolDecl(pq_putstr),
	SymbolDecl(pq_getinaddr),
	SymbolDecl(pq_getinserv),

/* GEOMETRIC_TYPES */
	SymbolDecl(inter_lb),
	SymbolDecl(inter_sb),
	SymbolDecl(inter_sl),
	SymbolDecl(interpt_sl),
	SymbolDecl(path_in),
	SymbolDecl(path_inter),
	SymbolDecl(path_is_cheaper),
	SymbolDecl(path_length),
	SymbolDecl(path_ln),
	SymbolDecl(path_n_eq),
	SymbolDecl(path_n_ge),
	SymbolDecl(path_n_gt),
	SymbolDecl(path_n_le),
	SymbolDecl(path_n_lt),
	SymbolDecl(path_out),
	SymbolDecl(point_above),
	SymbolDecl(point_below),
	SymbolDecl(point_construct),
	SymbolDecl(point_copy),
	SymbolDecl(point_distance),
	SymbolDecl(point_dt),
	SymbolDecl(point_eq),
	SymbolDecl(point_horiz),
	SymbolDecl(point_in),
	SymbolDecl(point_left),
	SymbolDecl(point_out),
	SymbolDecl(point_right),
	SymbolDecl(point_sl),
	SymbolDecl(point_slope),
	SymbolDecl(point_vert),
	SymbolDecl(pointdist),
	SymbolDecl(position),

/* SYSTEM_TYPES */
	SymbolDecl(NumberOfBitsPerByte),
	SymbolDecl(TimeIsBefore),
	SymbolDecl(TransactionIdAdd),
	SymbolDecl(abstimeeq),
	SymbolDecl(abstimege),
	SymbolDecl(abstimegt),
	SymbolDecl(abstimein),
	SymbolDecl(abstimele),
	SymbolDecl(abstimelt),
	SymbolDecl(abstimene),
	SymbolDecl(abstimeout),
	SymbolDecl(atof1),
	SymbolDecl(boolin),
	SymbolDecl(boolout),
	SymbolDecl(byteain),
	SymbolDecl(byteaout),
	SymbolDecl(char16eq),
	SymbolDecl(char16in),
	SymbolDecl(char16ne),
	SymbolDecl(char16out),
	SymbolDecl(char16regexeq),
	SymbolDecl(chardiv),
	SymbolDecl(chareq),
	SymbolDecl(charge),
	SymbolDecl(chargt),
	SymbolDecl(charin),
	SymbolDecl(charle),
	SymbolDecl(charlt),
	SymbolDecl(charmi),
	SymbolDecl(charmul),
	SymbolDecl(charne),
	SymbolDecl(charout),
	SymbolDecl(charpl),
	SymbolDecl(dtin),
	SymbolDecl(dtof),
	SymbolDecl(dtout),
	SymbolDecl(float48div),
	SymbolDecl(float48eq),
	SymbolDecl(float48ge),
	SymbolDecl(float48gt),
	SymbolDecl(float48le),
	SymbolDecl(float48lt),
	SymbolDecl(float48mi),
	SymbolDecl(float48mul),
	SymbolDecl(float48ne),
	SymbolDecl(float48pl),
	SymbolDecl(float4abs),
	SymbolDecl(float4div),
	SymbolDecl(float4eq),
	SymbolDecl(float4ge),
	SymbolDecl(float4gt),
	SymbolDecl(float4in),
	SymbolDecl(float4inAd),
	SymbolDecl(float4le),
	SymbolDecl(float4lt),
	SymbolDecl(float4mi),
	SymbolDecl(float4mul),
	SymbolDecl(float4ne),
	SymbolDecl(float4out),
	SymbolDecl(float4outAd),
	SymbolDecl(float4pl),
	SymbolDecl(float4um),
	SymbolDecl(float84div),
	SymbolDecl(float84eq),
	SymbolDecl(float84ge),
	SymbolDecl(float84gt),
	SymbolDecl(float84le),
	SymbolDecl(float84lt),
	SymbolDecl(float84mi),
	SymbolDecl(float84mul),
	SymbolDecl(float84ne),
	SymbolDecl(float84pl),
	SymbolDecl(float8abs),
	SymbolDecl(float8div),
	SymbolDecl(float8eq),
	SymbolDecl(float8ge),
	SymbolDecl(float8gt),
	SymbolDecl(float8in),
	SymbolDecl(float8inAd),
	SymbolDecl(float8le),
	SymbolDecl(float8lt),
	SymbolDecl(float8mi),
	SymbolDecl(float8mul),
	SymbolDecl(float8ne),
	SymbolDecl(float8out),
	SymbolDecl(float8outAd),
	SymbolDecl(float8pl),
	SymbolDecl(float8um),
	SymbolDecl(ftoa),
	SymbolDecl(ftod),
	SymbolDecl(int28in),
	SymbolDecl(int28out),
	SymbolDecl(int2div),
	SymbolDecl(int2eq),
	SymbolDecl(int2fac),
	SymbolDecl(int2ge),
	SymbolDecl(int2gt),
	SymbolDecl(int2in),
	SymbolDecl(int2le),
	SymbolDecl(int2lt),
	SymbolDecl(int2mi),
	SymbolDecl(int2mod),
	SymbolDecl(int2mul),
	SymbolDecl(int2ne),
	SymbolDecl(int2out),
	SymbolDecl(int2pl),
	SymbolDecl(int4div),
	SymbolDecl(int4eq),
	SymbolDecl(int4fac),
	SymbolDecl(int4ge),
	SymbolDecl(int4gt),
	SymbolDecl(int4in),
	SymbolDecl(int4le),
	SymbolDecl(int4lt),
	SymbolDecl(int4mi),
	SymbolDecl(int4mod),
	SymbolDecl(int4mul),
	SymbolDecl(int4ne),
	SymbolDecl(int4out),
	SymbolDecl(int4pl),
	SymbolDecl(ininterval),
	SymbolDecl(intervalct),
	SymbolDecl(intervalend),
	SymbolDecl(intervaleq),
	SymbolDecl(intervalleneq),
	SymbolDecl(intervallenge),
	SymbolDecl(intervallengt),
	SymbolDecl(intervallenle),
	SymbolDecl(intervallenlt),
	SymbolDecl(intervallenne),
	SymbolDecl(intervalov),
	SymbolDecl(intervalrel),
	SymbolDecl(intervalstart),
	SymbolDecl(isabstime),
	SymbolDecl(isreltime),
	SymbolDecl(istinterval),
	SymbolDecl(itoa),
	SymbolDecl(ltoa),
	SymbolDecl(keyfirsteq),
	SymbolDecl(oid8in),
	SymbolDecl(oid8out),
	SymbolDecl(regprocin),
	SymbolDecl(regprocout),
	SymbolDecl(reltimeeq),
	SymbolDecl(reltimege),
	SymbolDecl(reltimegt),
	SymbolDecl(reltimein),
	SymbolDecl(reltimele),
	SymbolDecl(reltimelt),
	SymbolDecl(reltimene),
	SymbolDecl(reltimeout),
	SymbolDecl(texteq),
	SymbolDecl(textin),
	SymbolDecl(textne),
	SymbolDecl(textout),
	SymbolDecl(textregexeq),
	SymbolDecl(timeinsec),
	SymbolDecl(timemi),
	SymbolDecl(timenow),
	SymbolDecl(timenowout),
	SymbolDecl(timepl),
	SymbolDecl(tintervalin),
	SymbolDecl(tintervalout),
	SymbolDecl(tlen),
	SymbolDecl(oidnotin),
	SymbolDecl(int4notin),
	SymbolDecl(xideq),
	SymbolDecl(xidge),
	SymbolDecl(xidgt),
	SymbolDecl(xidle),
	SymbolDecl(xidmi),

/* EXCEPTIONAL_CONDITIONS */
	SymbolDecl(SetTraceLevel),
	SymbolDecl(TraceFileName),
	SymbolDecl(dlog),
	SymbolDecl(elog),

/* NODE_INHERITANCE */
	SymbolDecl(NodeIsType),
	SymbolDecl(NodeTagGetSize),
	SymbolDecl(SetNodeType),

/* SUPPORT_STATUS */
	SymbolDecl(BypassEnable),
	SymbolDecl(GetCurrentCommandId),
	SymbolDecl(GetCurrentTransactionId),
	SymbolDecl(GetCurrentTransactionStartTime),
	SymbolDecl(GetDataHome),
	SymbolDecl(GetDatabaseName),
	SymbolDecl(GetDatabasePath),
	SymbolDecl(GetUserId),
	SymbolDecl(OverrideTransactionSystem),
/*	ExternDecl(PostgresDatabase), */
/*	ExternDecl(PostgresPath), */

/* MEMORY_MANAGER */
	SymbolDecl(CreateGlobalMemory),
/*	ExternDecl(CurrentMemoryContext), */
	SymbolDecl(GlobalMemoryDestroy),
	SymbolDecl(MemoryContextAlloc),
	SymbolDecl(MemoryContextFree),
	SymbolDecl(MemoryContextGetName),
	SymbolDecl(MemoryContextRealloc),
	SymbolDecl(MemoryContextSwitchTo),
	SymbolDecl(PointerGetAllocSize),
/*	ExternDecl(TopMemoryContext), */

/* BUFFER_MANAGER */
	SymbolDecl(PageIndexTupleDelete),
	SymbolDecl(PageIndexTupleDeleteAdjustLinePointers),
	SymbolDecl(endpskip),
	SymbolDecl(pskip),
	SymbolDecl(startpskip),

/* PORTAL */
	SymbolDecl(EnablePortalManager),
	SymbolDecl(GetPortalByName),
	SymbolDecl(BlankPortalAssignName),
	SymbolDecl(PortalSetQuery),
	SymbolDecl(PortalGetQueryDesc),
	SymbolDecl(PortalGetState),
	SymbolDecl(PortalDestroy),
	SymbolDecl(PortalResetHeapMemory),
	SymbolDecl(StartPortalAllocMode),
	SymbolDecl(EndPortalAllocMode),
	SymbolDecl(PortalGetVariableMemory),
	SymbolDecl(PortalGetHeapMemory),
	SymbolDecl(PortalVariableMemoryGetPortal),
	SymbolDecl(PortalHeapMemoryGetPortal),
	SymbolDecl(PortalVariableMemoryGetHeapMemory),
	SymbolDecl(PortalHeapMemoryGetVariableMemory),

/* STORAGE_MANAGER */
	SymbolDecl(AbortCurrentTransaction),
	SymbolDecl(AttributeGetAttName),
	SymbolDecl(BitArrayBitIsSet),
	SymbolDecl(BitArrayClearBit),
	SymbolDecl(BitArraySetBit),
	SymbolDecl(BitArrayZero),
	SymbolDecl(CommandIdIsCurrentCommandId),
	SymbolDecl(ItemPointerFormGeneralInsertIndexResult),
	SymbolDecl(ItemPointerFormGeneralRetrieveIndexResult),
	SymbolDecl(ItemPointerFormInsertIndexResult),
	SymbolDecl(ItemPointerFormRetrieveIndexResult),
	SymbolDecl(RelationGetStrategy),
	SymbolDecl(RelationInvokeStrategy),
	SymbolDecl(StrategyEvaluationIsValid),
	SymbolDecl(StrategyExpressionIsValid),
	SymbolDecl(StrategyOperatorIsValid),
	SymbolDecl(StrategyTermIsValid),
	SymbolDecl(TransactionIdDidAbort),
	SymbolDecl(TransactionIdDidCommit),
	SymbolDecl(TransactionIdGetCommitTime),
	SymbolDecl(TransactionIdIncrement),
	SymbolDecl(TransactionIdIsCurrentTransactionId),
	SymbolDecl(TransactionIdIsInProgress),
	SymbolDecl(fmgr),
	SymbolDecl(relpath),


/* LOCK_MANAGER */
	SymbolDecl(LRelIdContainsMyDatabaseId),
	SymbolDecl(LRelIdGetDatabaseId),
	SymbolDecl(LRelIdGetRelationId),
	SymbolDecl(LocalInvalidRegister),
	SymbolDecl(RegisterInvalid),
	SymbolDecl(RelationGetLRelId),
	SymbolDecl(RelationInvalidateCatalogCacheTuple),
	SymbolDecl(RelationInvalidateHeapTuple),
	SymbolDecl(RelationSetLockForDescriptorOpen),
	SymbolDecl(RelationSetLockForRead),
	SymbolDecl(RelationSetLockForReadPage),
	SymbolDecl(RelationSetLockForTupleRead),
	SymbolDecl(RelationSetLockForWrite),
	SymbolDecl(RelationSetLockForWritePage),
	SymbolDecl(RelationUnsetLockForReadPage),
	SymbolDecl(RelationUnsetLockForWritePage),

/* RULE STUFF */
	SymbolDecl(prs2StubQualIsEqual),
	SymbolDecl(prs2StubToString),
	SymbolDecl(prs2StringToStub),
	SymbolDecl(prs2RawStubToStub),
	SymbolDecl(prs2StubToRawStub),
	SymbolDecl(prs2OneStubIsEqual),
	SymbolDecl(prs2SearchStub),
	SymbolDecl(prs2AddOneStub),
	SymbolDecl(prs2DeleteOneStub),
	SymbolDecl(prs2MakeStub),
	SymbolDecl(prs2MakeOneStub),
	SymbolDecl(prs2FreeStub),
	SymbolDecl(prs2RemoveStubsOfRule),
	SymbolDecl(prs2FreeLocks),
	SymbolDecl(prs2MakeLocks),
	SymbolDecl(prs2AddLock),
	SymbolDecl(prs2GetOneLockFromLocks),
	SymbolDecl(prs2OneLocksAreTheSame),
	SymbolDecl(prs2OneLockIsMemberOfLocks),
	SymbolDecl(prs2GetLocksFromTuple),
	SymbolDecl(prs2PutLocksInTuple),
	SymbolDecl(prs2PrintLocks),
	SymbolDecl(prs2CopyLocks),
	SymbolDecl(prs2RemoveOneLockInPlace),
	SymbolDecl(prs2RemoveAllLocksOfRuleInPlace),
	SymbolDecl(prs2RemoveAllLocksOfRule),
	SymbolDecl(prs2LockUnion),
	SymbolDecl(prs2LockDifference),
	SymbolDecl(prs2FindLocksOfType),
	SymbolDecl(prs2RemoveLocksOfTypeInPlace),

/* HEAP_ACCESS_METHOD */
	SymbolDecl(FetchDefault),
	SymbolDecl(HeapTupleGetRuleLock),
	SymbolDecl(HeapTupleSetRuleLock),
	SymbolDecl(HeapTupleStoreRuleLock),
	SymbolDecl(RelationContainsUsableBlock),
	SymbolDecl(RelationIdGetRelation),
	SymbolDecl(SearchSysCache),
	SymbolDecl(SearchSysCacheGetAttribute),
	SymbolDecl(SearchSysCacheStruct),
	SymbolDecl(SearchSysCacheTuple),
	SymbolDecl(SetHeapAccessMethodImmediateInvalidation),
	SymbolDecl(SetRefreshWhenInvalidate),
	SymbolDecl(getstruct),
	SymbolDecl(newoid),
	SymbolDecl(setheapoverride),

/* ACCESS_METHODS */
	SymbolDecl(AmiTransactionOverride),
	SymbolDecl(DefaultBuild),
	SymbolDecl(GetHeapTuple),
	SymbolDecl(IndexScanEnd),
	SymbolDecl(IndexScanGetGeneralRetrieveIndexResult),
	SymbolDecl(IndexScanGetRetrieveIndexResult),
	SymbolDecl(IndexScanMarkPosition),
	SymbolDecl(IndexScanRestart),
	SymbolDecl(IndexScanRestorePosition),
	SymbolDecl(IndexTupleGetAttributeValue),
	SymbolDecl(RelationGetIndexScan),
	SymbolDecl(getattnvals),
	SymbolDecl(gethilokey),
	SymbolDecl(heapisoverride),

/* SPAM_ACCESS_METHOD */
	/* XXX omitted ... */

/* BTREE_ACCESS_METHOD */
	/* XXX omitted ... */

/* RTREE_ACCESS_METHOD */
	/* XXX omitted ... */

/* LISP */
	SymbolDecl(CAtom),
	SymbolDecl(CDouble),
	SymbolDecl(CInteger),
	SymbolDecl(CString),
	SymbolDecl(LispDelete),
/*	ExternDecl(LispNil), */
	SymbolDecl(LispUnion),
	SymbolDecl(append),
	SymbolDecl(append1),
	SymbolDecl(apply),
	SymbolDecl(equal),
	SymbolDecl(evalList),
	SymbolDecl(every_func),
	SymbolDecl(find),
	SymbolDecl(last),
	SymbolDecl(last_element),
	SymbolDecl(length),
	SymbolDecl(lispArray),
	SymbolDecl(lispAssoc),
	SymbolDecl(lispAtom),
	SymbolDecl(lispCons),
	SymbolDecl(lispDisplay),
	SymbolDecl(lispDottedPair),
	SymbolDecl(lispFloat),
	SymbolDecl(lispInteger),
	SymbolDecl(lispList),
	SymbolDecl(lispString),
	SymbolDecl(lispVectori),
	SymbolDecl(mapcar),
	SymbolDecl(max),
	SymbolDecl(member),
	SymbolDecl(nappend1),
	SymbolDecl(nconc),
	SymbolDecl(nreverse),
	SymbolDecl(nthCdr),
	SymbolDecl(push),
	SymbolDecl(quote),
	SymbolDecl(LispRemove),
	SymbolDecl(remove_duplicates),
	SymbolDecl(rplaca),
	SymbolDecl(rplacd),
	SymbolDecl(same),
	SymbolDecl(setf),
	SymbolDecl(some),

/* LISP_STRUCTURES */
	SymbolDecl(MakeAppend),
	SymbolDecl(MakeAppendState),
	SymbolDecl(MakeCInfo),
	SymbolDecl(MakeCommonState),
	SymbolDecl(MakeCommonScanState),
	SymbolDecl(MakeConst),
	SymbolDecl(MakeEState),
	SymbolDecl(MakeExistential),
	SymbolDecl(MakeExpr),
	SymbolDecl(MakeExprContext),
	SymbolDecl(MakeFunc),
	SymbolDecl(MakeHInfo),
	SymbolDecl(MakeHash),
	SymbolDecl(MakeHashJoin),
	SymbolDecl(MakeHashPath),
	SymbolDecl(MakeIndexPath),
	SymbolDecl(MakeIndexScan),
	SymbolDecl(MakeJInfo),
	SymbolDecl(MakeJoin),
	SymbolDecl(MakeJoinKey),
	SymbolDecl(MakeJoinMethod),
	SymbolDecl(MakeJoinPath),
	SymbolDecl(MakeMInfo),
	SymbolDecl(MakeMergeJoinState),
	SymbolDecl(MakeMergeOrder),
	SymbolDecl(MakeMergePath),
	SymbolDecl(MakeMergeJoin),
	SymbolDecl(MakeNestLoop),
	SymbolDecl(MakeNestLoopState),
	SymbolDecl(MakeOper),
	SymbolDecl(MakeOrderKey),
	SymbolDecl(MakeParam),
	SymbolDecl(MakePath),
	SymbolDecl(MakePlan),
	SymbolDecl(MakeQueryDesc),
	SymbolDecl(MakeRangeTableEntry),
	SymbolDecl(MakeRel),
	SymbolDecl(MakeResdom),
	SymbolDecl(MakeResult),
	SymbolDecl(MakeResultState),
	SymbolDecl(MakeRoot),
	/* SymbolDecl(MakeRuleLock), */
	/* SymbolDecl(MakeRuleLockIntermediate), */
	/* SymbolDecl(MakeRuleLockIntermediateLock), */
	SymbolDecl(MakeScan),
	SymbolDecl(MakeScanState),
	SymbolDecl(MakeSeqScan),
	SymbolDecl(MakeSort),
	SymbolDecl(MakeSortKey),
	SymbolDecl(MakeSortState),
	SymbolDecl(MakeTLE),
	SymbolDecl(MakeTemp),
	SymbolDecl(MakeTimeRange),
	SymbolDecl(MakeVar),
	SymbolDecl(ModifyQueryTree),
	SymbolDecl(ScanKeywordLookup),
	SymbolDecl(StripRangeTable),
	SymbolDecl(VarnoGetRelname),
	SymbolDecl(add_clause_to_rels),
	SymbolDecl(add_join_clause_info_to_rels),
	SymbolDecl(add_pathlist),
	/* SymbolDecl(add_read_locks), */
	SymbolDecl(add_tl_element),
	SymbolDecl(add_vars_to_rels),
	SymbolDecl(and_clause),
	SymbolDecl(att_typeid),
/*	ExternDecl(attnum_type), */
/*	SymbolDecl(authnone_create), */
	SymbolDecl(best_innerjoin),
	SymbolDecl(best_or_subclause_index),
	SymbolDecl(best_or_subclause_indices),
	SymbolDecl(better_path),
	SymbolDecl(cheaper_path),
	SymbolDecl(clause_args),
	SymbolDecl(clause_head),
	SymbolDecl(clause_relids_vars),
	SymbolDecl(clause_subclauses),
	SymbolDecl(clause_type),
/*	SymbolDecl(clntudp_bufcreate), */
/*	SymbolDecl(clntudp_create), */
	SymbolDecl(cnfify),
/*	ExternDecl(codenames), */
	SymbolDecl(collect),
	SymbolDecl(collect_index_pathkeys),
	SymbolDecl(comphash),
	SymbolDecl(compute_attribute_width),
	SymbolDecl(compute_clause_selec),
	SymbolDecl(compute_joinrel_size),
	SymbolDecl(compute_rel_size),
	SymbolDecl(compute_rel_width),
	SymbolDecl(compute_selec),
	SymbolDecl(compute_targetlist_width),
	SymbolDecl(constant_p),
	SymbolDecl(contains_not),
	SymbolDecl(convtypeinfo),
	SymbolDecl(copy_seq_tree),
	SymbolDecl(copy_vars),
	SymbolDecl(cost_hash),
	SymbolDecl(cost_hashjoin),
	SymbolDecl(cost_index),
	SymbolDecl(cost_mergesort),
	SymbolDecl(cost_nestloop),
	SymbolDecl(cost_result),
	SymbolDecl(cost_seqscan),
	SymbolDecl(cost_sort),
	SymbolDecl(create_hashjoin_node),
	SymbolDecl(create_hashjoin_path),
	SymbolDecl(create_index_path),
	SymbolDecl(create_index_paths),
	SymbolDecl(create_indexscan_node),
	SymbolDecl(create_join_node),
	SymbolDecl(create_mergejoin_node),
	SymbolDecl(create_mergesort_path),
	SymbolDecl(create_nestloop_node),
	SymbolDecl(create_nestloop_path),
	SymbolDecl(create_or_index_paths),
	SymbolDecl(create_plan),
	SymbolDecl(create_scan_node),
	SymbolDecl(create_seqscan_node),
	SymbolDecl(create_seqscan_path),
	SymbolDecl(create_tl_element),
	SymbolDecl(distribute_args),
	SymbolDecl(find_all_inheritors),
	SymbolDecl(find_all_join_paths),
	/* SymbolDecl(find_all_vars), */
	SymbolDecl(find_clause_joins),
	SymbolDecl(find_clauseless_joins),
	SymbolDecl(find_if),
	SymbolDecl(find_if_not),
	SymbolDecl(find_index_paths),
	SymbolDecl(find_inheritance_children),
	SymbolDecl(find_join_paths),
	SymbolDecl(find_join_rels),
	SymbolDecl(find_joininfo_node),
	SymbolDecl(find_nots),
	SymbolDecl(find_paths),
	/* SymbolDecl(find_qual_update_vars), */
	SymbolDecl(find_rel_paths),
	SymbolDecl(find_relation_indices),
	SymbolDecl(find_secondary_index),
	/* SymbolDecl(find_tlist_read_vars), */
	SymbolDecl(find_version_parents),
	SymbolDecl(first_matching_rt_entry),
	SymbolDecl(fix_indxqual_references),
	SymbolDecl(fix_opid),
	SymbolDecl(fix_opids),
	SymbolDecl(fix_parsetree_attnums),
	SymbolDecl(fix_rangetable),
	SymbolDecl(fix_targetlist),
	SymbolDecl(flatten_tlist),
	SymbolDecl(flatten_tlist_vars),

	SymbolDecl(group_clauses_by_hashop),
	SymbolDecl(group_clauses_by_indexkey),
	SymbolDecl(group_clauses_by_order),
	SymbolDecl(index),
	SymbolDecl(index_info),
	SymbolDecl(index_innerjoin),
	SymbolDecl(index_outerjoin_references),
	SymbolDecl(index_selectivity),
	SymbolDecl(indexable_joinclauses),
	SymbolDecl(initialize_join_clause_info),
	SymbolDecl(initialize_qualification),
	SymbolDecl(initialize_targetlist),
	SymbolDecl(is_clause),
	SymbolDecl(is_funcclause),
	SymbolDecl(is_null),
	SymbolDecl(is_opclause),
#ifdef	sun
	SymbolDecl(isinf),
#endif
	SymbolDecl(join_clause_p),
	SymbolDecl(join_p),
	SymbolDecl(join_references),
	SymbolDecl(join_selectivity),
	SymbolDecl(joininfo_member),
	SymbolDecl(joinmethod_clauses),
	SymbolDecl(joinmethod_keys),
	SymbolDecl(make_andclause),
	SymbolDecl(make_append),
	SymbolDecl(make_clause),
	SymbolDecl(make_const),
	SymbolDecl(make_existential),
	SymbolDecl(make_funcclause),
	SymbolDecl(make_hash),
	SymbolDecl(make_hashjoin),
	SymbolDecl(make_indexscan),
	SymbolDecl(make_nestloop),
	SymbolDecl(make_notclause),
	SymbolDecl(make_op),
	SymbolDecl(make_opclause),
	SymbolDecl(make_orclause),
	/* SymbolDecl(make_parameterized_plans), */
	SymbolDecl(make_result),
	/* SymbolDecl(make_rule_lock), */
	/* SymbolDecl(make_rule_locks), */
	/* SymbolDecl(make_rule_plans), */
	SymbolDecl(make_seqscan),
	SymbolDecl(make_temp),
	SymbolDecl(make_var),
	SymbolDecl(left_oper),
	SymbolDecl(match_clause_to_indexkey),
	SymbolDecl(match_hashop_hashinfo),
	SymbolDecl(match_index_orclause),
	SymbolDecl(match_index_orclauses),
	SymbolDecl(match_indexkey_operand),
	SymbolDecl(match_order_mergeinfo),
	SymbolDecl(match_pathkey_joinkeys),
	SymbolDecl(match_pathkeys_joinkeys),
	SymbolDecl(match_paths_joinkeys),
	SymbolDecl(match_sortkeys_pathkeys),
	SymbolDecl(match_unsorted_inner),
	SymbolDecl(match_unsorted_outer),
	SymbolDecl(match_varid),
	SymbolDecl(matching2_tlvar),
	/* SymbolDecl(matching_rule_locks), */
	SymbolDecl(matching_tlvar),
	SymbolDecl(mergesortop),
	SymbolDecl(new_filestr),
	SymbolDecl(new_join_pathkey),
	SymbolDecl(new_join_pathkeys),
	SymbolDecl(new_join_tlist),
	SymbolDecl(new_joininfo_list),
	SymbolDecl(new_level_qual),
	SymbolDecl(new_level_tlist),
	SymbolDecl(new_matching_subkeys),
	SymbolDecl(new_rangetable_entry),
	SymbolDecl(new_relation_targetlist),
	SymbolDecl(new_result_qual),
	SymbolDecl(new_result_tlist),
	SymbolDecl(new_unsorted_tlist),
	/* SymbolDecl(no_var_read_locks_yet), */
	SymbolDecl(non_null),
	SymbolDecl(normalize),
	/* SymbolDecl(normalize_attnos), */
	SymbolDecl(not_clause),
	SymbolDecl(number_list),
	SymbolDecl(numlevels),
	SymbolDecl(op_class),
	SymbolDecl(op_hashjoinable),
	SymbolDecl(op_mergesortable),
	SymbolDecl(oper),
	SymbolDecl(oprid),
	SymbolDecl(or_clause),
	SymbolDecl(or_normalize),
	SymbolDecl(other_join_clause_var),
	SymbolDecl(outstr),
/*	ExternDecl(override), */
	/* SymbolDecl(parameterize), */
	SymbolDecl(plan_p),
	SymbolDecl(plan_union_queries),
	SymbolDecl(plan_union_query),
	SymbolDecl(preprocess_qualification),
	SymbolDecl(preprocess_targetlist),
	/* SymbolDecl(process_rules), */
	SymbolDecl(product_selec),
	SymbolDecl(prune_joinrel),
	SymbolDecl(prune_joinrels),
	SymbolDecl(prune_rel_path),
	SymbolDecl(prune_rel_paths),
	SymbolDecl(pull_ands),
	SymbolDecl(pull_args),
	SymbolDecl(pull_constant_clauses),
	SymbolDecl(pull_ors),
	SymbolDecl(pull_relation_level_clauses),
	SymbolDecl(pull_var_clause),
	SymbolDecl(push_nots),
	SymbolDecl(qual_clause_p),
	SymbolDecl(qualcleanup),
	SymbolDecl(query_planner),
	/* SymbolDecl(read_decorate), */
	SymbolDecl(rel_member),
	SymbolDecl(relation_info),
	SymbolDecl(relation_level_clause_p),
	SymbolDecl(relation_sortkeys),
	SymbolDecl(remove_ands),
	/* SymbolDecl(remove_duplicate_vars), */
	SymbolDecl(replace_clause_joinvar_refs),
	SymbolDecl(replace_clause_resultvar_refs),
	SymbolDecl(replace_joinvar_refs),
	SymbolDecl(replace_matching_resname),
	SymbolDecl(replace_opid),
	SymbolDecl(replace_resultvar_refs),
	SymbolDecl(replace_subclause_joinvar_refs),
	SymbolDecl(replace_subclause_resultvar_refs),
	SymbolDecl(restore_globals),
	SymbolDecl(restriction_selectivity),
	SymbolDecl(right_oper),
	SymbolDecl(samekeys),
	SymbolDecl(save_globals),
	SymbolDecl(scan_p),

	SymbolDecl(single_node),
	SymbolDecl(sort),
	SymbolDecl(sort_argv),
	SymbolDecl(sort_inner_and_outer),
	SymbolDecl(sort_level_result),
	SymbolDecl(sort_list_car),
	SymbolDecl(sort_relation_paths),
	SymbolDecl(subplanner),
	SymbolDecl(subst_rangetable),
	SymbolDecl(switch_outer),
	SymbolDecl(targetlist_resdom_numbers),
	SymbolDecl(tbyvalue),
	SymbolDecl(tname),
	SymbolDecl(translate_relid),
	SymbolDecl(tlist_member),
	SymbolDecl(tlist_temp_references),
	SymbolDecl(tlistentry_member),
	SymbolDecl(type),
	SymbolDecl(typeid),
	SymbolDecl(update_clauses),
	SymbolDecl(update_relations),
#ifndef sprite
	SymbolDecl(v1prot_dofirst),
	SymbolDecl(v1prot_donext),
#endif  /* !sprite */
	SymbolDecl(valid_numkeys),
	SymbolDecl(valid_or_clause),
	SymbolDecl(valid_sortkeys),
	SymbolDecl(var_equal),
	SymbolDecl(var_is_inner),
	SymbolDecl(var_is_mat),
	SymbolDecl(var_is_nested),
	SymbolDecl(var_is_outer),
	SymbolDecl(var_is_rel),

/* UTILITIES */
	SymbolDecl(DefineFunction),
	SymbolDecl(DefineIndex),
	SymbolDecl(DefineOperator),
	SymbolDecl(DefineRelation),
	SymbolDecl(DefineType),
	SymbolDecl(RemoveFunction),
	SymbolDecl(RemoveIndex),
	SymbolDecl(RemoveOperator),
	SymbolDecl(RemoveRelation),
	SymbolDecl(RemoveType),

/* MODULES */
	SymbolDecl(ExecMain),
	SymbolDecl(ExecutePlan),
	SymbolDecl(ProcessQuery),
	SymbolDecl(ProcessUtility),
	SymbolDecl(parser),
	SymbolDecl(planner),

	SymbolDecl(GetAttributeByName),
	SymbolDecl(GetAttributeByNum),

	/*
	 * Special defines:
	 *
	 * YOU_LOSE
	 *	Usage of this must be restricted by POSTGRES.
	 *
	 * YOU_WIN
	 *	Usage of this is strongly discourage but is allowed.
	 *
	 * Note:
	 *	These defines are only partially listed.
	 */

/* SECTION2 */
	SymbolDecl(accept),
	SymbolDecl(bind),
	SymbolDecl(chdir),
	SymbolDecl(close),
	SymbolDecl(connect),
	SymbolDecl(dup),
	SymbolDecl(fcntl),
	SymbolDecl(flock),
	SymbolDecl(fork),
	SymbolDecl(fstat),
	SymbolDecl(fsync),
	SymbolDecl(getdtablesize),
	SymbolDecl(geteuid),
	SymbolDecl(getuid),
	SymbolDecl(ioctl),
	SymbolDecl(kill),
	SymbolDecl(listen),
	SymbolDecl(lseek),
	SymbolDecl(open),
	SymbolDecl(read),
	SymbolDecl(rename),
	SymbolDecl(select),
	SymbolDecl(semctl),
	SymbolDecl(semget),
	SymbolDecl(semop),
	SymbolDecl(sendto),
	SymbolDecl(shmat),
	SymbolDecl(shmctl),
	SymbolDecl(shmdt),
	SymbolDecl(shmget),

#ifdef	YOU_LOSE
	SymbolDecl(sigblock),
	SymbolDecl(sigpause),
	SymbolDecl(sigsetmask),
	SymbolDecl(sigvec),
#endif
	SymbolDecl(socket),
	SymbolDecl(stat),
/*	SymbolDecl(syscall), */
	SymbolDecl(umask),
	SymbolDecl(unlink),
	SymbolDecl(write),
	SymbolDecl(writev),

/* SECTION3M */
	SymbolDecl(dexp),
#ifdef	sun
#ifndef NO_DMINUS
	SymbolDecl(dminus),
#endif
#endif
	SymbolDecl(dpow),
	SymbolDecl(dround),
	SymbolDecl(dsqrt),
	SymbolDecl(dtrunc),
#ifndef sprite
	SymbolDecl(exp),
	SymbolDecl(fabs),
	SymbolDecl(floor),
	SymbolDecl(log),
	SymbolDecl(log10),
	SymbolDecl(pow),
#ifndef	sequent
	SymbolDecl(rint),
#endif
	SymbolDecl(sqrt),
#endif /* !sprite */

/* SECTION3 */
#ifndef NO_ALLOCA
	SymbolDecl(alloca),
#endif
#ifndef sprite
	SymbolDecl(atof),
#endif /* !sprite */
	SymbolDecl(atoi),
	SymbolDecl(atol),
	SymbolDecl(bcmp),
	SymbolDecl(bcopy),
	SymbolDecl(bzero),

#ifndef	YOU_WIN
	SymbolDecl(calloc),
#endif
	SymbolDecl(ecvt),
	SymbolDecl(endhostent),
	SymbolDecl(endpwent),
	SymbolDecl(endservent),

#ifdef	YOU_LOSE
	SymbolDecl(_exit),
	SymbolDecl(exit),
#endif
	SymbolDecl(fclose),
	SymbolDecl(fcvt),
	SymbolDecl(fdopen),
	SymbolDecl(fflush),
#ifdef	sun
	SymbolDecl(fgetpwent),
#endif
	SymbolDecl(fgets),
	SymbolDecl(fopen),
	SymbolDecl(fprintf),
	SymbolDecl(fputs),
	SymbolDecl(fread),

#ifndef	YOU_WIN
	SymbolDecl(free),
#endif
	SymbolDecl(freopen),
	SymbolDecl(fscanf),
	SymbolDecl(fseek),
	SymbolDecl(gcvt),
	SymbolDecl(getenv),
	SymbolDecl(gethostbyaddr),
	SymbolDecl(gethostbyname),
/*	SymbolDecl(gethostent), */
	SymbolDecl(getpagesize),
	SymbolDecl(getpid),
	SymbolDecl(getpwent),
	SymbolDecl(getpwnam),
	SymbolDecl(getpwuid),
	SymbolDecl(gets),
	SymbolDecl(getservbyname),
	SymbolDecl(getservbyport),
	SymbolDecl(getservent),
	SymbolDecl(getsockname),
	SymbolDecl(gettimeofday),
	SymbolDecl(htons),
	SymbolDecl(isatty),

#ifdef	YOU_LOSE
	SymbolDecl(_longjmp),
	SymbolDecl(longjmp),
#endif
#ifdef	sun
	SymbolDecl(memalign),
#endif
/*	SymbolDecl(memccpy), */
	SymbolDecl(memchr),
	SymbolDecl(memcpy),
	SymbolDecl(memset),
	SymbolDecl(perror),
	SymbolDecl(printf),
	SymbolDecl(puts),
	SymbolDecl(qsort),
	SymbolDecl(random),

#ifndef	YOU_WIN
	SymbolDecl(realloc),
#endif
	SymbolDecl(rewind),
	SymbolDecl(scanf),
	SymbolDecl(setbuf),
	SymbolDecl(setstate),
	SymbolDecl(sethostent),

#ifdef	YOU_LOSE
	SymbolDecl(_setjmp),
	SymbolDecl(setjmp),
#endif
	SymbolDecl(setpwent),
	SymbolDecl(setreuid),
	SymbolDecl(setservent),
	SymbolDecl(setuid),

#ifdef	YOU_LOSE
	SymbolDecl(signal),
#endif
	SymbolDecl(sleep),
	SymbolDecl(sprintf),
	SymbolDecl(srandom),
	SymbolDecl(sscanf),
	SymbolDecl(strcat),
	SymbolDecl(strchr),
	SymbolDecl(strcmp),
	SymbolDecl(strcpy),
	SymbolDecl(strlen),
	SymbolDecl(strncmp),
	SymbolDecl(strncpy),
	SymbolDecl(strtol),
	SymbolDecl(sys_errlist),
	SymbolDecl(time),
	SymbolDecl(ungetc),
/* not YOU_WIN */
/*	SymbolDecl(valloc), */

	NULL, NULL
};

#ifdef sun
#ifndef sparc
asm("	.data");
asm("	.even");
asm("	.globl	_SunSyms");
asm("_SunSyms:");
asm("	.long	Fcmpd");
asm("	.data2");
asm("L35:");
asm("	.ascii	\"Fcmpd\\0\"");
asm("	.data");
asm("	.long	L35");
asm("	.long	0");
asm("	.long	0");
#endif
#endif
