/*     
 *      FILE
 *     	storeplan
 *     
 *      DESCRIPTION
 *     	Routines to store and retrieve plans
 *
 *      IDENTIFICATION
 *      $Header: /private/postgres/src/planner/sys/RCS/storeplan.c,v 1.11 1991/02/05 15:50:02 sp Exp $
 *     
 */

#include "tmp/postgres.h"

#include "rules/params.h"
#include "utils/log.h"
#include "utils/palloc.h"

#include "nodes/nodes.h"
#include "nodes/pg_lisp.h"

/*-------------------------------------------------
 *
 * StringToPlan
 *     given a string (generated by "PlanToString")
 *     reconstruct the plan (or any (?) other LispValue
 *     structure).
 */
LispValue
StringToPlan (string)
	char *string;
{
	extern LispValue lispReadString();
	return(lispReadString(string));

}

 
/*-------------------------------------------------
 *
 * StringToPlanWithParams
 *     Same as StringToPlan, but it also returns
 *     an array (of type ParamListInfo) of all the Param
 *     nodes
 */
LispValue
StringToPlanWithParams (string, paramListP)
	char *string;
	ParamListInfo * paramListP;
{
	extern LispValue lispReadStringWithParams();
	return(lispReadStringWithParams(string, paramListP));

}


/*--------------------------------------------------------------
 *
 * PlanToString
 *
 * Given a plan (a lisp list, i.e. a LispValue) transform it
 * into a string.
 */
char *
PlanToString(l)
LispValue l;
{
    char *s;
    s = lispOut(l);
    return(s);

}
