/*
 * pdir.h --
 *	POSTGRES directory path definitions.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/tmp/RCS/pdir.h,v 1.2 1990/08/17 08:54:31 cimarron Exp $
 */

#ifndef	PDirIncluded		/* Include this file only once */
#define PDirIncluded	1

#include "tmp/c.h"

#define PDIR_H	"$Header: /private/postgres/src/lib/H/tmp/RCS/pdir.h,v 1.2 1990/08/17 08:54:31 cimarron Exp $"

/*
 * GetDatabasePath --
 *	Returns path to database.
 *
 * Exceptions:
 *	BadState if called before InitDatabase.
 */
extern
String		/* XXX Path */
GetDatabasePath ARGS((
	void
));

/*
 * GetDatabaseName --
 *	Returns name of database.
 *
 * Exceptions:
 *	BadState if called before InitDatabase.
 */
extern
String		/* XXX Name */
GetDatabaseName ARGS((
	void
));

/*
 * InitDatabase --
 *	Sets current directory appropriately for given path and name.
 *
 * Arguments:
 *	Path and name are invalid if it invalid as a string.
 *	Path is "badly formated" if it is not a string containing a path
 *	to a writable directory.
 *	Name is "badly formated" if it contains more than 16 characters or if
 *	it is a bad file name (e.g., it contains a '/' or an 8-bit character).
 *
 * Side effects:
 *	Initially, DatabasePath and DatabaseName are invalid.  They are
 *	set to valid strings before this function returns.
 *
 * Exceptions:
 *	BadState if called more than once.
 *	BadArg if both path and name are "badly formated" or invalid.
 *	BadArg if path and name are both "inconsistent" and valid.
 */
extern
void
InitDatabase ARGS((
	String	path,	/* XXX Path */
	String	name	/* XXX Name */
));

#endif	/* !defined(PDirIncluded) */
