/*
 *  version.h
 * 
 *  Header file for versions.
 *
 *  $Header: /private/postgres/src/lib/H/commands/RCS/version.h,v 1.4 1991/11/10 20:47:17 clarsen Exp $
 */

#ifndef VersionIncluded          /* Include this file only once */
#define VersionIncluded  1

#include "tmp/postgres.h"

/*
 *  Creates a version.
 */
extern 
void
CreateVersion ARGS(( 
		    Name  name,
		    List bname));

/*
 *  Creates the deltas.
 */
extern
void
VersionCreate ARGS((
		    Name  vname,
		    Name  bname));


/*
 *  Returns a list of attributes for the given relation.
 */
extern 
LispValue
GetAttrList ARGS(( Name bname));

/*
 * Rule governing the append semantics for versions.
 */
extern
void
VersionAppend ARGS((
		    Name  vname,
		    Name  bname));

/*
 * Rule governing the retrieval semantics for versions.
 */
extern
void
VersionRetrieve ARGS((
		      Name  vname,
		      Name  bname,
		      char *snapshot));

/*
 * Rule governing the delete semantics for versions.
 */
extern
void
VersionDelete ARGS((
		    Name  vname,
		    Name  bname,
		    char *snapshot));

/*
 * Rule governing the update semantics for versions.
 */
extern
void
VersionReplace ARGS((
		     Name  vname,
		     Name  bname,
		     char *snapshot));
    
#endif
