/*
 * ibit.h --
 *	POSTGRES index valid attribute bit map definitions.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/access/RCS/ibit.h,v 1.7 1991/04/28 09:15:45 cimarron Exp $
 */

#ifndef	IBitIncluded	/* Include this file only once. */
#define IBitIncluded	1

#include "tmp/c.h"
#include "utils/memutils.h"

typedef struct IndexAttributeBitMapData {
	char	bits[(MaxIndexAttributeNumber + MaxBitsPerByte - 1)
		/ MaxBitsPerByte];
} IndexAttributeBitMapData;

typedef IndexAttributeBitMapData	*IndexAttributeBitMap;

#define IndexAttributeBitMapSize	sizeof(IndexAttributeBitMapData)

/*
 * IndexAttributeBitMapIsValid --
 *	True iff attribute bit map is valid.
 */
#define	IndexAttributeBitMapIsValid(bits) PointerIsValid(bits)

#endif	/* !defined(IBitIncluded) */
