/*
 *  boundingbox.h -- declarations for rectangles (used by rtree code)
 *
 *	$Header: /private/postgres/src/lib/H/access/RCS/boundingbox.h,v 1.3 1989/09/05 17:03:54 mao Version_2 $
 */

/* Define structures for containing rectangles. */
struct rectangle 
	{
	float		lowx;
	float		lowy;
	float		highx;
	float		highy;
	};

#ifndef HORIZONTAL
#define HORIZONTAL  1
#define VERTICAL    2
#endif
typedef	struct rectangle  Rect;

#define	BOUNDBOX Rect

#define	INSIDE_BOX(box,d) 	(Inside_Box((d),(box)))

#define	OVERLAP_BOX(box,d)  (Overlap_Box((d),(box)))

#define	NEW_ENCLOSE_BOX(out,current,new)	(Surround_Box(out,current,new))

#define NORTHOF_BOX(box,d)	((d)->lowy > (box)->lowy)
#define SOUTHOF_BOX(box,d)	((d)->highy < (box)->highy)
#define EASTOF_BOX(box,d)	((d)->lowx > (box)->lowx)
#define WESTOF_BOX(box,d)	((d)->highx < (box)->highx)

#define	SPLIT_DIRECTION(encl, north, south, east, west)	\
					(split_choice(encl,north,south,east,west))

#define	FIND_BEST_INSERT_BOX(d,ba,n)	(find_best_insertion_box((d),(ba),(n)))

