#include "config.mk"
#include "port.mk"
#include "files.postgres"

.SUFFIXES: .c .o .lex .y

PMSRCS = src/support/postmaster.c

PATHPMSRCS = $(SD)/support/postmaster.c

PMOBJS= $(OD)/support/postmaster.o

PMLINKS= $(OD)/LIB.o $(OD)/port/$(PORTNAME)/port.o $(OD)/UTIL.o \
		 $(OD)/STORAGE.o $(OD)/ACCESS.o $(STUBOBJS) $(INH_OBJ)

$(OD)/support/postmaster: $(OD)/support/postmasterlinks $(PMLINKS) $(PMOBJS)
	@ echo "linking postmaster"
	@ $(CC) $(LDFLAGS) -o $(OD)/support/postmaster \
		$(PMOBJS) $(PMLINKS) $(OD)/libpq.a $(LIBS)
	@ sh -c 'if (test $$STRIPOBJS = "t" ) then \
		    strip $(OD)/support/postmaster ; \
		 else true ; fi'

missing: $(PMOBJS)
	@ echo "nm'ing postmaster .o's " ; \
	cd $(OD); \
	rm -f ../newconf/pm.nm ; \
	nm -o $(PMOBJS) $(OTHOBJS)  \
	 > ../newconf/pm.nm

postmasterlinks: $(OD)/support/postmasterlinks

postmaster: $(OD)/support/postmaster

puremaster:
	@ echo "linking a pure postmaster"
	@ purify $(CC) $(LDFLAGS) -o $(OD)/support/postmaster \
		$(PMOBJS) $(PMLINKS) $(OD)/libpq.a $(LIBS)


$(OD)/support/postmasterlinks: 
	@- echo "checking symbolic links ...." ; \
	cd $(OD)/support ; \
	for x in $(PMSRCS) ;do \
	    p=`echo $$x | sed -e 's:[^/]*/::g' ` ; \
	    if  [ -f $$p ] ; then \
		echo > /dev/null ; \
	    else \
		echo linking $$p ; \
		ln -s $(TREE)/$$x ; \
	    fi ; \
	done ; \
	touch postmasterlinks

.y.o:
	@ echo yaccing $(<F) ; \
	cd $(@D) ; yacc -d $(<F)
	-@ cd $(@D) ; \
	if [ -f yacc.sed ] ; then \
		echo "sed'ing y.tab.c" ; \
		sed -f yacc.sed < y.tab.c > $*.c ; \
		rm -f y.tab.c ; \
	else \
	 	mv y.tab.c $*.c ; \
	fi
	-@ cd $(@D) ; \
	echo "   ... compiling $*.c" ; \
	$(CC) $(CFLAGS) -c $*.c 

.c.o:
	@ echo compiling $(<F)
	@ cd $(@D) ; $(CC) $(CFLAGS) -DPOSTMASTER \
	-DPOSTMASTERLOG -DPG_STANDALONE -DVACUUMDLOG -c $(<F) 

.lex.o:
	@ echo lexing $(<F) ; \
	cd $(@D) ; lex $(<F)
	-@ cd $(@D) ; \
	if [ -f lex.sed ] ; then \
		echo "sed'ing lex.yy.c" ; \
		sed -f lex.sed < lex.yy.c > $*.c; \
	else \
		mv lex.yy.c $*.c ; \
	fi
	@ cd $(@D) ; \
	echo "   ... compiling $*.c" ; \
	$(CC) $(CFLAGS) -c $*.c
