/*
 * Wait for a string on the stdin.  Returns a 0 on success, 1 on failure
 * and -1 on error.  This is an external program designed to be used in
 * shell scripts.
 */

#define TIMEOUT	10
#define BUF_SIZ	1024

#include <stdio.h>
#include <signal.h>
#include "config.h"

#ifdef BSD
#include <setjmp.h>
jmp_buf wf_buf;
#endif /* BSD */

main(argc, argv)
int argc;
char *argv[];
{
	int i, j, timeout, diff, length;
	char c, buf[BUF_SIZ], *string;
	long t, time();
	void exit();

	if (argc < 2 || argc > 3) {
		fprintf(stderr, "Usage: waitfor -n string\n");
		exit(-1);
	}

	if (argv[1][0] == '-') {
		timeout = atoi(&argv[1][1]);
		if (argc != 3) {
			fprintf(stderr, "Usage: waitfor -n string\n");
			exit(-1);
		}
		string = argv[2];
	}
	else {
		timeout = TIMEOUT;
		string = argv[1];
	}
					/* here we go.. */
	i = 0;
	length = strlen(string);
	time(&t);
	while ((time((long *) 0) - t) < timeout) {
		if ((j = getc_line()) != -1) {
			c = j & 0x7f;
					/* no NULLs please */
			if (c == '\0')
				continue;

			buf[i++] = c;
			buf[i] = '\0';
					/* roll the buffer over */
			if (i == BUF_SIZ -1) {
				strncpy(buf, &buf[BUF_SIZ/2], BUF_SIZ/2);
				i = BUF_SIZ/2;
			}
					/* is it possible? */
			diff = i - length;
			if (diff < 0)
				continue;

			if (!strcmp(&buf[diff], string))
				exit(0);
		}
	}
	exit(1);
}

static int wf_flag;
static int wf_force();

int
getc_line()
{
	char c;
	unsigned int alarm();

	signal(SIGALRM, (SIG_TYPE(*) ()) wf_force);
	wf_flag = 0;

	alarm(1);

#ifdef BSD
	if (setjmp(wf_buf))
		return(-1);
#endif /* BSD */

	if (read(0, &c, 1) <= 0) {
		alarm(0);
		return(-1);
	}
	if (wf_flag)
		return(-1);
	alarm(0);
	return(c & 0xff);
}

/* ARGSUSED */
static int
wf_force(dummy)
int dummy;
{
#ifdef BSD
	longjmp(wf_buf, 1);
#else /* BSD */
	signal(SIGALRM, (SIG_TYPE(*) ()) wf_force);
	wf_flag = 1;
	return(0);
#endif /* BSD */
}
