/*
 * The IPC and multiplexed I/O routines for AT&T flavors of Unix
 */

#include <stdio.h>
#ifndef MAIN
#include <stropts.h>
#include <poll.h>
#include <fcntl.h>
#include <sys/stream.h>
#include "ipc.h"

#define PSEUDO_TTY	"/dev/ptmx"

static struct pollfd fds[3];
static int time_out;

void
ipc_init(tty_fd, cmd_fd)
int tty_fd, cmd_fd;
{
	fds[0].fd = 0;			/* the keyboard */
	fds[0].events = POLLIN;
	fds[0].revents = 0;
	fds[1].fd = tty_fd;		/* the TTY */
	fds[1].events = POLLIN;
	fds[1].revents = 0;
	fds[2].fd = cmd_fd;		/* the shell script */
	fds[2].events = POLLIN;
	fds[2].revents = 0;
					/* 1 sec loop, or wait forever */
	if (cmd_fd != -1)
		time_out = 1000000;
	else
		time_out = -1;
	return;
}

/* ARGSUSED */
int
ipc_poll(tty_fd, cmd_fd)
int tty_fd, cmd_fd;
{
	int ret_code;

	poll(fds, 3, time_out);

	ret_code = 0;
	if (fds[0].revents & POLLIN)
		ret_code |= KEY_READY;

	if (fds[1].revents & POLLIN)
		ret_code |= TTY_READY;

	if (fds[2].revents & POLLIN)
		ret_code |= CMD_READY;

	return(ret_code);
}

/*
 * Update the file descriptors for poll()/select() that might have changed.
 */

void
ipc_update(tty_fd, cmd_fd)
int tty_fd, cmd_fd;
{
	fds[1].fd = tty_fd;
	fds[2].fd = cmd_fd;

	if (cmd_fd != -1)
		time_out = 1000000;
	else
		time_out = -1;
	return;
}

/*
 * Open an IPC "channel"
 */

int
ipc_open()
{
	int fd;

	if ((fd = open(PSEUDO_TTY, O_RDWR)) < 0)
		return(-1);

	grantpt(fd);
	unlockpt(fd);
	return(fd);
}

/*
 * Close an IPC channel
 */

int
ipc_close(fd)
int fd;
{
	return(close(fd));
}

/*
 * Return a unique "key" to pass to the child process 
 */

char *
ipc_key(fd)
int fd;
{
	char *ptsname();

	return(ptsname(fd));
}
#endif /* MAIN */

/*
 * Attach to an existing IPC channel
 */

int
ipc_attach(dev, mode)
char *dev;
int mode;
{
	return(open(dev, mode));
}

/*
 * Detach from an IPC channel
 */

int
ipc_detach(fd)
int fd;
{
	return(close(fd));
}

/*
 * Read from an IPC channel
 */

int
ipc_read(fd, buf, n)
int fd;
char *buf;
int n;
{
	if (read(fd, buf, n) != n)
		return(1);
	return(0);
}

/*
 * Write to an IPC channel
 */

int
ipc_write(fd, buf, n)
int fd;
char *buf;
int n;
{
	if (write(fd, buf, n) != n)
		return(1);
	return(0);
}
