.TH XMESSAGE 1 "20 August 1991" "X Version 11"
.SH NAME
xmessage \- display a message or query in a window (X-based /bin/echo)
.SH SYNOPSIS
.B xmessage
[
.B \-buttons
.I label1\fR[\fP:value1\fR]\fP\fB,\fPlabel2\fR[\fP:value2\fR]\fP\fB,\fP\|.\|.\|.
] [
.I options
]
.B \-file
.I filename
.br
.B xmessage
[
.B \-buttons
.I label1\fR[\fP:value1\fR]\fP\fB,\fPlabel2\fR[\fP:value2\fR]\fP\fB,\fP\|.\|.\|.
] [
.I options
]
.I message
\&.\|.\|.
.SH DESCRIPTION
.I Xmessage
displays a window containing a message from the command line, a file,
or standard input.
Along the lower edge of the message is row
of buttons; clicking the left mouse button
on any of these buttons will cause \fIxmessage\fP to exit.
Which button was pressed is returned in the exit status and,
optionally, by writing the label of the button to standard output.
.PP
.I Xmessage
is typically used by shell scripts to display information to the user
or to ask the user to make a choice.
.SH OPTIONS
These are the command line options that \fIxmessage\fP understands.
.TP 8
.B \-buttons \fIbutton,button,.\|.\|.\fP
This option will cause \fIxmessage\fP to create one button for each
comma-separated \fIbutton\fP argument.
The corresponding resource is \fBbuttons\fP.
Each \fIbutton\fP consists of a label optionally followed by a colon
and an exit value.
The label is the name of the Command button widget created and will be the 
default text displayed to the user.  Since this is the name of the widget
it may be used to change any of the resources associated with that button.
The exit value will be returned by \fIxmessage\fP
if that button is selected.  The default exit value is 100 plus the
button number.  Buttons are numbered from the left starting with one.
The default string if no \fB\-buttons\fP option is given is \fBokay:0\fP.
.TP 8
.B \-default \fIlabel\fP
Defines the button with a matching \fIlabel\fP to be the default.
If not specified there is no default.
The corresponding resource is \fBdefaultButton\fP.
Pressing Return anywhere in the \fIxmessage\fP window will activate
the default button.
The default button has a wider border than the others.
.TP 8
.B \-file \fIfilename\fP
File to display.
The corresponding resource is \fBfile\fP.
A \fIfilename\fP of `\fB\-\fP' reads from standard input.
If this option is not supplied, \fIxmessage\fP will
display all non-option arguments in the style of \fIecho\fP.
Either \fB\-file\fP or a message on the command line
should be provided, but not both.
.TP 8
.B \-print
This will cause the program to print the label of the button pressed to
standard output.  Equivalent to setting the \fBprintValue\fP resource
to TRUE.
This is one way to get feedback as to which button was pressed.
.SH "WIDGET HIERARCHY"
Knowing the name and position in the hierarchy of each widget is
useful when specifying resources for them.  In the chart below, the
class and name of each widget is given.
.LP
.nf
Xmessage (xmessage)
	Form form
		Label message
		Command (label1)
		Command (label2)
		.
		.
		.
.fi
.SH RESOURCES
\fIXmessage\fP has a few top-level application resources that allow
customizations that are specific to \fIxmessage\fP. 
.TP 8
.B file
A String resource specifying the file to display.
.TP 8
.B buttons
A String resource specifying the buttons to display.
See the \fB\-buttons\fP command-line option.
.TP 8
.B defaultButton
A String resource specifying a default button by label.
.TP 8
.B printValue
A Boolean resource that determines whether or not the label of the 
button pressed to exit the program is printed.  The default is FALSE.
.SH ACTIONS
.TP 8
.B exit(\fIvalue\fP)
exit immediately with an exit status of \fIvalue\fP (default 0).  This
action can be used with translations to provide alternate ways of
exiting \fIxmessage\fP.
.TP 8
.B default-exit()
exit immediately with the exit status specified by the default button.
If there is no default button, this action has no effect.
.SH "EXIT STATUS"
If it detects an error, \fIxmessage\fP returns 1, so this value should
not be used with a button.
.SH "SEE ALSO"
.IR X (1),
.IR echo (1),
.IR cat (1)
.SH COPYRIGHT
Copyright 1988,1991 Massachusetts Institute of Technology.
.br
See \fIX\fP(1) for a full statement of rights and permissions.
.SH AUTHORS
Chris Peterson, MIT Project Athena 
.br
Stephen Gildea, MIT X Consortium
