/* -------------------------------------------------------------------------- */
/* X-SURFACE                                                                  */
/* 3rd Year Project: "Three dimensional surface graphics"                     */
/* Written January-May 1993                                                   */
/* Robert Manners & Dominick Layfield                                         */
/* -------------------------------------------------------------------------- */

#include "surface.h"
#include <math.h>

/* -------------------------------------------------------------------------- */
/* Global variables ...                                                       */
/* -------------------------------------------------------------------------- */

/* X-Windows variables */
XtAppContext app_context;
Widget bezier, control, connectivity, status, popupshell, exitbutton, 
       viewbutton, xbutton, ybutton, zbutton, savebutton, loadbutton, 
       defaultviewbutton, dispitemsbutton, clearbutton, continuitybutton, 
       numlinesbutton;
Display *controldisplay, *bezierdisplay, *connectivitydisplay, *statusdisplay;
Window controlwindow, bezierwindow, connectivitywindow, statuswindow;
GC gc, gcclear; 
#ifdef DOUBLEBUFFERING
Pixmap controlpixmap, bezierpixmap; 
#endif

/* View parameters */
FLOATTYPE r = DEFAULTR, 
       theta = DEFAULTTHETA, 
       phi = DEFAULTPHI, 
       vpdist = DEFAULTVPDIST;
vector R;

/* Window data (width, height, scale) */
windowdata cpwindow, bswindow, cnwindow;

/* Display parameters */
int numlines = DEFAULTNUMLINES;
Itemsmode itemsmode = DEFAULTITEMS;
Continuitymode continuitymode = DEFAULTCONTINUITY;

/* Pointer to whole object structure */
objectdata *object;



/* ------------------------------------------------------------------------- */
/* Main program body                                                         */
/* ------------------------------------------------------------------------- */

int main(int argc, char **argv)
{
   setupwindows(argc, argv);
   setupgc();
   updatestatus(3, "Welcome to XSurface"); 

   object = initobject();
   calcmatrices(numlines);
   calctransform(object);
   calccontrol(object);
   drawcontrol(object); 
   calcbezier(object);
   displaybezier(object);
   drawconnectivity(object); 

   #ifdef DEBUG
   check(object);
   #endif

   XtAppMainLoop(app_context);
 
   return 0;
}
