#include "surface.h"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

/* Scope of axis limited to this source file */
static struct axis axis;

/* Generate screen coordinates of control points */
void calccontrol(objectdata * object)
{
   extern struct axis axis;
   extern FLOATTYPE phi, theta;
   extern windowdata cpwindow;

   vertex *vertexptr;

   /* Loop through vertices */
   vertexptr = object->firstvertex;
   do {
      transformpoint(vertexptr, &cpwindow);
   } while ((vertexptr = vertexptr->next) != NULL);

   /* Calculate axis diagram positions 'by hand' */
   axis.x1 = (Position) AXISPOSX - cpwindow.width * AXISSIZE * SIN(theta);
   axis.y1 = (Position) AXISPOSY + cpwindow.height * AXISSIZE * COS(phi) * COS(theta);
   axis.x2 = (Position) AXISPOSX - cpwindow.width * AXISSIZE * COS(theta);
   axis.y2 = (Position) AXISPOSY - cpwindow.height * AXISSIZE * COS(phi) * SIN(theta);
   axis.x3 = (Position) AXISPOSX;
   axis.y3 = (Position) AXISPOSY + cpwindow.height * AXISSIZE * SIN(phi);
}

/* Display object */
void drawcontrol(objectdata * object)
{
   extern Display *controldisplay;
   extern Window controlwindow;
   extern GC gc;
   extern Itemsmode itemsmode;
   extern struct axis axis;
   extern FLOATTYPE vpdist;
   extern windowdata cpwindow;

   patch *patchptr, *finish;
   int i, j;
   FLOATTYPE dotscale = cpwindow.scale * DOTSIZE * vpdist; 

#ifdef DOUBLEBUFFERING
   extern Pixmap controlpixmap;
   extern GC gcclear;   
 
   /* Erase old pixmap */
   XCopyArea(controldisplay, controlpixmap, controlpixmap, 
             gcclear, 0, 0, cpwindow.width, cpwindow.height, 0, 0); 
#else
   /* Erase old window */
   XClearWindow(controldisplay, controlwindow);
#endif 

   /* Set loop for current patch/all patches */
   if (itemsmode == ALL) {
      patchptr = object->firstpatch;
      finish = NULL;
   } else {
      patchptr = object->currentpatch;
      finish = object->currentpatch->next;
   }

   do {
      /* Draw scaled circles to represent control points */
      if (patchptr == object->currentpatch) {
         for (i = 0; i < 4; i++)
            for (j = 0; j < 4; j++) {
               if (!patchptr->data[i][j]->screen.viewcode)
                  drawfilledpoint(patchptr->data[i][j]->screen);
            }
      } else {
         for (i = 0; i < 4; i++)
            for (j = 0; j < 4; j++) {
               if (!patchptr->data[i][j]->screen.viewcode)
                  drawopenpoint(patchptr->data[i][j]->screen);
            }
      }
      /* Draw lines between circles */
      for (i = 0; i < 4; i++)
         for (j = 0; j < 3; j++)
            clipline(&(patchptr->data[i][j]->screen), 
                     &(patchptr->data[i][j + 1]->screen), controldisplay,
                     (Drawable) CONTROLDRAWABLE, gc, &cpwindow);
      for (i = 0; i < 3; i++)
         for (j = 0; j < 4; j++)
            clipline(&(patchptr->data[i][j]->screen), 
                     &(patchptr->data[i + 1][j]->screen), controldisplay,
                     (Drawable) CONTROLDRAWABLE, gc, &cpwindow); 

   } while ((patchptr = patchptr->next) != finish);

   /* Now draw axis-diagram in bottom left corner of control window */
   XDrawLine(controldisplay, CONTROLDRAWABLE, gc, AXISPOSX, AXISPOSY, 
             axis.x1, axis.y1); 
   XDrawLine(controldisplay, CONTROLDRAWABLE, gc, AXISPOSX, AXISPOSY, 
             axis.x2, axis.y2); 
   XDrawLine(controldisplay, CONTROLDRAWABLE, gc, AXISPOSX, AXISPOSY, 
             axis.x3, axis.y3);

   /* Put text on axis diagram */
   XDrawString(controldisplay, CONTROLDRAWABLE, gc, axis.x1, axis.y1, "x", 1); 
   XDrawString(controldisplay, CONTROLDRAWABLE, gc, axis.x2, axis.y2, "y", 1);
   XDrawString(controldisplay, CONTROLDRAWABLE, gc, axis.x3, axis.y3, "z", 1);

#ifdef DOUBLEBUFFERING
   /* Display new pixmap */
   XCopyArea(controldisplay, controlpixmap, controlwindow, gc, 0, 0, 
             cpwindow.width, cpwindow.height, 0, 0); 
#endif
}
