/* Canvas.c */
/* Modified version of Canvas widget code from the Oxford Widget Set */
/* Written by Jon Tomb and Mark Bush */

/* This version is reformatted, converted to ANSIish C */
/* Event Mask of widget now allows ConfigureNotify events to be passed on */
/* Dom Layfield, June 1993 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "CanvasP.h"

static XtResource resources[] = 
{ 
  /* {name, class, type, size, offset, default_type, default_addr}, */
  {XtNdrawingColor, XtCColor, XtRPixel, sizeof(Pixel), 
            XtOffset(CanvasWidget, canvas.color), XtRString, XtDefaultForeground},
  {XtNfont, XtCFont, XtRFontStruct, sizeof(XFontStruct *), 
                   XtOffset(CanvasWidget, canvas.font), XtRString, XtDefaultFont},
  {XtNexposeCallback, XtCCallback, XtRCallback, sizeof(XtCallbackList), 
               XtOffset(CanvasWidget, canvas.expose_callback), XtRCallback, NULL},
  {XtNcallback, XtCCallback, XtRCallback, sizeof(XtCallbackList), 
          XtOffset(CanvasWidget, canvas.canvasAction_callback), XtRCallback, NULL}
};

/* static void CanvasAction(Widget, XEvent*, String*, Cardinal*); */

static void InputAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  XtCallCallbacks(w, XtNcallback, (XtPointer) event);
}


static XtActionsRec actions[] =
{
  /* {name, procedure}, */
  {"canvasAction", InputAction},
};

static char translations[] =
"<Key>:              canvasAction() \n\
 <BtnDown>:          canvasAction() \n\
 <BtnUp>:            canvasAction() \n\
 <BtnMotion>:        canvasAction() \n\
 <Motion>:           canvasAction() \n\
 <ConfigureNotify>:  canvasAction()";

static void Redisplay(Widget w, XEvent *event, Region region)
{
  XtCallCallbacks(w, XtNexposeCallback, (XtPointer) region);
}

CanvasClassRec canvasClassRec = {
  { /* core fields */                        
    /* superclass            */  (WidgetClass) &widgetClassRec,
    /* class_name            */  "Canvas",
    /* widget_size           */  sizeof(CanvasRec),
    /* class_initialize      */  NULL,
    /* class_part_initialize */  NULL,
    /* class_inited          */  FALSE,
    /* initialize            */  NULL,
    /* initialize_hook       */  NULL,
    /* realize               */  XtInheritRealize,
    /* actions               */  actions,
    /* num_actions           */  XtNumber(actions),
    /* resources             */  resources,
    /* num_resources         */  XtNumber(resources),
    /* xrm_class             */  NULLQUARK,
    /* compress_motion       */  TRUE,
    /* compress_exposure     */  TRUE,
    /* compress_enterleave   */  TRUE,
    /* visible_interest      */  FALSE,
    /* destroy               */  NULL,
    /* resize                */  NULL,
    /* expose                */  Redisplay,
    /* set_values            */  NULL,
    /* set_values_hook       */  NULL,
    /* set_values_almost     */  XtInheritSetValuesAlmost,
    /* get_values_hook       */  NULL,
    /* accept_focus          */  NULL,
    /* version               */  XtVersion,
    /* callback_private      */  NULL,
    /* tm_table              */  translations,
    /* query_geometry        */  XtInheritQueryGeometry,
    /* display_accelerator   */  XtInheritDisplayAccelerator,
    /* extension             */  NULL
  },
  { /* canvas fields */
    /* empty                 */ 0
  }
};

Pixel WindowColor(Widget w)
{
  return (((CanvasWidget) w)->canvas.color);
}

Font WindowFont(Widget w)
{
  return (((CanvasWidget) w)->canvas.font->fid);
}

WidgetClass canvasWidgetClass = (WidgetClass) & canvasClassRec;
